/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.parsers;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.ColumnInfo;
import com.ibm.commerce.jpa.port.info.ConstraintInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.ForeignKeyInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.info.TableInfo;
import com.ibm.commerce.jpa.port.parsers.EjbAccessBeanClassParser;
import com.ibm.commerce.jpa.port.parsers.EjbClassParser;
import com.ibm.commerce.jpa.port.parsers.EjbEntityCreationDataClassParser;
import com.ibm.commerce.jpa.port.parsers.EjbJarXmlParser;
import com.ibm.commerce.jpa.port.parsers.EjbKeyClassParser;
import com.ibm.commerce.jpa.port.parsers.HomeInterfaceParser;
import com.ibm.commerce.jpa.port.parsers.IbmEjbAccessBeanXmiParser;
import com.ibm.commerce.jpa.port.parsers.IbmEjbJarBndXmiParser;
import com.ibm.commerce.jpa.port.parsers.IbmEjbJarExtXmiParser;
import com.ibm.commerce.jpa.port.parsers.LocalHomeInterfaceParser;
import com.ibm.commerce.jpa.port.parsers.LocalInterfaceParser;
import com.ibm.commerce.jpa.port.parsers.MapXmiParser;
import com.ibm.commerce.jpa.port.parsers.RemoteInterfaceParser;
import com.ibm.commerce.jpa.port.parsers.SchemaDbmParser;
import com.ibm.commerce.jpa.port.util.ApplicationInfoUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;

public class ModuleParser {
    private static final Logger LOGGER = LoggerHelper.getLogger(ModuleParser.class);
    private static final String META_INF = "META-INF";
    private static final String EJB_JAR_XML = "ejb-jar.xml";
    private static final String IBM_EJB_ACCESS_BEAN_XMI = "ibm-ejb-access-bean.xmi";
    private static final String IBM_EJB_JAR_EXT_XMI = "ibm-ejb-jar-ext.xmi";
    private static final String IBM_EJB_JAR_BND_XMI = "ibm-ejb-jar-bnd.xmi";
    private static final String BACKENDS = "backends";
    private static final String MAP_XMI = "Map.mapxmi";
    private static final String DBM = "dbm";
    private static final String EJB_DEPLOY = "ejbdeploy";
    private static final String WEBSPHERE_DEPLOY = "websphere_deploy";
    private ASTParser iASTParser = ASTParser.newParser((int)3);
    private ModuleInfo iModuleInfo;
    private ApplicationInfo iApplicationInfo;
    private IJavaProject iJavaProject;
    private IWorkspace iWorkspace;

    public ModuleParser(IWorkspace workspace, ModuleInfo moduleInfo) {
        LOGGER.info("Parsing module " + moduleInfo.getJavaProject().getElementName());
        this.iModuleInfo = moduleInfo;
        this.iApplicationInfo = this.iModuleInfo.getApplicationInfo();
        this.iJavaProject = moduleInfo.getJavaProject();
        this.iWorkspace = workspace;
    }

    public IStatus parse(IProgressMonitor progressMonitor) {
        IStatus status = Status.OK_STATUS;
        try {
            try {
                IClasspathEntry[] classpathEntries;
                progressMonitor.beginTask("parse " + this.iJavaProject.getProject().getName(), 1000 + this.iModuleInfo.getEntities().size() * 1400 + 1000);
                IClasspathEntry[] iClasspathEntryArray = classpathEntries = this.iJavaProject.getResolvedClasspath(true);
                int n = classpathEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (progressMonitor.isCanceled()) {
                        status = Status.CANCEL_STATUS;
                        break;
                    }
                    if (entry.getEntryKind() == 3) {
                        IResource[] members;
                        IFolder backends;
                        IFile ibmEjbAccessBeanXmiFile;
                        IFile ibmEjbJarBndXmiFile;
                        IFile ibmEjbJarExtXmiFile;
                        IPath path = entry.getPath();
                        IFile ejbJarXmlFile = this.iWorkspace.getRoot().getFile(path.append(META_INF).append(EJB_JAR_XML));
                        if (ejbJarXmlFile.exists()) {
                            EjbJarXmlParser parser = new EjbJarXmlParser(ejbJarXmlFile, this.iModuleInfo);
                            parser.parse();
                        }
                        if ((ibmEjbJarExtXmiFile = this.iWorkspace.getRoot().getFile(path.append(META_INF).append(IBM_EJB_JAR_EXT_XMI))).exists()) {
                            IbmEjbJarExtXmiParser parser = new IbmEjbJarExtXmiParser(ibmEjbJarExtXmiFile, this.iModuleInfo);
                            parser.parse();
                        }
                        if ((ibmEjbJarBndXmiFile = this.iWorkspace.getRoot().getFile(path.append(META_INF).append(IBM_EJB_JAR_BND_XMI))).exists()) {
                            IbmEjbJarBndXmiParser parser = new IbmEjbJarBndXmiParser(ibmEjbJarBndXmiFile, this.iModuleInfo);
                            parser.parse();
                        }
                        if ((ibmEjbAccessBeanXmiFile = this.iWorkspace.getRoot().getFile(path.append(META_INF).append(IBM_EJB_ACCESS_BEAN_XMI))).exists()) {
                            IbmEjbAccessBeanXmiParser parser = new IbmEjbAccessBeanXmiParser(ibmEjbAccessBeanXmiFile, this.iModuleInfo);
                            parser.parse();
                        }
                        if ((backends = this.iWorkspace.getRoot().getFolder(path.append(META_INF).append(BACKENDS))).exists() && (members = backends.members()) != null) {
                            IResource[] iResourceArray = members;
                            int n3 = members.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IResource member = iResourceArray[n4];
                                if (member instanceof IFolder) {
                                    IResource[] dbFolderMembers;
                                    IFolder dbFolder = (IFolder)member;
                                    IResource[] iResourceArray2 = dbFolderMembers = dbFolder.members();
                                    int n5 = dbFolderMembers.length;
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        IFile dbFolderFile;
                                        IResource dbFolderMember = iResourceArray2[n6];
                                        if (dbFolderMember instanceof IFile && DBM.equals((dbFolderFile = (IFile)dbFolderMember).getFileExtension())) {
                                            SchemaDbmParser parser = new SchemaDbmParser(dbFolderFile, this.iModuleInfo);
                                            parser.parse();
                                        }
                                        ++n6;
                                    }
                                    IFile mapXmiFile = dbFolder.getFile(MAP_XMI);
                                    if (mapXmiFile.exists()) {
                                        MapXmiParser parser = new MapXmiParser(mapXmiFile, this.iModuleInfo);
                                        parser.parse();
                                    }
                                }
                                ++n4;
                            }
                        }
                        IFolder folder = this.iWorkspace.getRoot().getFolder(path);
                        this.parseFolder(folder);
                    }
                    ++n2;
                }
                progressMonitor.worked(1000);
                Collection<EntityInfo> entities = this.iModuleInfo.getEntities();
                for (EntityInfo entityInfo : entities) {
                    if (progressMonitor.isCanceled()) {
                        status = Status.CANCEL_STATUS;
                        break;
                    }
                    if (entityInfo.getSupertype() != null) continue;
                    this.parseEntity(progressMonitor, entityInfo);
                }
                for (EntityInfo entityInfo : entities) {
                    if (progressMonitor.isCanceled()) {
                        status = Status.CANCEL_STATUS;
                        break;
                    }
                    if (entityInfo.getSupertype() == null) continue;
                    this.parseEntity(progressMonitor, entityInfo);
                }
                if (!progressMonitor.isCanceled()) {
                    this.resolveForeignKeys();
                } else {
                    status = Status.CANCEL_STATUS;
                }
                progressMonitor.worked(1000);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
            catch (CoreException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
        return status;
    }

    private void parseFolder(IFolder folder) throws CoreException {
        IResource[] members;
        IResource[] iResourceArray = members = folder.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member.getType() == 2) {
                if (WEBSPHERE_DEPLOY.equals(member.getName()) || EJB_DEPLOY.equals(member.getName())) {
                    this.parseDeleteIntendedFolder((IFolder)member);
                } else {
                    this.parseFolder((IFolder)member);
                }
            }
            ++n2;
        }
    }

    private void parseDeleteIntendedFolder(IFolder folder) throws CoreException {
        IResource[] members;
        IResource[] iResourceArray = members = folder.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            IResource member = iResourceArray[n2];
            if (member.getType() == 2) {
                this.parseDeleteIntendedFolder((IFolder)member);
            } else if (member.getType() == 1 && (file = (IFile)member).getName().endsWith(".java")) {
                IJavaElement javaElement = JavaCore.create((IFile)file);
                this.iModuleInfo.addDeleteIntendedType(((ICompilationUnit)javaElement).getTypes()[0].getFullyQualifiedName('.'));
            }
            ++n2;
        }
    }

    private void parseEntity(IProgressMonitor progressMonitor, EntityInfo entityInfo) {
        HomeInterfaceParser homeInterfaceParser = new HomeInterfaceParser(this.iASTParser, entityInfo);
        homeInterfaceParser.parse((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
        LocalHomeInterfaceParser localHomeInterfaceParser = new LocalHomeInterfaceParser(this.iASTParser, entityInfo);
        localHomeInterfaceParser.parse((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
        RemoteInterfaceParser remoteInterfaceParser = new RemoteInterfaceParser(this.iASTParser, entityInfo);
        remoteInterfaceParser.parse((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
        LocalInterfaceParser localInterfaceParser = new LocalInterfaceParser(this.iASTParser, entityInfo);
        localInterfaceParser.parse((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
        EjbClassParser ejbClassParser = new EjbClassParser(this.iASTParser, entityInfo);
        ejbClassParser.parse((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
        EjbKeyClassParser ejbKeyClassParser = new EjbKeyClassParser(this.iASTParser, entityInfo);
        ejbKeyClassParser.parse((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
        if (entityInfo.getAccessBeanInfo() != null && !entityInfo.getAccessBeanInfo().getDataClassType()) {
            EjbAccessBeanClassParser ejbAccessBeanClassParser = new EjbAccessBeanClassParser(this.iASTParser, entityInfo);
            ejbAccessBeanClassParser.parse((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
        } else if (entityInfo.getEjbAccessBeanType() != null) {
            this.iModuleInfo.addDeleteIntendedType(entityInfo.getEjbAccessBeanType().getFullyQualifiedName('.'));
        }
        if (entityInfo.getAccessBeanInfo() != null) {
            Collection<String> accessBeanInterfaces = entityInfo.getAccessBeanInfo().getAccessBeanInterfaces();
            for (String accessBeanInterfaceName : accessBeanInterfaces) {
                this.iModuleInfo.addDeleteIntendedType(accessBeanInterfaceName);
            }
        }
        EjbEntityCreationDataClassParser ejbEntityCreationDataClassParser = new EjbEntityCreationDataClassParser(this.iASTParser, entityInfo);
        ejbEntityCreationDataClassParser.parse((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
        if (entityInfo.getEjbFinderObjectType() != null) {
            this.iModuleInfo.addDeleteIntendedType(entityInfo.getEjbFinderObjectType().getFullyQualifiedName('.'));
            if (entityInfo.getEjbFinderObjectBaseType() != null) {
                this.iModuleInfo.addDeleteIntendedType(entityInfo.getEjbFinderObjectBaseType().getFullyQualifiedName('.'));
            }
        }
        if (entityInfo.getFactoryType() != null) {
            this.iModuleInfo.addDeleteIntendedType(entityInfo.getFactoryType().getFullyQualifiedName('.'));
        }
        if (entityInfo.getEjbAccessHelperType() != null) {
            this.iModuleInfo.addDeleteIntendedType(entityInfo.getEjbAccessHelperType().getFullyQualifiedName('.'));
        }
        ApplicationInfoUtil.resolveTypeMappings(this.iApplicationInfo, entityInfo);
    }

    private void resolveForeignKeys() {
        Collection<TableInfo> tables = this.iModuleInfo.getTables();
        for (TableInfo table : tables) {
            Collection<ConstraintInfo> constraints = table.getConstraints();
            for (ConstraintInfo constraintInfo : constraints) {
                if (!constraintInfo.getType().equals("SQLConstraints:ForeignKey")) continue;
                ForeignKeyInfo foreignKeyInfo = new ForeignKeyInfo(table);
                String[] members = constraintInfo.getMembers();
                String[] referencedMembers = constraintInfo.getReferencedMembers();
                ArrayList<ColumnInfo> memberColumns = new ArrayList<ColumnInfo>();
                ArrayList<ColumnInfo> referencedColumns = new ArrayList<ColumnInfo>();
                TableInfo parentTable = null;
                String referencedTable = constraintInfo.getReferencedTable();
                if (referencedTable != null && referencedMembers == null) {
                    parentTable = this.iModuleInfo.getTableInfo(referencedTable);
                    referencedColumns.addAll(parentTable.getPrimaryKeyColumns());
                }
                int i = 0;
                while (i < members.length) {
                    memberColumns.add(this.iModuleInfo.getColumnInfo(members[i]));
                    if (referencedMembers != null) {
                        referencedColumns.add(this.iModuleInfo.getColumnInfo(referencedMembers[i]));
                    }
                    ++i;
                }
                while (memberColumns.size() > 0) {
                    ColumnInfo memberColumn = (ColumnInfo)memberColumns.remove(0);
                    ColumnInfo referencedColumn = null;
                    int i2 = 0;
                    while (i2 < referencedColumns.size()) {
                        if (memberColumn.getColumnName().equals(((ColumnInfo)referencedColumns.get(i2)).getColumnName())) {
                            referencedColumn = (ColumnInfo)referencedColumns.remove(i2);
                            break;
                        }
                        ++i2;
                    }
                    if (referencedColumn == null) {
                        referencedColumn = (ColumnInfo)referencedColumns.remove(0);
                    }
                    parentTable = referencedColumn.getTableInfo();
                    foreignKeyInfo.addMember(memberColumn, referencedColumn);
                }
                foreignKeyInfo.setParentTableInfo(parentTable);
                table.addForeignKey(foreignKeyInfo);
                constraintInfo.setForeignKeyInfo(foreignKeyInfo);
            }
        }
    }
}

