/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.parsers;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.ColumnInfo;
import com.ibm.commerce.jpa.port.info.ConstraintInfo;
import com.ibm.commerce.jpa.port.info.EjbRelationInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.FieldInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.info.TableInfo;
import com.ibm.commerce.jpa.port.util.XMLUtil;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapXmiParser {
    private static final Logger LOGGER = LoggerHelper.getLogger(MapXmiParser.class);
    private static final String NESTED = "nested";
    private static final String HELPER = "helper";
    private static final String INPUTS = "inputs";
    private static final String OUTPUTS = "outputs";
    private static final String TYPE = "xmi:type";
    private static final String HREF = "href";
    private static final String EJB_MAPPER = "ejbrdbmapping:RDBEjbMapper";
    private static final String PERSISTENT_TABLE = "SQLTables:PersistentTable";
    private static final String LUW_TABLE = "LUW:LUWTable";
    private static final String ORACLE_TABLE = "OracleModel:OracleTable";
    private static final String CONTAINER_MANAGED_ENTITY = "ejb:ContainerManagedEntity";
    private static final String PRIMARY_TABLE_STRATEGY = "ejbrdbmapping:PrimaryTableStrategy";
    private static final String EJB_FIELD_MAPPER = "ejbrdbmapping:RDBEjbFieldMapper";
    private static final String SQLTABLES_COLUMN = "SQLTables:Column";
    private static final String LUW_COLUMN = "LUW:LUWColumn";
    private static final String CMP_ATTRIBUTE = "ejb:CMPAttribute";
    private static final String EJB_CONVERTER = "ejbrdbmapping:EJBConverter";
    private static final String TARGET_CLASS = "targetClass";
    private static final String TRANSFORMER_CLASS = "transformerClass";
    private static final String INHERITED_PRIMARY_TABLE_STRATEGY = "ejbrdbmapping:InheritedPrimaryTableStrategy";
    private static final String DISCRIMINATOR_VALUES = "discriminatorValues";
    private static final String DISCRIMINATOR_MEMBERS = "discriminatorMembers";
    private static final String SECONDARY_STRATEGY = "secondaryStrategy";
    private static final String TABLE = "table";
    private static final String JOIN_KEY = "joinKey";
    private static final String TYPE_MAPPING = "typeMapping";
    private static final String EJB_RELATIONSHIP_ROLE = "ejb:EJBRelationshipRole";
    private static final String SQL_CONSTRAINTS_FOREIGN_KEY = "SQLConstraints:ForeignKey";
    private IFile iFile;
    private ModuleInfo iModuleInfo;

    public MapXmiParser(IFile file, ModuleInfo moduleInfo) {
        this.iFile = file;
        this.iModuleInfo = moduleInfo;
    }

    public void parse() {
        Document document = this.iModuleInfo.getXMLUtil().readXml(this.iFile);
        this.parseEjbRdbDocumentRootElement(document.getDocumentElement());
        this.iModuleInfo.getApplicationInfo().incrementParsedAssetCount();
    }

    private void parseEjbRdbDocumentRootElement(Element ejbRdbDocumentRootElement) {
        NodeList childNodes = ejbRdbDocumentRootElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                String type = element.getAttribute(TYPE);
                if (NESTED.equals(nodeName) && EJB_MAPPER.equals(type)) {
                    this.parseEjbMapperElement(element);
                }
            }
            ++i;
        }
    }

    private void parseEjbMapperElement(Element ejbMapperElement) {
        String type;
        String nodeName;
        Element element;
        Object node;
        EntityInfo entityInfo = null;
        ArrayList<TableInfo> tables = new ArrayList<TableInfo>();
        NodeList childNodes = ejbMapperElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                element = (Element)node;
                nodeName = element.getNodeName();
                type = element.getAttribute(TYPE);
                if ((INPUTS.equals(nodeName) || OUTPUTS.equals(nodeName)) && (PERSISTENT_TABLE.equals(type) || LUW_TABLE.equals(type) || ORACLE_TABLE.equals(type))) {
                    tables.add(this.iModuleInfo.getTableInfo(this.getIdFromHref(element)));
                } else if ((INPUTS.equals(nodeName) || OUTPUTS.equals(nodeName)) && CONTAINER_MANAGED_ENTITY.equals(type)) {
                    entityInfo = this.iModuleInfo.getEntityInfo(this.getIdFromHref(element));
                }
            }
            ++i;
        }
        if (entityInfo != null) {
            for (TableInfo tableInfo : tables) {
                entityInfo.addTable(tableInfo);
            }
            i = 0;
            while (i < childNodes.getLength()) {
                node = childNodes.item(i);
                if (node.getNodeType() == 1) {
                    element = (Element)node;
                    nodeName = element.getNodeName();
                    type = element.getAttribute(TYPE);
                    if (HELPER.equals(nodeName) && PRIMARY_TABLE_STRATEGY.equals(type)) {
                        this.parsePrimaryTableStrategyElement(element, entityInfo);
                    } else if (HELPER.equals(nodeName) && INHERITED_PRIMARY_TABLE_STRATEGY.equals(type)) {
                        this.parseInheritedPrimaryTableStrategyElement(element, entityInfo);
                    } else if (NESTED.equals(nodeName) && EJB_FIELD_MAPPER.equals(type)) {
                        this.parseEjbFieldMapperElement(element, entityInfo);
                    }
                }
                ++i;
            }
        }
    }

    private void parsePrimaryTableStrategyElement(Element primaryTableStrategyElement, EntityInfo entityInfo) {
        String discriminatorMemberId = null;
        NodeList childNodes = primaryTableStrategyElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (DISCRIMINATOR_VALUES.equals(nodeName)) {
                    entityInfo.setDiscriminatorValue(XMLUtil.getElementText(element));
                } else if (DISCRIMINATOR_MEMBERS.equals(nodeName)) {
                    discriminatorMemberId = this.getIdFromHref(element);
                } else if (TABLE.equals(nodeName)) {
                    LOGGER.info(String.valueOf(this.getClass().getCanonicalName()) + "]: file: " + this.iFile.getName());
                    LOGGER.info(String.valueOf(this.getClass().getCanonicalName()) + "]:" + this.getIdFromHref(element));
                    entityInfo.setPrimaryTableInfo(this.iModuleInfo.getTableInfo(this.getIdFromHref(element)));
                }
            }
            ++i;
        }
        if (discriminatorMemberId != null) {
            entityInfo.setDiscriminatorColumnInfo(this.iModuleInfo.getColumnInfo(discriminatorMemberId));
        }
    }

    private void parseInheritedPrimaryTableStrategyElement(Element inheritedPrimaryTableStrategyElement, EntityInfo entityInfo) {
        NodeList childNodes = inheritedPrimaryTableStrategyElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (DISCRIMINATOR_VALUES.equals(nodeName)) {
                    entityInfo.setDiscriminatorValue(XMLUtil.getElementText(element));
                } else if (SECONDARY_STRATEGY.equals(nodeName)) {
                    this.parseSecondaryStrategyElement(element, entityInfo);
                }
            }
            ++i;
        }
    }

    private void parseSecondaryStrategyElement(Element secondaryStrategyElement, EntityInfo entityInfo) {
        TableInfo tableInfo = null;
        String joinKeyId = null;
        NodeList childNodes = secondaryStrategyElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (TABLE.equals(nodeName)) {
                    tableInfo = this.iModuleInfo.getTableInfo(this.getIdFromHref(element));
                    entityInfo.setSecondaryTableInfo(tableInfo);
                } else if (JOIN_KEY.equals(nodeName)) {
                    joinKeyId = this.getIdFromHref(element);
                }
            }
            ++i;
        }
        entityInfo.setJoinKey(tableInfo.getConstraintInfo(joinKeyId));
    }

    private void parseEjbFieldMapperElement(Element ejbFieldMapperElement, EntityInfo entityInfo) {
        ColumnInfo columnInfo = null;
        FieldInfo fieldInfo = null;
        EjbRelationInfo ejbRelationInfo = null;
        ConstraintInfo constraintInfo = null;
        NodeList childNodes = ejbFieldMapperElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                String type = element.getAttribute(TYPE);
                if ((INPUTS.equals(nodeName) || OUTPUTS.equals(nodeName)) && (SQLTABLES_COLUMN.equals(type) || LUW_COLUMN.equals(type))) {
                    columnInfo = this.iModuleInfo.getColumnInfo(this.getIdFromHref(element));
                } else if ((OUTPUTS.equals(nodeName) || INPUTS.equals(nodeName)) && CMP_ATTRIBUTE.equals(type)) {
                    fieldInfo = entityInfo.getFieldInfo(this.getIdFromHref(element));
                } else if (INPUTS.equals(nodeName) && EJB_RELATIONSHIP_ROLE.equals(type)) {
                    ejbRelationInfo = this.iModuleInfo.getEjbRelationshipRoleInfo(this.getIdFromHref(element)).getEjbRelationInfo();
                } else if (OUTPUTS.equals(nodeName) && SQL_CONSTRAINTS_FOREIGN_KEY.equals(type)) {
                    constraintInfo = this.iModuleInfo.getConstraintInfo(this.getIdFromHref(element));
                }
            }
            ++i;
        }
        if (fieldInfo != null) {
            fieldInfo.setColumnInfo(columnInfo);
            Set<EntityInfo> subEntities = entityInfo.getSubtypes();
            if (subEntities != null) {
                for (EntityInfo subEntity : subEntities) {
                    FieldInfo subFieldInfo = subEntity.getFieldInfoByName(fieldInfo.getFieldName());
                    if (subFieldInfo == null) continue;
                    subFieldInfo.setColumnInfo(columnInfo);
                    this.parseEjbFieldMapperElement(ejbFieldMapperElement, subFieldInfo);
                }
            }
        } else if (ejbRelationInfo != null) {
            ejbRelationInfo.setConstraintInfo(constraintInfo);
        } else {
            LOGGER.info("no field or ejb relation info " + this.iModuleInfo.getJavaProject().getElementName() + " " + ejbFieldMapperElement.getAttribute("xmi:id"));
        }
    }

    private void parseEjbFieldMapperElement(Element ejbFieldMapperElement, FieldInfo fieldInfo) {
        NodeList childNodes = ejbFieldMapperElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                String type = element.getAttribute(TYPE);
                if (HELPER.equals(nodeName) && EJB_CONVERTER.equals(type)) {
                    this.parseEjbConverterElement(element, fieldInfo);
                } else if (TYPE_MAPPING.equals(nodeName)) {
                    fieldInfo.setTypeMapping(this.getIdFromHref(element));
                }
            }
            ++i;
        }
    }

    private void parseEjbConverterElement(Element ejbConverterElement, FieldInfo fieldInfo) {
        NodeList childNodes = ejbConverterElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (TARGET_CLASS.equals(nodeName)) {
                    fieldInfo.setTargetClass(element.getAttribute(HREF));
                } else if (TRANSFORMER_CLASS.equals(nodeName)) {
                    fieldInfo.setTransformerClass(element.getAttribute(HREF));
                }
            }
            ++i;
        }
    }

    private String getIdFromHref(Element element) {
        String href;
        int index;
        String id = null;
        if (element.hasAttribute(HREF) && (index = (href = element.getAttribute(HREF)).indexOf(35)) > -1) {
            id = href.substring(index + 1);
        }
        return id;
    }
}

