/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.parsers;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.info.UserMethodInfo;
import com.ibm.commerce.jpa.port.util.AbstractEntityDataUtil;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class LocalInterfaceParser {
    private static final Logger LOGGER = LoggerHelper.getLogger(LocalInterfaceParser.class);
    private static final String PROTECTABLE = "com.ibm.commerce.security.Protectable";
    private static final String GROUPABLE = "com.ibm.commerce.grouping.Groupable";
    private static final String EJB_LOCAL_OBJECT = "javax.ejb.EJBLocalObject";
    private static final Set<String> STANDARD_INTERFACES = new HashSet<String>();
    private static final Set<String> STANDARD_METHODS;
    private static final String EJS_LOCAL_CMP = "EJSLocalCMP";
    private ASTParser iASTParser;
    private EntityInfo iEntityInfo;
    private ModuleInfo iModuleInfo;

    static {
        STANDARD_INTERFACES.add(PROTECTABLE);
        STANDARD_INTERFACES.add(GROUPABLE);
        STANDARD_INTERFACES.add(EJB_LOCAL_OBJECT);
        STANDARD_METHODS = new HashSet<String>();
    }

    public LocalInterfaceParser(ASTParser astParser, EntityInfo entityInfo) {
        this.iASTParser = astParser;
        this.iEntityInfo = entityInfo;
        this.iModuleInfo = entityInfo.getModuleInfo();
    }

    public void parse(IProgressMonitor progressMonitor) {
        try {
            try {
                progressMonitor.beginTask("parse local interface for " + this.iEntityInfo.getEjbName(), -1);
                IType localInterface = this.iEntityInfo.getLocalType();
                if (localInterface != null) {
                    this.parseInterface(progressMonitor, localInterface);
                    ITypeHierarchy typeHierarchy = localInterface.newTypeHierarchy(this.iModuleInfo.getJavaProject(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                    IType[] implementingClasses = typeHierarchy.getImplementingClasses(localInterface);
                    if (implementingClasses != null) {
                        IType[] iTypeArray = implementingClasses;
                        int n = implementingClasses.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType implementingClass = iTypeArray[n2];
                            String typeName = implementingClass.getTypeQualifiedName();
                            if (typeName.startsWith(EJS_LOCAL_CMP)) {
                                this.iModuleInfo.addDeleteIntendedType(implementingClass.getFullyQualifiedName('.'));
                            } else {
                                LOGGER.info("unexpected remote interface implementor: " + implementingClass.getFullyQualifiedName('.'));
                            }
                            ++n2;
                        }
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private void parseInterface(IProgressMonitor progressMonitor, IType interfaceType) throws JavaModelException {
        String[] superInterfaceNames;
        this.iModuleInfo.addDeleteIntendedType(interfaceType.getFullyQualifiedName('.'));
        String[] stringArray = superInterfaceNames = interfaceType.getSuperInterfaceNames();
        int n = superInterfaceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String superInterfaceName = stringArray[n2];
            IType superInterface = JavaUtil.resolveType(interfaceType, superInterfaceName);
            if (superInterface != null) {
                superInterfaceName = superInterface.getFullyQualifiedName('.');
                if (PROTECTABLE.equals(superInterfaceName)) {
                    this.iEntityInfo.setProtectable(true);
                } else if (GROUPABLE.equals(superInterfaceName)) {
                    this.iEntityInfo.setGroupable(true);
                }
                if (!STANDARD_INTERFACES.contains(superInterfaceName) && superInterface.getResource() != null && superInterface.getResource().getProject() == interfaceType.getResource().getProject()) {
                    this.parseInterface(progressMonitor, superInterface);
                }
            }
            ++n2;
        }
        this.iASTParser.setResolveBindings(true);
        this.iASTParser.setSource(interfaceType.getCompilationUnit());
        CompilationUnit compilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
        TypeDeclaration typeDeclaration = (TypeDeclaration)compilationUnit.types().get(0);
        List bodyDeclarations = typeDeclaration.bodyDeclarations();
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (bodyDeclaration.getNodeType() != 31) continue;
            this.parseMethodDeclaration(interfaceType, (MethodDeclaration)bodyDeclaration);
            progressMonitor.worked(100);
        }
        this.iModuleInfo.getApplicationInfo().incrementParsedAssetCount();
    }

    private void parseMethodDeclaration(IType interfaceType, MethodDeclaration methodDeclaration) {
        String methodName = methodDeclaration.getName().getIdentifier();
        if (!STANDARD_METHODS.contains(methodName)) {
            UserMethodInfo userMethodInfo = new UserMethodInfo(methodName);
            List parameters = methodDeclaration.parameters();
            for (SingleVariableDeclaration parameter : parameters) {
                String parameterName = parameter.getName().getIdentifier();
                Type parameterType = parameter.getType();
                String parameterTypeName = parameterType.resolveBinding().getQualifiedName();
                int i = 0;
                while (i < parameter.getExtraDimensions()) {
                    parameterTypeName = String.valueOf(parameterTypeName) + "[]";
                    ++i;
                }
                userMethodInfo.addParameter(parameterName, parameterTypeName);
            }
            Type returnType = methodDeclaration.getReturnType2();
            if (!(returnType == null || returnType.isPrimitiveType() && ((PrimitiveType)returnType).getPrimitiveTypeCode() == PrimitiveType.VOID)) {
                userMethodInfo.setReturnType(returnType.resolveBinding().getQualifiedName());
            }
            boolean entityDataUserMethod = false;
            if (userMethodInfo.getParameterTypes().size() == 1) {
                entityDataUserMethod = this.isEntityDataType(interfaceType, userMethodInfo.getParameterTypes().get(0));
            } else if (userMethodInfo.getReturnType() != null) {
                entityDataUserMethod = this.isEntityDataType(interfaceType, userMethodInfo.getReturnType());
            }
            if (!entityDataUserMethod) {
                this.iEntityInfo.addUserMethod(userMethodInfo);
            }
        }
    }

    private boolean isEntityDataType(IType interfaceType, String typeName) {
        IType type = JavaUtil.resolveType(interfaceType, typeName);
        return AbstractEntityDataUtil.isAbstractEntityDataType(type);
    }
}

