/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.parsers;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.FinderInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.util.AbstractEntityDataUtil;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class LocalHomeInterfaceParser {
    private static final Logger LOGGER = LoggerHelper.getLogger(LocalHomeInterfaceParser.class);
    private static final String CREATE = "create";
    private static final String FIND = "find";
    private static final String FIND_BY_PRIMARY_KEY = "findByPrimaryKey";
    private static final String EJS_LOCAL_CMP = "EJSLocalCMP";
    private EntityInfo iEntityInfo;
    private ModuleInfo iModuleInfo;
    private ASTParser iASTParser;

    public LocalHomeInterfaceParser(ASTParser astParser, EntityInfo entityInfo) {
        this.iASTParser = astParser;
        this.iEntityInfo = entityInfo;
        this.iModuleInfo = entityInfo.getModuleInfo();
    }

    public void parse(IProgressMonitor progressMonitor) {
        try {
            try {
                progressMonitor.beginTask("parse local home interface for " + this.iEntityInfo.getEjbName(), -1);
                IType localHomeInterface = this.iEntityInfo.getLocalHomeType();
                if (localHomeInterface != null) {
                    this.parseInterface(progressMonitor, localHomeInterface);
                    ITypeHierarchy typeHierarchy = localHomeInterface.newTypeHierarchy(this.iModuleInfo.getJavaProject(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                    IType[] implementingClasses = typeHierarchy.getImplementingClasses(localHomeInterface);
                    if (implementingClasses != null) {
                        IType[] iTypeArray = implementingClasses;
                        int n = implementingClasses.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType implementingClass = iTypeArray[n2];
                            String typeName = implementingClass.getTypeQualifiedName();
                            if (typeName.startsWith(EJS_LOCAL_CMP)) {
                                this.iModuleInfo.addDeleteIntendedType(implementingClass.getFullyQualifiedName('.'));
                                String homeBeanClassName = implementingClass.getFullyQualifiedName('.').replace("Home", "HomeBean").replace(EJS_LOCAL_CMP, "EJSCMP");
                                IType homeBeanClassType = JavaUtil.resolveType(implementingClass, homeBeanClassName);
                                if (homeBeanClassType != null) {
                                    this.iModuleInfo.addDeleteIntendedType(homeBeanClassName);
                                }
                            } else {
                                LOGGER.info("unexpected local home interface implementor: " + implementingClass.getFullyQualifiedName('.'));
                            }
                            ++n2;
                        }
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private void parseInterface(IProgressMonitor progressMonitor, IType interfaceType) throws JavaModelException {
        String[] superInterfaceNames;
        this.iModuleInfo.addDeleteIntendedType(interfaceType.getFullyQualifiedName('.'));
        String[] stringArray = superInterfaceNames = interfaceType.getSuperInterfaceNames();
        int n = superInterfaceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String superInterfaceName = stringArray[n2];
            IType superInterface = JavaUtil.resolveType(interfaceType, superInterfaceName);
            if (superInterface != null && superInterface.getResource() != null && superInterface.getResource().getProject() == interfaceType.getResource().getProject()) {
                this.parseInterface(progressMonitor, superInterface);
            }
            ++n2;
        }
        this.iASTParser.setResolveBindings(true);
        this.iASTParser.setSource(interfaceType.getCompilationUnit());
        CompilationUnit compilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
        TypeDeclaration typeDeclaration = (TypeDeclaration)compilationUnit.types().get(0);
        List bodyDeclarations = typeDeclaration.bodyDeclarations();
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (bodyDeclaration.getNodeType() != 31) continue;
            this.parseMethodDeclaration(interfaceType, (MethodDeclaration)bodyDeclaration);
            progressMonitor.worked(100);
        }
        this.iModuleInfo.getApplicationInfo().incrementParsedAssetCount();
    }

    private void parseMethodDeclaration(IType interfaceType, MethodDeclaration methodDeclaration) {
        String methodName = methodDeclaration.getName().getIdentifier();
        List parameters = methodDeclaration.parameters();
        String[] parameterTypes = new String[parameters.size()];
        int i = 0;
        for (SingleVariableDeclaration parameter : parameters) {
            Type parameterType = parameter.getType();
            parameterTypes[i] = parameterType.resolveBinding().getQualifiedName();
            int j = 0;
            while (j < parameter.getExtraDimensions()) {
                int n = i;
                parameterTypes[n] = String.valueOf(parameterTypes[n]) + "[]";
                ++j;
            }
            ++i;
        }
        if (methodName.startsWith(FIND) && !methodName.equals(FIND_BY_PRIMARY_KEY)) {
            FinderInfo finderInfo = this.iEntityInfo.getFinderInfo(methodName, parameterTypes, true);
            finderInfo.setInHomeInterface(true);
            int parameterIndex = 0;
            for (SingleVariableDeclaration parameter : parameters) {
                finderInfo.setFinderMethodParameterName(parameterIndex, parameter.getName().getIdentifier());
                ++parameterIndex;
            }
            finderInfo.setFinderMethodReturnType(methodDeclaration.getReturnType2().resolveBinding().getQualifiedName());
        } else if (CREATE.equals(methodName)) {
            boolean entityDataCreator = false;
            if (parameters.size() == 1) {
                entityDataCreator = this.isEntityDataType(interfaceType, parameterTypes[0]);
            }
            if (!entityDataCreator && parameters.size() > 0) {
                this.iEntityInfo.getCreatorInfo(parameterTypes, true);
            }
        }
    }

    private boolean isEntityDataType(IType interfaceType, String typeName) {
        IType type = JavaUtil.resolveType(interfaceType, typeName);
        return AbstractEntityDataUtil.isAbstractEntityDataType(type);
    }
}

