/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.parsers;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.GenerationProperties;
import com.ibm.commerce.jpa.port.info.EjbLocalRefInfo;
import com.ibm.commerce.jpa.port.info.EjbRelationInfo;
import com.ibm.commerce.jpa.port.info.EjbRelationshipRoleInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.FieldInfo;
import com.ibm.commerce.jpa.port.info.FinderInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.util.XMLUtil;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EjbJarXmlParser {
    private static final Logger LOGGER = LoggerHelper.getLogger(EjbJarXmlParser.class);
    private static final String ENTERPRISE_BEANS = "enterprise-beans";
    private static final String ENTITY = "entity";
    private static final String ID = "id";
    private static final String EJB_NAME = "ejb-name";
    private static final String HOME = "home";
    private static final String REMOTE = "remote";
    private static final String EJB_CLASS = "ejb-class";
    private static final String PRIM_KEY_CLASS = "prim-key-class";
    private static final String PRIM_KEY_FIELD = "primkey-field";
    private static final String LOCAL_HOME = "local-home";
    private static final String LOCAL = "local";
    private static final String CMP_VERSION = "cmp-version";
    private static final String CMP_FIELD = "cmp-field";
    private static final String FIELD_NAME = "field-name";
    private static final String ABSTRACT_SCHEMA_NAME = "abstract-schema-name";
    private static final String EJB_LOCAL_REF = "ejb-local-ref";
    private static final String EJB_REF_NAME = "ejb-ref-name";
    private static final String EJB_REF_TYPE = "ejb-ref-type";
    private static final String EJB_LINK = "ejb-link";
    private static final String QUERY = "query";
    private static final String QUERY_METHOD = "query-method";
    private static final String METHOD_NAME = "method-name";
    private static final String METHOD_PARAMS = "method-params";
    private static final String METHOD_PARAM = "method-param";
    private static final String EJB_QL = "ejb-ql";
    private static final String RELATIONSHIPS = "relationships";
    private static final String EJB_RELATION = "ejb-relation";
    private static final String EJB_RELATION_NAME = "ejb-relation-name";
    private static final String EJB_RELATIONSHIP_ROLE = "ejb-relationship-role";
    private static final String EJB_RELATIONSHIP_ROLE_NAME = "ejb-relationship-role-name";
    private static final String MULTIPLICITY = "multiplicity";
    private static final String CASCADE_DELETE = "cascade-delete";
    private static final String RELATIONSHIP_ROLE_SOURCE = "relationship-role-source";
    private static final String CMR_FIELD = "cmr-field";
    private static final String CMR_FIELD_NAME = "cmr-field-name";
    private static final String CMR_FIELD_TYPE = "cmr-field-type";
    private IFile iFile;
    private ModuleInfo iModuleInfo;

    public EjbJarXmlParser(IFile file, ModuleInfo moduleInfo) {
        this.iFile = file;
        this.iModuleInfo = moduleInfo;
    }

    public void parse() {
        Document document = this.iModuleInfo.getXMLUtil().readXml(this.iFile);
        this.parseEjbJarElement(document.getDocumentElement());
        this.iModuleInfo.getApplicationInfo().incrementParsedAssetCount();
    }

    private void parseEjbJarElement(Element documentElement) {
        NodeList childNodes = documentElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (ENTERPRISE_BEANS.equals(nodeName)) {
                    this.parseEnterpriseBeansElement(element);
                } else if (RELATIONSHIPS.equals(nodeName)) {
                    this.parseRelationshipsElement(element);
                }
            }
            ++i;
        }
    }

    private void parseEnterpriseBeansElement(Element enterpriseBeansElement) {
        NodeList childNodes = enterpriseBeansElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element element;
            String nodeName;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && ENTITY.equals(nodeName = (element = (Element)node).getNodeName())) {
                this.parseEntityElement(element);
            }
            ++i;
        }
    }

    private void parseEntityElement(Element entityElement) {
        EntityInfo entityInfo = this.iModuleInfo.getEntityInfo(entityElement.getAttribute(ID), true);
        NodeList childNodes = entityElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (EJB_NAME.equals(nodeName)) {
                    entityInfo.setEjbName(XMLUtil.getElementText(element));
                } else if (HOME.equals(nodeName)) {
                    entityInfo.setHome(XMLUtil.getElementText(element));
                } else if (REMOTE.equals(nodeName)) {
                    entityInfo.setRemote(XMLUtil.getElementText(element));
                } else if (EJB_CLASS.equals(nodeName)) {
                    entityInfo.setEjbClass(XMLUtil.getElementText(element));
                } else if (PRIM_KEY_CLASS.equals(nodeName)) {
                    entityInfo.setPrimaryKeyClass(XMLUtil.getElementText(element));
                } else if (CMP_VERSION.equals(nodeName)) {
                    entityInfo.setVersion(XMLUtil.getElementText(element));
                } else if (CMP_FIELD.equals(nodeName)) {
                    this.parseFieldElement(element, entityInfo);
                } else if (PRIM_KEY_FIELD.equals(nodeName)) {
                    entityInfo.setPrimaryKeyField(XMLUtil.getElementText(element));
                } else if (LOCAL_HOME.equals(nodeName)) {
                    entityInfo.setLocalHome(XMLUtil.getElementText(element));
                } else if (LOCAL.equals(nodeName)) {
                    entityInfo.setLocal(XMLUtil.getElementText(element));
                } else if (ABSTRACT_SCHEMA_NAME.equals(nodeName)) {
                    entityInfo.setAbstractSchemaName(XMLUtil.getElementText(element));
                } else if (EJB_LOCAL_REF.equals(nodeName)) {
                    this.parseEjbLocalRef(element, entityInfo);
                } else if (QUERY.equals(nodeName)) {
                    this.parseQuery(element, entityInfo);
                }
            }
            ++i;
        }
        if (entityInfo != null && !entityInfo.getEjbClass().matches(GenerationProperties.ARTIFACT_CLASS_QUALIFIER)) {
            this.iModuleInfo.getEntities().remove(entityInfo);
        }
    }

    private void parseFieldElement(Element fieldElement, EntityInfo entityInfo) {
        String fieldName = null;
        String fieldId = null;
        if (fieldElement.hasAttribute(ID)) {
            fieldId = fieldElement.getAttribute(ID);
        }
        NodeList childNodes = fieldElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element element;
            String nodeName;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && FIELD_NAME.equals(nodeName = (element = (Element)node).getNodeName())) {
                fieldName = XMLUtil.getElementText(element);
            }
            ++i;
        }
        if (fieldId == null) {
            fieldId = fieldName;
        }
        if (fieldId != null) {
            FieldInfo fieldInfo = entityInfo.getFieldInfo(fieldId, true);
            fieldInfo.setFieldName(fieldName);
        }
    }

    private void parseEjbLocalRef(Element ejbLocalRefElement, EntityInfo entityInfo) {
        EjbLocalRefInfo ejbLocalRefInfo = entityInfo.getEjbLocalRefInfo(ejbLocalRefElement.getAttribute(ID), true);
        NodeList childNodes = ejbLocalRefElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (EJB_REF_NAME.equals(nodeName)) {
                    ejbLocalRefInfo.setEjbRefName(XMLUtil.getElementText(element));
                } else if (EJB_REF_TYPE.equals(nodeName)) {
                    ejbLocalRefInfo.setEjbRefType(XMLUtil.getElementText(element));
                } else if (LOCAL_HOME.equals(nodeName)) {
                    ejbLocalRefInfo.setLocalHome(XMLUtil.getElementText(element));
                } else if (LOCAL.equals(nodeName)) {
                    ejbLocalRefInfo.setLocal(XMLUtil.getElementText(element));
                } else if (EJB_LINK.equals(nodeName)) {
                    ejbLocalRefInfo.setEjbLink(XMLUtil.getElementText(element));
                }
            }
            ++i;
        }
    }

    private void parseQuery(Element queryElement, EntityInfo entityInfo) {
        String finderQuery = null;
        FinderInfo finderInfo = null;
        NodeList childNodes = queryElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (QUERY_METHOD.equals(nodeName)) {
                    finderInfo = this.parseQueryMethod(element, entityInfo);
                } else if (EJB_QL.equals(nodeName)) {
                    finderQuery = XMLUtil.getElementText(element);
                }
            }
            ++i;
        }
        if (finderQuery == null) {
            LOGGER.info("null finderQuery " + finderInfo.getFinderMethodName());
        }
        finderInfo.setFinderQuery(finderQuery);
    }

    private FinderInfo parseQueryMethod(Element queryMethodElement, EntityInfo entityInfo) {
        String finderMethodName = null;
        String[] parameterTypes = null;
        NodeList childNodes = queryMethodElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (METHOD_NAME.equals(nodeName)) {
                    finderMethodName = XMLUtil.getElementText(element);
                } else if (METHOD_PARAMS.equals(nodeName)) {
                    parameterTypes = this.parseMethodParams(element);
                }
            }
            ++i;
        }
        return entityInfo.getFinderInfo(finderMethodName, parameterTypes, true);
    }

    private String[] parseMethodParams(Element methodParamsElement) {
        ArrayList<String> parameterTypes = new ArrayList<String>();
        NodeList childNodes = methodParamsElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element element;
            String nodeName;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && METHOD_PARAM.equals(nodeName = (element = (Element)node).getNodeName())) {
                parameterTypes.add(XMLUtil.getElementText(element));
            }
            ++i;
        }
        return parameterTypes.toArray(new String[parameterTypes.size()]);
    }

    private void parseRelationshipsElement(Element relationshipsElement) {
        NodeList childNodes = relationshipsElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element element;
            String nodeName;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && EJB_RELATION.equals(nodeName = (element = (Element)node).getNodeName())) {
                this.parseEjbRelationElement(element);
            }
            ++i;
        }
    }

    private void parseEjbRelationElement(Element ejbRelationElement) {
        EjbRelationInfo ejbRelationInfo = new EjbRelationInfo();
        NodeList childNodes = ejbRelationElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (EJB_RELATION_NAME.equals(nodeName)) {
                    ejbRelationInfo.setEjbRelationName(XMLUtil.getElementText(element));
                } else if (EJB_RELATIONSHIP_ROLE.equals(nodeName)) {
                    this.parseEjbRelationshipRoleElement(element, ejbRelationInfo);
                }
            }
            ++i;
        }
        EjbRelationshipRoleInfo ejbRelationshipRoleInfo1 = ejbRelationInfo.getEjbRelationshipRoles().get(0);
        EjbRelationshipRoleInfo ejbRelationshipRoleInfo2 = ejbRelationInfo.getEjbRelationshipRoles().get(1);
        if (ejbRelationshipRoleInfo1.getFieldType() == null) {
            ejbRelationshipRoleInfo1.setFieldType(ejbRelationshipRoleInfo2.getEntityInfo().getLocal());
        }
        if (ejbRelationshipRoleInfo2.getFieldType() == null) {
            ejbRelationshipRoleInfo2.setFieldType(ejbRelationshipRoleInfo1.getEntityInfo().getLocal());
        }
        ejbRelationshipRoleInfo1.setRelatedEntityInfo(ejbRelationshipRoleInfo2.getEntityInfo());
        ejbRelationshipRoleInfo2.setRelatedEntityInfo(ejbRelationshipRoleInfo1.getEntityInfo());
        ejbRelationshipRoleInfo1.setRelatedMultiplicity(ejbRelationshipRoleInfo2.getMultiplicity());
        ejbRelationshipRoleInfo2.setRelatedMultiplicity(ejbRelationshipRoleInfo1.getMultiplicity());
        ejbRelationshipRoleInfo1.setRelatedFieldName(ejbRelationshipRoleInfo2.getFieldName());
        ejbRelationshipRoleInfo2.setRelatedFieldName(ejbRelationshipRoleInfo1.getFieldName());
    }

    private void parseEjbRelationshipRoleElement(Element ejbRelationshipRoleElement, EjbRelationInfo ejbRelationInfo) {
        EjbRelationshipRoleInfo ejbRelationshipRoleInfo = this.iModuleInfo.getEjbRelationshipRoleInfo(ejbRelationshipRoleElement.getAttribute(ID), true);
        ejbRelationshipRoleInfo.setEjbRelationInfo(ejbRelationInfo);
        ejbRelationInfo.addEjbRelationshipRole(ejbRelationshipRoleInfo);
        NodeList childNodes = ejbRelationshipRoleElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (EJB_RELATIONSHIP_ROLE_NAME.equals(nodeName)) {
                    ejbRelationshipRoleInfo.setEjbRelationshipRoleName(XMLUtil.getElementText(element));
                } else if (MULTIPLICITY.equals(nodeName)) {
                    ejbRelationshipRoleInfo.setMultiplicity(XMLUtil.getElementText(element));
                } else if (CASCADE_DELETE.equals(nodeName)) {
                    ejbRelationshipRoleInfo.setCascadeDelete(true);
                } else if (RELATIONSHIP_ROLE_SOURCE.equals(nodeName)) {
                    this.parseRelationshipRoleSourceElement(element, ejbRelationshipRoleInfo);
                } else if (CMR_FIELD.equals(nodeName)) {
                    this.parseCmrFieldElement(element, ejbRelationshipRoleInfo);
                }
            }
            ++i;
        }
        EntityInfo entityInfo = this.iModuleInfo.getEntityInfoByName(ejbRelationshipRoleInfo.getEjbName());
        entityInfo.addEjbRelationsihpRoleInfo(ejbRelationshipRoleInfo);
        ejbRelationshipRoleInfo.setEntityInfo(entityInfo);
    }

    private void parseRelationshipRoleSourceElement(Element relationshipRoleSourceElement, EjbRelationshipRoleInfo ejbRelationshipRoleInfo) {
        NodeList childNodes = relationshipRoleSourceElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element element;
            String nodeName;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && EJB_NAME.equals(nodeName = (element = (Element)node).getNodeName())) {
                ejbRelationshipRoleInfo.setEjbName(XMLUtil.getElementText(element));
            }
            ++i;
        }
    }

    private void parseCmrFieldElement(Element cmrFieldElement, EjbRelationshipRoleInfo ejbRelationshipRoleInfo) {
        NodeList childNodes = cmrFieldElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (CMR_FIELD_NAME.equals(nodeName)) {
                    ejbRelationshipRoleInfo.setFieldName(XMLUtil.getElementText(element));
                } else if (CMR_FIELD_TYPE.equals(nodeName)) {
                    ejbRelationshipRoleInfo.setFieldType(XMLUtil.getElementText(element));
                }
            }
            ++i;
        }
    }
}

