/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.parsers;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.FieldInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import java.beans.Introspector;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class EjbEntityCreationDataClassParser {
    private static final Logger LOGGER = LoggerHelper.getLogger(EjbEntityCreationDataClassParser.class);
    private static final String COPY_FIELDS = "copyFields";
    private static final String GET = "get";
    private ModuleInfo iModuleInfo;
    private EntityInfo iEntityInfo;
    private ASTParser iASTParser;
    private boolean iCopyFields;
    private Set<FieldInfo> iFields = new HashSet<FieldInfo>();

    public EjbEntityCreationDataClassParser(ASTParser astParser, EntityInfo entityInfo) {
        this.iASTParser = astParser;
        this.iModuleInfo = entityInfo.getModuleInfo();
        this.iEntityInfo = entityInfo;
    }

    public void parse(IProgressMonitor progressMonitor) {
        try {
            progressMonitor.beginTask("parse EntityCreationData type for " + this.iEntityInfo.getEjbName(), 2100);
            IType entityCreationDataType = this.iEntityInfo.getEjbEntityCreationDataType();
            if (entityCreationDataType != null) {
                this.iModuleInfo.addDeleteIntendedType(this.iEntityInfo.getEjbEntityCreationDataType().getFullyQualifiedName('.'));
                this.iASTParser.setResolveBindings(true);
                this.iASTParser.setSource(entityCreationDataType.getCompilationUnit());
                CompilationUnit compilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                this.iEntityInfo.setEjbEntityCreationDataCompilationUnit(compilationUnit);
                progressMonitor.worked(1000);
                this.parseCompilationUnit(compilationUnit);
                if (this.iCopyFields) {
                    this.iEntityInfo.getEntityCreationDataFields().addAll(this.iFields);
                }
                progressMonitor.worked(1000);
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private void parseCompilationUnit(CompilationUnit compilationUnit) {
        List typeDeclarations = compilationUnit.types();
        TypeDeclaration typeDeclaration = (TypeDeclaration)typeDeclarations.get(0);
        List bodyDeclarations = typeDeclaration.bodyDeclarations();
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (bodyDeclaration.getNodeType() != 31) continue;
            this.parseMethodDeclaration((MethodDeclaration)bodyDeclaration);
        }
        this.iModuleInfo.getApplicationInfo().incrementParsedAssetCount();
    }

    private void parseMethodDeclaration(MethodDeclaration methodDeclaration) {
        String methodName = methodDeclaration.getName().getIdentifier();
        List parameters = methodDeclaration.parameters();
        if (COPY_FIELDS.equals(methodName) && parameters.size() == 1) {
            methodDeclaration.accept((ASTVisitor)new CopyFieldsMethodVisitor());
        } else if (methodName.startsWith(GET) && parameters.size() == 0) {
            String fieldName = methodName.substring(3);
            FieldInfo fieldInfo = this.iEntityInfo.getFieldInfoByName(fieldName);
            if (fieldInfo == null) {
                fieldInfo = this.iEntityInfo.getFieldInfoByName(Introspector.decapitalize(fieldName));
            }
            if (fieldInfo != null) {
                fieldInfo.setEntityCreationDataGetterName(methodName);
                this.iFields.add(fieldInfo);
            } else {
                LOGGER.info("unable to determine field for getter: " + methodName + " in " + this.iEntityInfo.getEjbEntityCreationDataType().getFullyQualifiedName('.'));
            }
        }
    }

    private class CopyFieldsMethodVisitor
    extends ASTVisitor {
        public boolean visit(MethodInvocation methodInvocation) {
            ITypeBinding typeBinding;
            boolean visitChildren = true;
            if (methodInvocation.getExpression() != null && (typeBinding = methodInvocation.getExpression().resolveTypeBinding()) != null && typeBinding.getQualifiedName().equals("java.lang.reflect.Field") && methodInvocation.getName().getIdentifier().equals("set")) {
                EjbEntityCreationDataClassParser.this.iCopyFields = true;
            }
            return visitChildren;
        }
    }
}

