/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.parsers;

import com.ibm.commerce.jpa.port.info.AccessBeanSubclassInfo;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.ProjectInfo;
import com.ibm.commerce.jpa.port.util.AccessBeanUtil;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class AccessBeanSubclassParser {
    private AccessBeanSubclassInfo iAccessBeanSubclassInfo;
    private IType iType;
    private EntityInfo iEntityInfo;
    private ASTParser iASTParser;
    private ApplicationInfo iApplicationInfo;

    public AccessBeanSubclassParser(ASTParser astParser, AccessBeanSubclassInfo accessBeanSubclassInfo) {
        this.iASTParser = astParser;
        this.iAccessBeanSubclassInfo = accessBeanSubclassInfo;
        this.iType = accessBeanSubclassInfo.getType();
        this.iEntityInfo = accessBeanSubclassInfo.getEntityInfo();
        this.iApplicationInfo = accessBeanSubclassInfo.getProjectInfo().getApplicationInfo();
    }

    public void parse(IProgressMonitor progressMonitor) {
        try {
            try {
                progressMonitor.beginTask("parse access bean subclass " + this.iAccessBeanSubclassInfo.getName(), -1);
                this.parseAccessBeanSubclass(progressMonitor);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private void parseAccessBeanSubclass(IProgressMonitor progressMonitor) throws JavaModelException {
        IType superclassType = JavaUtil.resolveType(this.iType, this.iType.getSuperclassName());
        if (!this.iEntityInfo.getAccessBeanInfo().getQualifiedAccessBeanName().equals(superclassType.getFullyQualifiedName('.'))) {
            ProjectInfo superclassProjectInfo = this.iApplicationInfo.getProjectInfo(superclassType.getJavaProject().getProject());
            AccessBeanSubclassInfo superclass = superclassProjectInfo.getAccessBeanSubclassInfo(superclassType.getFullyQualifiedName('.'), false);
            this.iAccessBeanSubclassInfo.setSuperclass(superclass);
            superclass.addSubclass(this.iAccessBeanSubclassInfo);
        }
        if (!AccessBeanUtil.isCachedEntityAccessBean(this.iType) && !AccessBeanUtil.isCompactEntityAccessBean(this.iType)) {
            this.iASTParser.setResolveBindings(true);
            this.iASTParser.setSource(this.iType.getCompilationUnit());
            CompilationUnit compilationUnit = (CompilationUnit)this.iASTParser.createAST((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            compilationUnit.accept((ASTVisitor)new AccessBeanSubclassVisitor());
            progressMonitor.worked(100);
        }
        this.iApplicationInfo.incrementParsedAssetCount();
    }

    private void parseMethodDeclaration(MethodDeclaration methodDeclaration) {
        String methodKey = JavaUtil.getMethodKey(methodDeclaration);
        this.iAccessBeanSubclassInfo.setMethodDeclaration(methodKey, methodDeclaration);
    }

    private class AccessBeanSubclassVisitor
    extends ASTVisitor {
        private AccessBeanSubclassVisitor() {
        }

        public boolean visit(TypeDeclaration typeDeclaration) {
            ITypeBinding typeBinding = typeDeclaration.resolveBinding();
            if (typeBinding != null && typeBinding.getQualifiedName().equals(AccessBeanSubclassParser.this.iAccessBeanSubclassInfo.getName())) {
                List bodyDeclarations = typeDeclaration.bodyDeclarations();
                for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                    if (bodyDeclaration.getNodeType() != 31) continue;
                    AccessBeanSubclassParser.this.parseMethodDeclaration((MethodDeclaration)bodyDeclaration);
                }
            }
            return true;
        }
    }
}

