/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.info;

import com.ibm.commerce.jpa.port.info.ColumnInfo;
import com.ibm.commerce.jpa.port.info.ConstraintInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.ForeignKeyInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableInfo {
    private ModuleInfo iModuleInfo;
    private String iTableId;
    private String iTableName;
    private Map<String, ColumnInfo> iColumns = new HashMap<String, ColumnInfo>();
    private List<ColumnInfo> iColumnList = new ArrayList<ColumnInfo>();
    private Map<String, ColumnInfo> iColumnsByName = new HashMap<String, ColumnInfo>();
    private Map<String, ConstraintInfo> iConstraints = new HashMap<String, ConstraintInfo>();
    private Set<ForeignKeyInfo> iForeignKeys = new HashSet<ForeignKeyInfo>();
    private EntityInfo iEntityInfo;
    private List<ColumnInfo> iPrimaryKeyColumns = new ArrayList<ColumnInfo>();
    StringBuffer errors = null;

    public TableInfo(ModuleInfo moduleInfo, String tableId) {
        this.iModuleInfo = moduleInfo;
        this.iTableId = tableId;
    }

    public ModuleInfo getModuleInfo() {
        return this.iModuleInfo;
    }

    public String getTableId() {
        return this.iTableId;
    }

    public void setTableName(String tableName) {
        this.iTableName = tableName;
    }

    public String getTableName() {
        return this.iTableName;
    }

    public ColumnInfo getColumnInfo(String columnId, boolean create) {
        ColumnInfo columnInfo = this.iColumns.get(columnId);
        if (columnInfo == null && create) {
            columnInfo = new ColumnInfo(this, columnId);
            this.iColumns.put(columnId, columnInfo);
            this.iColumnList.add(columnInfo);
        }
        return columnInfo;
    }

    public ColumnInfo getColumnInfo(String columnId) {
        return this.getColumnInfo(columnId, false);
    }

    public List<ColumnInfo> getColumns() {
        return this.iColumnList;
    }

    public void setColumnName(ColumnInfo columnInfo, String columnName) {
        columnInfo.setColumnName(columnName);
        this.iColumnsByName.put(columnName, columnInfo);
    }

    public ColumnInfo getColumnInfoByName(String columnName) {
        return this.iColumnsByName.get(columnName);
    }

    public ConstraintInfo getConstraintInfo(String constraintId, boolean create) {
        ConstraintInfo constraintInfo = this.iConstraints.get(constraintId);
        if (constraintInfo == null && create) {
            constraintInfo = new ConstraintInfo(this, constraintId);
            this.iConstraints.put(constraintId, constraintInfo);
        }
        return constraintInfo;
    }

    public ConstraintInfo getConstraintInfo(String constraintId) {
        return this.getConstraintInfo(constraintId, false);
    }

    public Collection<ConstraintInfo> getConstraints() {
        return this.iConstraints.values();
    }

    public void addForeignKey(ForeignKeyInfo foreignKeyInfo) {
        this.iForeignKeys.add(foreignKeyInfo);
    }

    public Set<ForeignKeyInfo> getForeignKeys() {
        return this.iForeignKeys;
    }

    public void setEntityInfo(EntityInfo entityInfo) {
        this.iEntityInfo = entityInfo;
    }

    public EntityInfo getEntityInfo() {
        return this.iEntityInfo;
    }

    public void addPrimaryKeyColumnInfo(ColumnInfo primaryKeyColumnInfo) {
        if (!this.iPrimaryKeyColumns.contains(primaryKeyColumnInfo)) {
            this.iPrimaryKeyColumns.add(primaryKeyColumnInfo);
        }
    }

    public List<ColumnInfo> getPrimaryKeyColumns() {
        return this.iPrimaryKeyColumns;
    }

    public void addError(String error) {
        if (this.errors == null) {
            this.errors = new StringBuffer("");
        }
        this.errors.append(String.valueOf(error) + System.lineSeparator());
    }

    public String getErrors() {
        return this.errors == null ? null : this.errors.toString();
    }
}

