/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.info;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.ProjectInfo;
import com.ibm.commerce.jpa.port.info.TargetExceptionInfo;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.MethodDeclaration;

public class AccessBeanSubclassInfo {
    private static final Logger LOGGER = LoggerHelper.getLogger(AccessBeanSubclassInfo.class);
    private ProjectInfo iProjectInfo;
    private String iName;
    private ApplicationInfo iApplicationInfo;
    private IType iType;
    private EntityInfo iEntityInfo;
    private AccessBeanSubclassInfo iSuperclass;
    private Set<AccessBeanSubclassInfo> iSubclasses = new HashSet<AccessBeanSubclassInfo>();
    private Collection<String> iMethodKeys = new HashSet<String>();
    private Map<String, MethodDeclaration> iMethodDeclarations = new HashMap<String, MethodDeclaration>();
    private Map<String, TargetExceptionInfo> iMethodUnhandledTargetExceptions = new HashMap<String, TargetExceptionInfo>();

    public AccessBeanSubclassInfo(ProjectInfo projectInfo, String name) {
        this.iProjectInfo = projectInfo;
        this.iApplicationInfo = projectInfo.getApplicationInfo();
        this.iName = name;
    }

    public ProjectInfo getProjectInfo() {
        return this.iProjectInfo;
    }

    public String getName() {
        return this.iName;
    }

    public IType getType() {
        if (this.iType == null) {
            try {
                this.iType = this.iProjectInfo.getJavaProject().findType(this.iName);
                if (this.iType == null) {
                    LOGGER.info("unable to find type: " + this.iName + " in " + this.iProjectInfo.getProject().getName());
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return this.iType;
    }

    public EntityInfo getEntityInfo() {
        if (this.iEntityInfo == null) {
            IType type = this.getType();
            try {
                while (type != null && type.getSuperclassName() != null) {
                    EntityInfo entityInfo = this.iApplicationInfo.getEntityInfoForType((type = JavaUtil.resolveType(type, type.getSuperclassName())).getFullyQualifiedName('.'));
                    if (entityInfo == null) continue;
                    this.iEntityInfo = entityInfo;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return this.iEntityInfo;
    }

    public void setSuperclass(AccessBeanSubclassInfo superclass) {
        this.iSuperclass = superclass;
    }

    public AccessBeanSubclassInfo getSuperclass() {
        return this.iSuperclass;
    }

    public void addSubclass(AccessBeanSubclassInfo subclass) {
        this.iSubclasses.add(subclass);
    }

    public Set<AccessBeanSubclassInfo> getSubclasses() {
        return this.iSubclasses;
    }

    public void setMethodDeclaration(String methodKey, MethodDeclaration methodDeclaration) {
        this.iMethodKeys.add(methodKey);
        this.iMethodDeclarations.put(methodKey, methodDeclaration);
    }

    public MethodDeclaration getMethodDeclaration(String methodKey) {
        return this.iMethodDeclarations.get(methodKey);
    }

    public void releaseMethodDeclaration(String methodKey) {
        this.iMethodDeclarations.remove(methodKey);
    }

    public void setMethodUnhandledTargetExceptions(String methodKey, TargetExceptionInfo unhandledTargetExceptions) {
        this.iMethodKeys.add(methodKey);
        this.iMethodUnhandledTargetExceptions.put(methodKey, unhandledTargetExceptions);
    }

    public TargetExceptionInfo getMethodUnhandledTargetExceptions(String methodKey) {
        return this.iMethodUnhandledTargetExceptions.get(methodKey);
    }

    public Collection<String> getMethodKeys() {
        return this.iMethodKeys;
    }

    public boolean hasMethod(String methodKey) {
        return this.iMethodKeys.contains(methodKey);
    }
}

