/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.info;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.generators.PortVisitor;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.ColumnInfo;
import com.ibm.commerce.jpa.port.info.CreatorInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.FieldInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.info.RelatedEntityInfo;
import com.ibm.commerce.jpa.port.info.TargetExceptionInfo;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import com.ibm.commerce.jpa.port.util.TargetExceptionUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperFieldAccess;

public class AccessBeanMethodInfo {
    private static final Logger LOGGER = LoggerHelper.getLogger(AccessBeanMethodInfo.class);
    private static final String EJB_CREATE = "ejbCreate+";
    private static final String COMMIT_COPY_HELPER = "commitCopyHelper";
    private static final String CLOB_ATTRIBUTE_VALUE = "com.ibm.commerce.base.helpers.ClobAttributeValue";
    private static final String BLOB_ATTRIBUTE_VALUE = "com.ibm.commerce.base.helpers.BlobAttributeValue";
    private static final String GET_VALUE = "getValue";
    private static final String SET_VALUE = "setValue";
    private static final String ENTITY_CREATION_DATA = "com.ibm.commerce.context.content.objects.EntityCreationData";
    private static final String COPY_FIELDS = "copyFields";
    private static final String CHAR = "CHAR";
    private static final String TRIM = "trim";
    private EntityInfo iEntityInfo;
    private String iMethodKey;
    private String iMethodName;
    private String iTargetMethodName;
    private String iReturnType;
    private String[] iParameterTypes;
    private String[] iParameterNames;
    private String[] iTargetParameterNames;
    private List<AccessBeanStatement> iStatements = new ArrayList<AccessBeanStatement>();
    private List<Set<FieldInfo>> iFieldsInitializedByParameter;
    private Set<FieldInfo> iInitializedFields = new HashSet<FieldInfo>();
    private Collection<String> iReferencedAccessBeanMethods = new HashSet<String>();
    private Collection<String> iReferencedStaticFieldNames = new HashSet<String>();
    private Collection<String> iReferencedInstanceVariableNames = new HashSet<String>();
    private AccessBeanMethodInfo iSuperAccessBeanMethodInfo;
    private boolean iCallsSuperAccessBeanMethod;
    private boolean iInvalid;
    private VariableRenameVisitor iVariableRenameVisitor;
    private String iModifiedInstanceVariableName;

    public AccessBeanMethodInfo(EntityInfo entityInfo, String methodKey, String methodName, String[] parameterTypes, String returnType) {
        this.iEntityInfo = entityInfo;
        this.iMethodKey = methodKey;
        this.iMethodName = methodName;
        this.iTargetMethodName = methodName;
        this.iParameterTypes = parameterTypes;
        this.iParameterNames = new String[parameterTypes.length];
        this.iTargetParameterNames = new String[parameterTypes.length];
        this.iReturnType = returnType;
    }

    public EntityInfo getEntityInfo() {
        return this.iEntityInfo;
    }

    public String getMethodKey() {
        return this.iMethodKey;
    }

    public String getMethodName() {
        return this.iMethodName;
    }

    public void setTargetMethodName(String targetMethodName) {
        this.iTargetMethodName = targetMethodName;
    }

    public String getTargetMethodName() {
        return this.iTargetMethodName;
    }

    public String[] getParameterTypes() {
        return this.iParameterTypes;
    }

    public String getReturnType() {
        return this.iReturnType;
    }

    public List<AccessBeanStatement> getStatements() {
        return this.iStatements;
    }

    public void setParameterName(int parameterIndex, String parameterName) {
        this.iParameterNames[parameterIndex] = parameterName;
    }

    public String[] getParameterNames() {
        return this.iParameterNames;
    }

    public void setTargetParameterName(int parameterIndex, String targetParameterName) {
        this.iTargetParameterNames[parameterIndex] = targetParameterName;
    }

    public String getTargetParameterName(int parameterIndex) {
        String targetParameterName = this.iTargetParameterNames[parameterIndex];
        if (this.iCallsSuperAccessBeanMethod && this.iSuperAccessBeanMethodInfo != null) {
            targetParameterName = this.iSuperAccessBeanMethodInfo.getTargetParameterName(parameterIndex);
        }
        if (targetParameterName == null) {
            targetParameterName = this.iParameterNames[parameterIndex];
        }
        return targetParameterName;
    }

    public void addFieldInitializedByParameter(int parameterIndex, FieldInfo fieldInfo) {
        if (this.iFieldsInitializedByParameter == null) {
            this.iFieldsInitializedByParameter = new ArrayList<Set<FieldInfo>>(this.iParameterTypes.length);
            int i = 0;
            while (i < this.iParameterTypes.length) {
                this.iFieldsInitializedByParameter.add(null);
                ++i;
            }
        }
        if (this.iFieldsInitializedByParameter.get(parameterIndex) == null) {
            this.iFieldsInitializedByParameter.set(parameterIndex, new HashSet());
        }
        this.iFieldsInitializedByParameter.get(parameterIndex).add(fieldInfo);
    }

    public Set<FieldInfo> getFieldsInitializedByParameter(int parameterIndex) {
        Set<FieldInfo> fieldsInitializedByParameter = null;
        if (this.iFieldsInitializedByParameter != null) {
            fieldsInitializedByParameter = this.iFieldsInitializedByParameter.get(parameterIndex);
        }
        return fieldsInitializedByParameter;
    }

    public void addInitializedField(FieldInfo fieldInfo) {
        this.iInitializedFields.add(fieldInfo);
    }

    public Set<FieldInfo> getInitializedFields() {
        if (this.iCallsSuperAccessBeanMethod && this.iSuperAccessBeanMethodInfo != null) {
            this.iInitializedFields.addAll(this.iSuperAccessBeanMethodInfo.getInitializedFields());
        }
        return this.iInitializedFields;
    }

    public void addReferencedAccessBeanMethod(String methodKey) {
        this.iReferencedAccessBeanMethods.add(methodKey);
    }

    public Collection<String> getReferencedAccessBeanMethods() {
        if (this.iCallsSuperAccessBeanMethod && this.iSuperAccessBeanMethodInfo != null) {
            this.iReferencedAccessBeanMethods.addAll(this.iSuperAccessBeanMethodInfo.getReferencedAccessBeanMethods());
        }
        return this.iReferencedAccessBeanMethods;
    }

    public TargetExceptionInfo getUnhandledExceptions() {
        TargetExceptionInfo unhandledExceptions = new TargetExceptionInfo();
        for (AccessBeanStatement statement : this.iStatements) {
            unhandledExceptions.addAll(statement.getUnhandledExceptions(this));
        }
        return unhandledExceptions;
    }

    public Collection<String> getReferencedStaticFieldNames() {
        if (this.iCallsSuperAccessBeanMethod && this.iSuperAccessBeanMethodInfo != null) {
            this.iReferencedStaticFieldNames.addAll(this.iSuperAccessBeanMethodInfo.getReferencedStaticFieldNames());
        }
        return this.iReferencedStaticFieldNames;
    }

    public Collection<String> getReferencedInstanceVariableNames() {
        if (this.iCallsSuperAccessBeanMethod && this.iSuperAccessBeanMethodInfo != null) {
            this.iReferencedInstanceVariableNames.addAll(this.iSuperAccessBeanMethodInfo.getReferencedInstanceVariableNames());
        }
        return this.iReferencedInstanceVariableNames;
    }

    public void addSuperAccessBeanMethodInfo(AccessBeanMethodInfo superAccessBeanMethodInfo) {
        if (this.iSuperAccessBeanMethodInfo == null) {
            this.iSuperAccessBeanMethodInfo = superAccessBeanMethodInfo;
        } else {
            this.iSuperAccessBeanMethodInfo.addSuperAccessBeanMethodInfo(superAccessBeanMethodInfo);
        }
    }

    public AccessBeanMethodInfo getSuperAccessBeanMethodInfo() {
        return this.iSuperAccessBeanMethodInfo;
    }

    public void setCallsSuperAccessBeanMethod(boolean callsSuperAccessBeanMethod) {
        this.iCallsSuperAccessBeanMethod = callsSuperAccessBeanMethod;
    }

    public boolean getCallsSuperAccessBeanMethod() {
        return this.iCallsSuperAccessBeanMethod;
    }

    public boolean isEmptyMethod() {
        boolean emptyMethod = false;
        if (this.iStatements.size() == 0) {
            emptyMethod = true;
        } else if (this.iStatements.size() == 1 && this.iCallsSuperAccessBeanMethod) {
            emptyMethod = this.iSuperAccessBeanMethodInfo == null || this.iSuperAccessBeanMethodInfo.isEmptyMethod();
        }
        return emptyMethod;
    }

    public void markInvalid() {
        this.iInvalid = true;
    }

    public boolean isInvalid() {
        if (!this.iInvalid && this.iCallsSuperAccessBeanMethod && this.iSuperAccessBeanMethodInfo != null) {
            this.iInvalid = this.iSuperAccessBeanMethodInfo.isInvalid();
        }
        return this.iInvalid;
    }

    public void renameVariables(ASTNode node) {
        if (this.iVariableRenameVisitor == null) {
            HashMap<String, String> variableNameMap = new HashMap<String, String>();
            int i = 0;
            while (i < this.iParameterNames.length) {
                String parameterName = this.iParameterNames[i];
                String targetParameterName = this.getTargetParameterName(i);
                if (!parameterName.equals(targetParameterName)) {
                    variableNameMap.put(parameterName, targetParameterName);
                }
                ++i;
            }
            this.iVariableRenameVisitor = new VariableRenameVisitor(variableNameMap);
        }
        node.accept((ASTVisitor)this.iVariableRenameVisitor);
    }

    public void resolve() {
        if (this.iSuperAccessBeanMethodInfo != null) {
            this.iSuperAccessBeanMethodInfo.resolve();
        }
        ArrayDeque<List<AccessBeanStatement>> statementListStack = new ArrayDeque<List<AccessBeanStatement>>();
        this.resolveStatements(statementListStack, this.iStatements);
    }

    public void resolveStatements(Deque<List<AccessBeanStatement>> statementListStack, List<AccessBeanStatement> statements) {
        statementListStack.push(statements);
        int i = statements.size() - 1;
        while (i >= 0) {
            statements.get(i).resolve(this, statementListStack);
            --i;
        }
        statementListStack.pop();
    }

    public void setModifiedInstanceVariableName(String modifiedInstanceVariableName) {
        this.iModifiedInstanceVariableName = modifiedInstanceVariableName;
    }

    public String getModifiedInstanceVariableName() {
        return this.iModifiedInstanceVariableName;
    }

    public static class AccessBeanCatchClause {
        private AccessBeanMethodInfo iAccessBeanMethodInfo;
        private String iExceptionType;
        private String iExceptionVariableName;
        private List<AccessBeanStatement> iCatchStatements = new ArrayList<AccessBeanStatement>();
        private Collection<String> iHandledExceptions = new HashSet<String>();

        public AccessBeanCatchClause(AccessBeanMethodInfo accessBeanMethodInfo) {
            this.iAccessBeanMethodInfo = accessBeanMethodInfo;
        }

        public void setExceptionType(String exceptionType) {
            this.iExceptionType = exceptionType;
        }

        public String getExceptionType() {
            return this.iExceptionType;
        }

        public Collection<String> getTargetExceptionTypes() {
            HashSet<String> targetExceptionTypes = new HashSet<String>();
            if (this.iHandledExceptions.size() == 1) {
                targetExceptionTypes.addAll(this.iHandledExceptions);
            } else {
                IJavaProject javaProject = this.iAccessBeanMethodInfo.getEntityInfo().getModuleInfo().getJavaProject();
                HashSet<String> unhandledExceptions = new HashSet<String>();
                for (String handledException : this.iHandledExceptions) {
                    if (TargetExceptionUtil.catchHandlesException(javaProject, this.iExceptionType, handledException)) {
                        targetExceptionTypes.add(this.iExceptionType);
                        continue;
                    }
                    unhandledExceptions.add(handledException);
                }
                if (unhandledExceptions.size() == 1) {
                    targetExceptionTypes.addAll(unhandledExceptions);
                } else if (unhandledExceptions.size() > 1) {
                    String targetException = null;
                    for (String exception : unhandledExceptions) {
                        if (targetException == null) {
                            targetException = exception;
                            continue;
                        }
                        if (!TargetExceptionUtil.catchHandlesException(javaProject, exception, targetException)) continue;
                        targetException = exception;
                    }
                    targetExceptionTypes.add(targetException);
                }
            }
            return targetExceptionTypes;
        }

        public void setExceptionVariableName(String exceptionVariableName) {
            this.iExceptionVariableName = exceptionVariableName;
        }

        public String getExceptionVariableName() {
            return this.iExceptionVariableName;
        }

        public List<AccessBeanStatement> getCatchStatements() {
            return this.iCatchStatements;
        }

        public Collection<String> getHandledExceptions() {
            return this.iHandledExceptions;
        }

        public TargetExceptionInfo getUnhandledExceptions(AccessBeanMethodInfo accessBeanMethodInfo) {
            TargetExceptionInfo unhandledExceptions = new TargetExceptionInfo();
            for (AccessBeanStatement statement : this.iCatchStatements) {
                unhandledExceptions.addAll(statement.getUnhandledExceptions(accessBeanMethodInfo));
            }
            return unhandledExceptions;
        }

        public boolean usesVariable(String variableName) {
            boolean variableUsed = false;
            for (AccessBeanStatement statement : this.iCatchStatements) {
                if (!statement.usesVariable(variableName)) continue;
                variableUsed = true;
                break;
            }
            return variableUsed;
        }

        public boolean containsStatement(AccessBeanStatement statement) {
            boolean match = false;
            for (AccessBeanStatement currentStatement : this.iCatchStatements) {
                if (!currentStatement.containsStatement(statement)) continue;
                match = true;
                break;
            }
            return match;
        }
    }

    public static class AccessBeanEntityCreationDataInitializedFieldStatement
    extends AccessBeanStatement {
        private FieldInfo iFieldInfo;

        public void setFieldInfo(FieldInfo fieldInfo) {
            this.iFieldInfo = fieldInfo;
        }

        public FieldInfo getFieldInfo() {
            return this.iFieldInfo;
        }
    }

    public static class AccessBeanExpressionInitializedFieldStatement
    extends AccessBeanStatement {
        private FieldInfo iFieldInfo;
        private Expression iExpression;
        private TargetExceptionInfo iExpressionUnhandledExceptions;

        public void setFieldInfo(FieldInfo fieldInfo) {
            this.iFieldInfo = fieldInfo;
        }

        public FieldInfo getFieldInfo() {
            return this.iFieldInfo;
        }

        public void setExpression(Expression expression) {
            this.iExpression = expression;
        }

        public Expression getExpression() {
            return this.iExpression;
        }

        @Override
        public void resolve(AccessBeanMethodInfo accessBeanMethodInfo, Deque<List<AccessBeanStatement>> statementListStack) {
            ModuleInfo moduleInfo = accessBeanMethodInfo.getEntityInfo().getModuleInfo();
            this.iExpressionUnhandledExceptions = TargetExceptionUtil.getUnhandledTargetExceptions(moduleInfo.getApplicationInfo(), moduleInfo.getJavaProject(), (ASTNode)this.iExpression);
            accessBeanMethodInfo.renameVariables((ASTNode)this.iExpression);
            this.iExpression.accept((ASTVisitor)new AccessBeanExpressionVisitor(accessBeanMethodInfo, this));
        }

        @Override
        public TargetExceptionInfo getUnhandledExceptions(AccessBeanMethodInfo accessBeanMethodInfo) {
            TargetExceptionInfo unhandledExceptions = new TargetExceptionInfo();
            unhandledExceptions.addAll(this.iExpressionUnhandledExceptions);
            return unhandledExceptions;
        }

        @Override
        public void replaceASTNode(ASTNode astNode, ASTNode newNode) {
            super.replaceASTNode(astNode, newNode);
            if (astNode == this.iExpression) {
                this.iExpression = (Expression)newNode;
            }
        }

        @Override
        public boolean usesVariable(String variableName) {
            boolean variableUsed = false;
            VariableCheckVisitor variableCheckVisitor = new VariableCheckVisitor(variableName);
            this.iExpression.accept((ASTVisitor)variableCheckVisitor);
            if (variableCheckVisitor.getVariableFound()) {
                variableUsed = true;
            }
            return variableUsed;
        }
    }

    private static class AccessBeanExpressionVisitor
    extends PortVisitor {
        private EntityInfo iEntityInfo;
        private AccessBeanMethodInfo iAccessBeanMethodInfo;
        private AccessBeanStatement iAccessBeanStatement;

        public AccessBeanExpressionVisitor(AccessBeanMethodInfo accessBeanMethodInfo, AccessBeanStatement accessBeanStatement) {
            super(accessBeanMethodInfo.getEntityInfo().getModuleInfo().getApplicationInfo(), accessBeanMethodInfo.getEntityInfo().getModuleInfo().getJavaProject());
            this.iEntityInfo = accessBeanMethodInfo.getEntityInfo();
            this.iAccessBeanMethodInfo = accessBeanMethodInfo;
            this.iAccessBeanStatement = accessBeanStatement;
        }

        @Override
        public boolean visit(SimpleName simpleName) {
            IBinding binding = simpleName.resolveBinding();
            if (binding != null && binding.getKind() == 3 && !simpleName.isDeclaration()) {
                IVariableBinding variableBinding = (IVariableBinding)binding;
                if (!simpleName.isDeclaration() && variableBinding.getDeclaringClass() != null && variableBinding.isField()) {
                    boolean staticField = (variableBinding.getModifiers() & 0x18) == 24;
                    String fieldName = simpleName.getIdentifier();
                    String declaringClass = variableBinding.getDeclaringClass().getQualifiedName();
                    if (!this.iEntityInfo.isClassInEjbHierarchy(declaringClass)) {
                        if (staticField) {
                            Name newName = simpleName.getAST().newName(String.valueOf(declaringClass) + "." + fieldName);
                            this.replaceASTNode((ASTNode)simpleName, (ASTNode)newName);
                        }
                    } else {
                        FieldInfo fieldInfo = this.iEntityInfo.getFieldInfoByName(simpleName.getIdentifier());
                        if (fieldInfo == null) {
                            if (staticField) {
                                this.iAccessBeanMethodInfo.getReferencedStaticFieldNames().add(fieldName);
                            } else {
                                this.iAccessBeanMethodInfo.getReferencedInstanceVariableNames().add(fieldName);
                            }
                        } else {
                            this.replaceFieldReference((ASTNode)simpleName, fieldInfo);
                        }
                    }
                }
            } else {
                super.visit(simpleName);
            }
            return false;
        }

        @Override
        public boolean visit(FieldAccess fieldAccess) {
            IVariableBinding variableBinding;
            boolean visitChildren = true;
            if (fieldAccess.getExpression().getNodeType() == 52 && (variableBinding = fieldAccess.resolveFieldBinding()) != null && variableBinding.getDeclaringClass() != null && variableBinding.isField()) {
                boolean staticField = (variableBinding.getModifiers() & 0x18) == 24;
                String fieldName = fieldAccess.getName().getIdentifier();
                String declaringClass = variableBinding.getDeclaringClass().getQualifiedName();
                if (!this.iEntityInfo.isClassInEjbHierarchy(declaringClass)) {
                    if (staticField) {
                        Name newName = fieldAccess.getAST().newName(String.valueOf(declaringClass) + "." + fieldName);
                        this.replaceASTNode((ASTNode)fieldAccess, (ASTNode)newName);
                        visitChildren = false;
                    }
                } else {
                    FieldInfo fieldInfo = this.iEntityInfo.getFieldInfoByName(fieldName);
                    if (fieldInfo == null) {
                        if (staticField) {
                            this.iAccessBeanMethodInfo.getReferencedStaticFieldNames().add(fieldName);
                        } else {
                            this.iAccessBeanMethodInfo.getReferencedInstanceVariableNames().add(fieldName);
                        }
                        Name newName = fieldAccess.getAST().newName(fieldName);
                        this.replaceASTNode((ASTNode)fieldAccess, (ASTNode)newName);
                        visitChildren = false;
                    } else {
                        this.replaceFieldReference((ASTNode)fieldAccess, fieldInfo);
                        visitChildren = false;
                    }
                }
            }
            if (visitChildren) {
                visitChildren = super.visit(fieldAccess);
            }
            return visitChildren;
        }

        public boolean visit(SuperFieldAccess superFieldAccess) {
            FieldInfo fieldInfo;
            if (superFieldAccess.getQualifier() == null && (fieldInfo = this.iEntityInfo.getFieldInfoByName(superFieldAccess.getName().getIdentifier())) != null) {
                this.replaceFieldReference((ASTNode)superFieldAccess, fieldInfo);
            }
            return false;
        }

        @Override
        public boolean visit(MethodInvocation methodInvocation) {
            String typeName;
            ITypeBinding typeBinding;
            boolean visitChildren = true;
            if (methodInvocation.getExpression() == null || methodInvocation.getExpression().getNodeType() == 52) {
                IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
                if (methodBinding != null) {
                    String methodKey = JavaUtil.getMethodKey(methodBinding);
                    if (methodKey.equals(this.iEntityInfo.getGeneratePrimaryKeyMethodKey())) {
                        MethodInvocation newMethodInvocation = methodInvocation.getAST().newMethodInvocation();
                        SimpleName newName = methodInvocation.getAST().newSimpleName("generatePrimaryKey");
                        newMethodInvocation.setName(newName);
                        this.replaceASTNode((ASTNode)methodInvocation, (ASTNode)newMethodInvocation);
                        visitChildren = false;
                    } else {
                        FieldInfo fieldInfo = this.iEntityInfo.getFieldInfoByGetterName(methodKey);
                        if (fieldInfo != null) {
                            this.replaceFieldReference((ASTNode)methodInvocation, fieldInfo);
                            visitChildren = false;
                        } else if (!methodKey.equals(this.iEntityInfo.getGeneratePrimaryKeyMethodKey()) && this.iEntityInfo.getFieldInfoByGetterName(methodKey) == null) {
                            this.iAccessBeanMethodInfo.addReferencedAccessBeanMethod(methodKey);
                        }
                    }
                } else {
                    LOGGER.info("EntityResolver no method binding for " + this.iEntityInfo.getEjbName() + " " + methodInvocation);
                }
            }
            if (methodInvocation.getExpression() != null && (typeBinding = methodInvocation.getExpression().resolveTypeBinding()) != null && (AccessBeanMethodInfo.CLOB_ATTRIBUTE_VALUE.equals(typeName = typeBinding.getQualifiedName()) || AccessBeanMethodInfo.BLOB_ATTRIBUTE_VALUE.equals(typeName))) {
                String methodName = methodInvocation.getName().getIdentifier();
                if (methodName.equals(AccessBeanMethodInfo.SET_VALUE)) {
                    Expression argument = (Expression)methodInvocation.arguments().get(0);
                    argument.delete();
                    this.replaceASTNode((ASTNode)methodInvocation, (ASTNode)argument);
                    argument.accept((ASTVisitor)this);
                    visitChildren = false;
                } else if (methodName.equals(AccessBeanMethodInfo.GET_VALUE)) {
                    String fieldName = null;
                    Expression clobExpression = methodInvocation.getExpression();
                    switch (clobExpression.getNodeType()) {
                        case 42: {
                            SimpleName simpleName = (SimpleName)clobExpression;
                            fieldName = simpleName.getIdentifier();
                            break;
                        }
                        case 22: {
                            FieldAccess fieldAccess = (FieldAccess)clobExpression;
                            fieldName = fieldAccess.getName().getIdentifier();
                            break;
                        }
                        case 47: {
                            SuperFieldAccess superFieldAccess = (SuperFieldAccess)clobExpression;
                            fieldName = superFieldAccess.getName().getIdentifier();
                        }
                    }
                    if (fieldName != null && this.iEntityInfo.getClobAttributeFieldInfo(fieldName) != null) {
                        FieldInfo fieldInfo = this.iEntityInfo.getClobAttributeFieldInfo(fieldName);
                        this.replaceFieldReference((ASTNode)methodInvocation, fieldInfo);
                        visitChildren = false;
                    }
                }
            }
            if (visitChildren) {
                visitChildren = super.visit(methodInvocation);
            }
            return visitChildren;
        }

        private void replaceFieldReference(ASTNode fieldReference, FieldInfo fieldInfo) {
            AST ast = fieldReference.getAST();
            if (fieldInfo.getRelatedEntityInfo() == null) {
                MethodInvocation getterMethodInvocation = ast.newMethodInvocation();
                getterMethodInvocation.setExpression((Expression)ast.newSimpleName("iTypedEntity"));
                getterMethodInvocation.setName(ast.newSimpleName(fieldInfo.getTargetGetterName()));
                if (fieldInfo.getColumnInfo() != null && AccessBeanMethodInfo.CHAR.equals(fieldInfo.getColumnInfo().getTypeName()) && fieldInfo.getColumnInfo().getLength() != null && fieldInfo.getColumnInfo().getLength() > 1) {
                    MethodInvocation trimMethodInvocation = ast.newMethodInvocation();
                    trimMethodInvocation.setName(ast.newSimpleName(AccessBeanMethodInfo.TRIM));
                    trimMethodInvocation.setExpression((Expression)getterMethodInvocation);
                    if (fieldInfo.getColumnInfo().getNullable()) {
                        InfixExpression infixExpression = ast.newInfixExpression();
                        infixExpression.setLeftOperand((Expression)ASTNode.copySubtree((AST)ast, (ASTNode)getterMethodInvocation));
                        infixExpression.setOperator(InfixExpression.Operator.EQUALS);
                        infixExpression.setRightOperand((Expression)ast.newNullLiteral());
                        ConditionalExpression conditionalExpression = ast.newConditionalExpression();
                        conditionalExpression.setExpression((Expression)infixExpression);
                        conditionalExpression.setThenExpression((Expression)ast.newNullLiteral());
                        conditionalExpression.setElseExpression((Expression)trimMethodInvocation);
                        this.replaceASTNode(fieldReference, (ASTNode)conditionalExpression);
                    } else {
                        this.replaceASTNode(fieldReference, (ASTNode)trimMethodInvocation);
                    }
                } else {
                    this.replaceASTNode(fieldReference, (ASTNode)getterMethodInvocation);
                }
            } else {
                RelatedEntityInfo relatedEntityInfo = fieldInfo.getRelatedEntityInfo();
                String relatedEntityGetterName = relatedEntityInfo.getGetterName();
                if (relatedEntityGetterName == null) {
                    relatedEntityGetterName = "get" + Character.toUpperCase(relatedEntityInfo.getFieldName().charAt(0)) + relatedEntityInfo.getFieldName().substring(1);
                }
                String referencedFieldGetterName = fieldInfo.getReferencedFieldInfo().getRelatedEntityInfo() == null ? fieldInfo.getReferencedFieldInfo().getTargetGetterName() : fieldInfo.getReferencedFieldInfo().getRelatedEntityInfo().getGetterName();
                ConditionalExpression conditionalExpression = ast.newConditionalExpression();
                MethodInvocation getterMethodInvocation = ast.newMethodInvocation();
                getterMethodInvocation.setExpression((Expression)ast.newSimpleName("iTypedEntity"));
                getterMethodInvocation.setName(ast.newSimpleName(relatedEntityGetterName));
                InfixExpression infixExpression = ast.newInfixExpression();
                infixExpression.setLeftOperand((Expression)getterMethodInvocation);
                infixExpression.setOperator(InfixExpression.Operator.EQUALS);
                infixExpression.setRightOperand((Expression)ast.newNullLiteral());
                conditionalExpression.setExpression((Expression)infixExpression);
                conditionalExpression.setThenExpression((Expression)ast.newNullLiteral());
                getterMethodInvocation = (MethodInvocation)ASTNode.copySubtree((AST)ast, (ASTNode)getterMethodInvocation);
                MethodInvocation fieldMethodInvocation = ast.newMethodInvocation();
                fieldMethodInvocation.setExpression((Expression)getterMethodInvocation);
                fieldMethodInvocation.setName(ast.newSimpleName(referencedFieldGetterName));
                if (fieldInfo.getReferencedFieldInfo().getRelatedEntityInfo() == null) {
                    ColumnInfo referencedColumnInfo = fieldInfo.getReferencedFieldInfo().getColumnInfo();
                    if (referencedColumnInfo != null && AccessBeanMethodInfo.CHAR.equals(referencedColumnInfo.getTypeName()) && referencedColumnInfo.getLength() != null && referencedColumnInfo.getLength() > 1) {
                        MethodInvocation trimMethodInvocation = ast.newMethodInvocation();
                        trimMethodInvocation.setName(ast.newSimpleName(AccessBeanMethodInfo.TRIM));
                        trimMethodInvocation.setExpression((Expression)fieldMethodInvocation);
                        conditionalExpression.setElseExpression((Expression)trimMethodInvocation);
                    } else {
                        conditionalExpression.setElseExpression((Expression)fieldMethodInvocation);
                    }
                } else {
                    MethodInvocation relatedFieldMethodInvocation = ast.newMethodInvocation();
                    relatedFieldMethodInvocation.setExpression((Expression)fieldMethodInvocation);
                    relatedFieldMethodInvocation.setName(ast.newSimpleName(fieldInfo.getReferencedFieldInfo().getReferencedFieldInfo().getTargetGetterName()));
                    conditionalExpression.setElseExpression((Expression)relatedFieldMethodInvocation);
                }
                ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
                parenthesizedExpression.setExpression((Expression)conditionalExpression);
                this.replaceASTNode(fieldReference, (ASTNode)parenthesizedExpression);
            }
        }

        @Override
        public void replaceASTNode(ASTNode astNode, ASTNode newNode) {
            this.iAccessBeanStatement.replaceASTNode(astNode, newNode);
        }
    }

    public static class AccessBeanIfStatement
    extends AccessBeanStatement {
        private Expression iIfExpression;
        private TargetExceptionInfo iIfExpressionUnhandledExceptions;
        private List<AccessBeanStatement> iThenStatements = new ArrayList<AccessBeanStatement>();
        private List<AccessBeanStatement> iElseStatements = new ArrayList<AccessBeanStatement>();

        public void setIfExpression(Expression ifExpression) {
            this.iIfExpression = ifExpression;
        }

        public Expression getIfExpression() {
            return this.iIfExpression;
        }

        public List<AccessBeanStatement> getThenStatements() {
            return this.iThenStatements;
        }

        public List<AccessBeanStatement> getElseStatements() {
            return this.iElseStatements;
        }

        @Override
        public void resolve(AccessBeanMethodInfo accessBeanMethodInfo, Deque<List<AccessBeanStatement>> statementListStack) {
            List<AccessBeanStatement> statementList = statementListStack.peek();
            accessBeanMethodInfo.resolveStatements(statementListStack, this.iThenStatements);
            accessBeanMethodInfo.resolveStatements(statementListStack, this.iElseStatements);
            if (this.iThenStatements.size() == 0 && this.iElseStatements.size() == 0) {
                statementList.remove(this);
            } else {
                ModuleInfo moduleInfo = accessBeanMethodInfo.getEntityInfo().getModuleInfo();
                this.iIfExpressionUnhandledExceptions = TargetExceptionUtil.getUnhandledTargetExceptions(moduleInfo.getApplicationInfo(), moduleInfo.getJavaProject(), (ASTNode)this.iIfExpression);
                accessBeanMethodInfo.renameVariables((ASTNode)this.iIfExpression);
                this.iIfExpression.accept((ASTVisitor)new AccessBeanExpressionVisitor(accessBeanMethodInfo, this));
            }
        }

        @Override
        public TargetExceptionInfo getUnhandledExceptions(AccessBeanMethodInfo accessBeanMethodInfo) {
            TargetExceptionInfo unhandledExceptions = new TargetExceptionInfo();
            unhandledExceptions.addAll(this.iIfExpressionUnhandledExceptions);
            for (AccessBeanStatement statement : this.iThenStatements) {
                unhandledExceptions.addAll(statement.getUnhandledExceptions(accessBeanMethodInfo));
            }
            for (AccessBeanStatement statement : this.iElseStatements) {
                unhandledExceptions.addAll(statement.getUnhandledExceptions(accessBeanMethodInfo));
            }
            return unhandledExceptions;
        }

        @Override
        public void replaceASTNode(ASTNode astNode, ASTNode newNode) {
            super.replaceASTNode(astNode, newNode);
            if (astNode == this.iIfExpression) {
                this.iIfExpression = (Expression)newNode;
            }
        }

        @Override
        public boolean usesVariable(String variableName) {
            boolean variableUsed = false;
            VariableCheckVisitor variableCheckVisitor = new VariableCheckVisitor(variableName);
            this.iIfExpression.accept((ASTVisitor)variableCheckVisitor);
            if (variableCheckVisitor.getVariableFound()) {
                variableUsed = true;
            } else {
                for (AccessBeanStatement statement : this.iThenStatements) {
                    if (!statement.usesVariable(variableName)) continue;
                    variableUsed = true;
                    break;
                }
                if (!variableUsed) {
                    for (AccessBeanStatement statement : this.iElseStatements) {
                        if (!statement.usesVariable(variableName)) continue;
                        variableUsed = true;
                        break;
                    }
                }
            }
            return variableUsed;
        }

        @Override
        public boolean containsStatement(AccessBeanStatement statement) {
            boolean match;
            boolean bl = match = statement == this;
            if (!match) {
                for (AccessBeanStatement currentStatement : this.iThenStatements) {
                    if (!currentStatement.containsStatement(statement)) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    for (AccessBeanStatement currentStatement : this.iElseStatements) {
                        if (!currentStatement.containsStatement(statement)) continue;
                        match = true;
                        break;
                    }
                }
            }
            return match;
        }
    }

    public static class AccessBeanInstanceVariableAssignmentStatement
    extends AccessBeanStatement {
        private String iInstanceVariableName;
        private Expression iAssignmentExpression;
        private TargetExceptionInfo iAssignmentExpressionUnhandledExceptions;

        public void setInstanceVariableName(String instanceVariableName) {
            this.iInstanceVariableName = instanceVariableName;
        }

        public String getInstanceVariableName() {
            return this.iInstanceVariableName;
        }

        public void setAssignmentExpression(Expression assignmentExpression) {
            this.iAssignmentExpression = assignmentExpression;
        }

        public Expression getAssignmentExpression() {
            return this.iAssignmentExpression;
        }

        @Override
        public void resolve(AccessBeanMethodInfo accessBeanMethodInfo, Deque<List<AccessBeanStatement>> statementListStack) {
            ModuleInfo moduleInfo = accessBeanMethodInfo.getEntityInfo().getModuleInfo();
            this.iAssignmentExpressionUnhandledExceptions = TargetExceptionUtil.getUnhandledTargetExceptions(moduleInfo.getApplicationInfo(), moduleInfo.getJavaProject(), (ASTNode)this.iAssignmentExpression);
            accessBeanMethodInfo.renameVariables((ASTNode)this.iAssignmentExpression);
            this.iAssignmentExpression.accept((ASTVisitor)new AccessBeanExpressionVisitor(accessBeanMethodInfo, this));
            accessBeanMethodInfo.setModifiedInstanceVariableName(this.iInstanceVariableName);
        }

        @Override
        public TargetExceptionInfo getUnhandledExceptions(AccessBeanMethodInfo accessBeanMethodInfo) {
            TargetExceptionInfo unhandledExceptions = new TargetExceptionInfo();
            unhandledExceptions.addAll(this.iAssignmentExpressionUnhandledExceptions);
            return unhandledExceptions;
        }

        @Override
        public void replaceASTNode(ASTNode astNode, ASTNode newNode) {
            super.replaceASTNode(astNode, newNode);
            if (astNode == this.iAssignmentExpression) {
                this.iAssignmentExpression = (Expression)newNode;
            }
        }

        @Override
        public boolean usesVariable(String variableName) {
            boolean variableUsed = false;
            VariableCheckVisitor variableCheckVisitor = new VariableCheckVisitor(variableName);
            this.iAssignmentExpression.accept((ASTVisitor)variableCheckVisitor);
            if (variableCheckVisitor.getVariableFound()) {
                variableUsed = true;
            }
            return variableUsed;
        }
    }

    public static class AccessBeanKeyParameterInitializedFieldStatement
    extends AccessBeanStatement {
        private FieldInfo iFieldInfo;

        public void setFieldInfo(FieldInfo fieldInfo) {
            this.iFieldInfo = fieldInfo;
        }

        public FieldInfo getFieldInfo() {
            return this.iFieldInfo;
        }
    }

    public static class AccessBeanMethodInvocationStatement
    extends AccessBeanStatement {
        private String iMethodKey;
        private List<Expression> iArguments = new ArrayList<Expression>();
        private TargetExceptionInfo iArgumentsUnhandledExceptions = new TargetExceptionInfo();

        public AccessBeanMethodInvocationStatement(String methodKey) {
            this.iMethodKey = methodKey;
        }

        public String getMethodKey() {
            return this.iMethodKey;
        }

        public void addArgument(Expression argument) {
            this.iArguments.add(argument);
        }

        public List<Expression> getArguments() {
            return this.iArguments;
        }

        @Override
        public void resolve(AccessBeanMethodInfo accessBeanMethodInfo, Deque<List<AccessBeanStatement>> statementListStack) {
            AccessBeanExpressionVisitor accesBeanExpressionVisitor = new AccessBeanExpressionVisitor(accessBeanMethodInfo, this);
            ModuleInfo moduleInfo = accessBeanMethodInfo.getEntityInfo().getModuleInfo();
            for (Expression argument : this.iArguments) {
                this.iArgumentsUnhandledExceptions.addAll(TargetExceptionUtil.getUnhandledTargetExceptions(moduleInfo.getApplicationInfo(), moduleInfo.getJavaProject(), (ASTNode)argument));
                accessBeanMethodInfo.renameVariables((ASTNode)argument);
                argument.accept((ASTVisitor)accesBeanExpressionVisitor);
            }
            if (this.iMethodKey.startsWith(AccessBeanMethodInfo.EJB_CREATE)) {
                String[] parameterTypes = this.iMethodKey.substring(AccessBeanMethodInfo.EJB_CREATE.length()).split("\\+");
                CreatorInfo creatorInfo = accessBeanMethodInfo.getEntityInfo().getCreatorInfo(parameterTypes);
                accessBeanMethodInfo.getEntityInfo().addCreatorCalledByCreator(creatorInfo);
            }
            accessBeanMethodInfo.addReferencedAccessBeanMethod(this.iMethodKey);
        }

        @Override
        public TargetExceptionInfo getUnhandledExceptions(AccessBeanMethodInfo accessBeanMethodInfo) {
            TargetExceptionInfo unhandledExceptions = new TargetExceptionInfo();
            unhandledExceptions.addAll(this.iArgumentsUnhandledExceptions);
            return unhandledExceptions;
        }

        @Override
        public void replaceASTNode(ASTNode astNode, ASTNode newNode) {
            super.replaceASTNode(astNode, newNode);
            int i = 0;
            while (i < this.iArguments.size()) {
                if (this.iArguments.get(i) == astNode) {
                    this.iArguments.set(i, (Expression)newNode);
                    break;
                }
                ++i;
            }
        }

        @Override
        public boolean usesVariable(String variableName) {
            boolean variableUsed = false;
            VariableCheckVisitor variableCheckVisitor = new VariableCheckVisitor(variableName);
            for (Expression argument : this.iArguments) {
                argument.accept((ASTVisitor)variableCheckVisitor);
                if (!variableCheckVisitor.getVariableFound()) continue;
                variableUsed = true;
                break;
            }
            return variableUsed;
        }
    }

    public static class AccessBeanParameterInitializedFieldStatement
    extends AccessBeanStatement {
        private FieldInfo iFieldInfo;
        private int iParameterIndex;

        public AccessBeanParameterInitializedFieldStatement(FieldInfo fieldInfo, int parameterIndex) {
            this.iFieldInfo = fieldInfo;
            this.iParameterIndex = parameterIndex;
        }

        public FieldInfo getFieldInfo() {
            return this.iFieldInfo;
        }

        public int getParameterIndex() {
            return this.iParameterIndex;
        }
    }

    public static class AccessBeanReturnStatement
    extends AccessBeanStatement {
        private Expression iReturnExpression;
        private TargetExceptionInfo iReturnExpressionUnhandledExceptions;

        public void setReturnExpression(Expression returnExpression) {
            this.iReturnExpression = returnExpression;
        }

        public Expression getReturnExpression() {
            return this.iReturnExpression;
        }

        @Override
        public void resolve(AccessBeanMethodInfo accessBeanMethodInfo, Deque<List<AccessBeanStatement>> statementListStack) {
            if (this.iReturnExpression != null) {
                ModuleInfo moduleInfo = accessBeanMethodInfo.getEntityInfo().getModuleInfo();
                this.iReturnExpressionUnhandledExceptions = TargetExceptionUtil.getUnhandledTargetExceptions(moduleInfo.getApplicationInfo(), moduleInfo.getJavaProject(), (ASTNode)this.iReturnExpression);
                accessBeanMethodInfo.renameVariables((ASTNode)this.iReturnExpression);
                this.iReturnExpression.accept((ASTVisitor)new AccessBeanExpressionVisitor(accessBeanMethodInfo, this));
            }
        }

        @Override
        public TargetExceptionInfo getUnhandledExceptions(AccessBeanMethodInfo accessBeanMethodInfo) {
            TargetExceptionInfo unhandledExceptions = new TargetExceptionInfo();
            if (this.iReturnExpressionUnhandledExceptions != null) {
                unhandledExceptions.addAll(this.iReturnExpressionUnhandledExceptions);
            }
            return unhandledExceptions;
        }

        @Override
        public void replaceASTNode(ASTNode astNode, ASTNode newNode) {
            super.replaceASTNode(astNode, newNode);
            if (this.iReturnExpression == astNode) {
                this.iReturnExpression = (Expression)newNode;
            }
        }

        @Override
        public boolean usesVariable(String variableName) {
            boolean variableUsed = false;
            if (this.iReturnExpression != null) {
                VariableCheckVisitor variableCheckVisitor = new VariableCheckVisitor(variableName);
                this.iReturnExpression.accept((ASTVisitor)variableCheckVisitor);
                if (variableCheckVisitor.getVariableFound()) {
                    variableUsed = true;
                }
            }
            return variableUsed;
        }
    }

    public static abstract class AccessBeanStatement {
        public TargetExceptionInfo getUnhandledExceptions(AccessBeanMethodInfo accessBeanMethodInfo) {
            return new TargetExceptionInfo();
        }

        public void resolve(AccessBeanMethodInfo accessBeanMethodInfo, Deque<List<AccessBeanStatement>> statementListStack) {
        }

        public void replaceASTNode(ASTNode astNode, ASTNode newNode) {
            if (astNode.getParent() != null) {
                JavaUtil.replaceASTNode(astNode, newNode);
            }
        }

        public boolean usesVariable(String variableName) {
            return false;
        }

        public boolean containsStatement(AccessBeanStatement statement) {
            return statement == this;
        }
    }

    public static class AccessBeanSuperMethodInvocationStatement
    extends AccessBeanStatement {
        private List<Expression> iArguments = new ArrayList<Expression>();

        public void addArgument(Expression argument) {
            this.iArguments.add(argument);
        }

        public List<Expression> getArguments() {
            return this.iArguments;
        }

        @Override
        public void resolve(AccessBeanMethodInfo accessBeanMethodInfo, Deque<List<AccessBeanStatement>> statementListStack) {
            List<AccessBeanStatement> statementList = statementListStack.peek();
            if (accessBeanMethodInfo.getSuperAccessBeanMethodInfo() == null) {
                statementList.remove(this);
                accessBeanMethodInfo.setCallsSuperAccessBeanMethod(false);
            }
        }

        @Override
        public TargetExceptionInfo getUnhandledExceptions(AccessBeanMethodInfo accessBeanMethodInfo) {
            TargetExceptionInfo unhandledExceptions = new TargetExceptionInfo();
            if (accessBeanMethodInfo.getSuperAccessBeanMethodInfo() != null) {
                unhandledExceptions.addAll(accessBeanMethodInfo.getSuperAccessBeanMethodInfo().getUnhandledExceptions());
            }
            return unhandledExceptions;
        }

        @Override
        public void replaceASTNode(ASTNode astNode, ASTNode newNode) {
            super.replaceASTNode(astNode, newNode);
            int i = 0;
            while (i < this.iArguments.size()) {
                if (this.iArguments.get(i) == astNode) {
                    this.iArguments.set(i, (Expression)newNode);
                    break;
                }
                ++i;
            }
        }

        @Override
        public boolean usesVariable(String variableName) {
            boolean variableUsed = false;
            VariableCheckVisitor variableCheckVisitor = new VariableCheckVisitor(variableName);
            for (Expression argument : this.iArguments) {
                argument.accept((ASTVisitor)variableCheckVisitor);
                if (!variableCheckVisitor.getVariableFound()) continue;
                variableUsed = true;
                break;
            }
            return variableUsed;
        }
    }

    public static class AccessBeanTryStatement
    extends AccessBeanStatement {
        private List<AccessBeanStatement> iTryStatements = new ArrayList<AccessBeanStatement>();
        private List<AccessBeanCatchClause> iCatchClauses = new ArrayList<AccessBeanCatchClause>();
        private List<AccessBeanStatement> iFinallyStatements = new ArrayList<AccessBeanStatement>();

        public List<AccessBeanStatement> getTryStatements() {
            return this.iTryStatements;
        }

        public List<AccessBeanCatchClause> getCatchClauses() {
            return this.iCatchClauses;
        }

        public List<AccessBeanStatement> getFinallyStatements() {
            return this.iFinallyStatements;
        }

        @Override
        public void resolve(AccessBeanMethodInfo accessBeanMethodInfo, Deque<List<AccessBeanStatement>> statementListStack) {
            block11: {
                List<AccessBeanStatement> statementList;
                block12: {
                    block10: {
                        statementList = statementListStack.peek();
                        accessBeanMethodInfo.resolveStatements(statementListStack, this.iTryStatements);
                        accessBeanMethodInfo.resolveStatements(statementListStack, this.iFinallyStatements);
                        if (this.iTryStatements.size() != 0 || this.iFinallyStatements.size() != 0) break block10;
                        statementList.remove(this);
                        break block11;
                    }
                    if (this.iTryStatements.size() != 0) break block12;
                    int index = statementList.indexOf(this);
                    statementList.remove(this);
                    while (this.iFinallyStatements.size() > 0) {
                        statementList.add(index, this.iFinallyStatements.remove(this.iFinallyStatements.size() - 1));
                    }
                    break block11;
                }
                TargetExceptionInfo tryBlockExceptionInfo = new TargetExceptionInfo();
                for (AccessBeanStatement statement : this.iTryStatements) {
                    tryBlockExceptionInfo.addAll(statement.getUnhandledExceptions(accessBeanMethodInfo));
                }
                IJavaProject javaProject = accessBeanMethodInfo.getEntityInfo().getModuleInfo().getJavaProject();
                Collection<String> tryBlockExceptions = tryBlockExceptionInfo.getTargetExceptions();
                block2: for (String exception : tryBlockExceptions) {
                    for (AccessBeanCatchClause catchClause : this.iCatchClauses) {
                        if (TargetExceptionUtil.catchHandlesException(javaProject, catchClause.getExceptionType(), exception)) {
                            catchClause.getHandledExceptions().add(exception);
                            continue block2;
                        }
                        if (!TargetExceptionUtil.catchHandlesTargetException(javaProject, catchClause.getExceptionType(), exception)) continue;
                        catchClause.getHandledExceptions().add(exception);
                        continue block2;
                    }
                }
                int i = this.iCatchClauses.size() - 1;
                while (i >= 0) {
                    AccessBeanCatchClause catchClause = this.iCatchClauses.get(i);
                    if (catchClause.getHandledExceptions().size() > 0) {
                        accessBeanMethodInfo.resolveStatements(statementListStack, catchClause.getCatchStatements());
                        if (catchClause.getCatchStatements().size() == 0) {
                            this.iCatchClauses.remove(i);
                        }
                    } else {
                        this.iCatchClauses.remove(i);
                    }
                    --i;
                }
                if (this.iCatchClauses.size() != 0 || this.iFinallyStatements.size() != 0) break block11;
                int index = statementList.indexOf(this);
                statementList.remove(this);
                while (this.iTryStatements.size() > 0) {
                    statementList.add(index, this.iTryStatements.remove(this.iTryStatements.size() - 1));
                }
            }
        }

        @Override
        public TargetExceptionInfo getUnhandledExceptions(AccessBeanMethodInfo accessBeanMethodInfo) {
            TargetExceptionInfo tryBlockTargetExceptionInfo = new TargetExceptionInfo();
            for (AccessBeanStatement statement : this.iTryStatements) {
                tryBlockTargetExceptionInfo.addAll(statement.getUnhandledExceptions(accessBeanMethodInfo));
            }
            IJavaProject javaProject = accessBeanMethodInfo.getEntityInfo().getModuleInfo().getJavaProject();
            TargetExceptionInfo unhandledExceptions = new TargetExceptionInfo();
            Collection<String> tryBlockExceptions = tryBlockTargetExceptionInfo.getTargetExceptions();
            for (String exception : tryBlockExceptions) {
                boolean handled = false;
                for (AccessBeanCatchClause catchClause : this.iCatchClauses) {
                    if (TargetExceptionUtil.catchHandlesException(javaProject, catchClause.getExceptionType(), exception)) {
                        handled = true;
                        break;
                    }
                    if (!TargetExceptionUtil.catchHandlesTargetException(javaProject, catchClause.getExceptionType(), exception)) continue;
                    handled = true;
                    break;
                }
                if (handled) continue;
                unhandledExceptions.addTargetException(exception);
            }
            for (AccessBeanCatchClause catchClause : this.iCatchClauses) {
                unhandledExceptions.addAll(catchClause.getUnhandledExceptions(accessBeanMethodInfo));
            }
            for (AccessBeanStatement statement : this.iFinallyStatements) {
                unhandledExceptions.addAll(statement.getUnhandledExceptions(accessBeanMethodInfo));
            }
            return unhandledExceptions;
        }

        @Override
        public boolean usesVariable(String variableName) {
            boolean variableUsed = false;
            for (AccessBeanStatement statement : this.iTryStatements) {
                if (!statement.usesVariable(variableName)) continue;
                variableUsed = true;
                break;
            }
            if (!variableUsed) {
                for (AccessBeanStatement statement : this.iFinallyStatements) {
                    if (!statement.usesVariable(variableName)) continue;
                    variableUsed = true;
                    break;
                }
            }
            if (!variableUsed) {
                for (AccessBeanCatchClause catchClause : this.iCatchClauses) {
                    if (!catchClause.usesVariable(variableName)) continue;
                    variableUsed = true;
                    break;
                }
            }
            return variableUsed;
        }

        @Override
        public boolean containsStatement(AccessBeanStatement statement) {
            boolean match;
            boolean bl = match = statement == this;
            if (!match) {
                for (AccessBeanStatement currentStatement : this.iTryStatements) {
                    if (!currentStatement.containsStatement(statement)) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    for (AccessBeanStatement currentStatement : this.iFinallyStatements) {
                        if (!currentStatement.containsStatement(statement)) continue;
                        match = true;
                        break;
                    }
                }
                if (!match) {
                    for (AccessBeanCatchClause catchClause : this.iCatchClauses) {
                        if (!catchClause.containsStatement(statement)) continue;
                        match = true;
                        break;
                    }
                }
            }
            return match;
        }
    }

    public static class AccessBeanUserMethodInvocationStatement
    extends AccessBeanStatement {
        private String iMethodKey;
        private List<Expression> iArguments = new ArrayList<Expression>();
        private TargetExceptionInfo iArgumentsUnhandledExceptions = new TargetExceptionInfo();

        public AccessBeanUserMethodInvocationStatement(String methodKey) {
            this.iMethodKey = methodKey;
        }

        public String getMethodKey() {
            return this.iMethodKey;
        }

        public void addArgument(Expression argument) {
            this.iArguments.add(argument);
        }

        public List<Expression> getArguments() {
            return this.iArguments;
        }

        @Override
        public void resolve(AccessBeanMethodInfo accessBeanMethodInfo, Deque<List<AccessBeanStatement>> statementListStack) {
            AccessBeanExpressionVisitor accessBeanExpressionVisitor = new AccessBeanExpressionVisitor(accessBeanMethodInfo, this);
            ModuleInfo moduleInfo = accessBeanMethodInfo.getEntityInfo().getModuleInfo();
            for (Expression argument : this.iArguments) {
                this.iArgumentsUnhandledExceptions.addAll(TargetExceptionUtil.getUnhandledTargetExceptions(moduleInfo.getApplicationInfo(), moduleInfo.getJavaProject(), (ASTNode)argument));
                accessBeanMethodInfo.renameVariables((ASTNode)argument);
                argument.accept((ASTVisitor)accessBeanExpressionVisitor);
            }
        }

        @Override
        public TargetExceptionInfo getUnhandledExceptions(AccessBeanMethodInfo accessBeanMethodInfo) {
            TargetExceptionInfo unhandledExceptions = new TargetExceptionInfo();
            unhandledExceptions.addAll(this.iArgumentsUnhandledExceptions);
            return unhandledExceptions;
        }

        @Override
        public void replaceASTNode(ASTNode astNode, ASTNode newNode) {
            super.replaceASTNode(astNode, newNode);
            int i = 0;
            while (i < this.iArguments.size()) {
                if (this.iArguments.get(i) == astNode) {
                    this.iArguments.set(i, (Expression)newNode);
                    break;
                }
                ++i;
            }
        }

        @Override
        public boolean usesVariable(String variableName) {
            boolean variableUsed = false;
            VariableCheckVisitor variableCheckVisitor = new VariableCheckVisitor(variableName);
            for (Expression argument : this.iArguments) {
                argument.accept((ASTVisitor)variableCheckVisitor);
                if (!variableCheckVisitor.getVariableFound()) continue;
                variableUsed = true;
                break;
            }
            return variableUsed;
        }
    }

    public static class AccessBeanVariableAssignmentStatement
    extends AccessBeanStatement {
        private String iVariableName;
        private Expression iAssignmentExpression;
        private TargetExceptionInfo iAssignmentExpressionUnhandledExceptions;

        public void setVariableName(String variableName) {
            this.iVariableName = variableName;
        }

        public String getVariableName() {
            return this.iVariableName;
        }

        public void setAssignmentExpression(Expression assignmentExpression) {
            this.iAssignmentExpression = assignmentExpression;
        }

        public Expression getAssignmentExpression() {
            return this.iAssignmentExpression;
        }

        @Override
        public void resolve(AccessBeanMethodInfo accessBeanMethodInfo, Deque<List<AccessBeanStatement>> statementListStack) {
            boolean variableUsed = false;
            block0: for (List<AccessBeanStatement> statementList : statementListStack) {
                boolean beforeCurrentStatement = true;
                for (AccessBeanStatement statement : statementList) {
                    if (beforeCurrentStatement && statement.containsStatement(this)) {
                        beforeCurrentStatement = false;
                        continue;
                    }
                    if (!statement.usesVariable(this.iVariableName)) continue;
                    variableUsed = true;
                    continue block0;
                }
            }
            if (!variableUsed) {
                statementListStack.peek().remove(this);
            } else {
                ModuleInfo moduleInfo = accessBeanMethodInfo.getEntityInfo().getModuleInfo();
                this.iAssignmentExpressionUnhandledExceptions = TargetExceptionUtil.getUnhandledTargetExceptions(moduleInfo.getApplicationInfo(), moduleInfo.getJavaProject(), (ASTNode)this.iAssignmentExpression);
                accessBeanMethodInfo.renameVariables((ASTNode)this.iAssignmentExpression);
                this.iAssignmentExpression.accept((ASTVisitor)new AccessBeanExpressionVisitor(accessBeanMethodInfo, this));
            }
        }

        @Override
        public TargetExceptionInfo getUnhandledExceptions(AccessBeanMethodInfo accessBeanMethodInfo) {
            TargetExceptionInfo unhandledExceptions = new TargetExceptionInfo();
            unhandledExceptions.addAll(this.iAssignmentExpressionUnhandledExceptions);
            return unhandledExceptions;
        }

        @Override
        public void replaceASTNode(ASTNode astNode, ASTNode newNode) {
            super.replaceASTNode(astNode, newNode);
            if (astNode == this.iAssignmentExpression) {
                this.iAssignmentExpression = (Expression)newNode;
            }
        }

        @Override
        public boolean usesVariable(String variableName) {
            boolean variableUsed = false;
            VariableCheckVisitor variableCheckVisitor = new VariableCheckVisitor(variableName);
            this.iAssignmentExpression.accept((ASTVisitor)variableCheckVisitor);
            if (variableCheckVisitor.getVariableFound()) {
                variableUsed = true;
            }
            return variableUsed;
        }
    }

    public static class AccessBeanVariableDeclarationStatement
    extends AccessBeanStatement {
        private String iVariableName;
        private String iType;
        private Expression iInitializationExpression;
        private TargetExceptionInfo iInitializationExpressionUnhandledExceptions;

        public void setVariableName(String variableName) {
            this.iVariableName = variableName;
        }

        public String getVariableName() {
            return this.iVariableName;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public String getType() {
            return this.iType;
        }

        public void setInitializationExpression(Expression initializationExpression) {
            this.iInitializationExpression = initializationExpression;
        }

        public Expression getInitializationExpression() {
            return this.iInitializationExpression;
        }

        @Override
        public void resolve(AccessBeanMethodInfo accessBeanMethodInfo, Deque<List<AccessBeanStatement>> statementListStack) {
            boolean variableUsed = false;
            block0: for (List<AccessBeanStatement> statementList : statementListStack) {
                boolean beforeCurrentStatement = true;
                for (AccessBeanStatement statement : statementList) {
                    if (beforeCurrentStatement) {
                        if (!statement.containsStatement(this)) continue;
                        beforeCurrentStatement = false;
                        continue;
                    }
                    if (!statement.usesVariable(this.iVariableName)) continue;
                    variableUsed = true;
                    continue block0;
                }
            }
            if (!variableUsed) {
                statementListStack.peek().remove(this);
            } else if (this.iInitializationExpression != null) {
                ModuleInfo moduleInfo = accessBeanMethodInfo.getEntityInfo().getModuleInfo();
                this.iInitializationExpressionUnhandledExceptions = TargetExceptionUtil.getUnhandledTargetExceptions(moduleInfo.getApplicationInfo(), moduleInfo.getJavaProject(), (ASTNode)this.iInitializationExpression);
                accessBeanMethodInfo.renameVariables((ASTNode)this.iInitializationExpression);
                this.iInitializationExpression.accept((ASTVisitor)new AccessBeanExpressionVisitor(accessBeanMethodInfo, this));
            }
        }

        @Override
        public TargetExceptionInfo getUnhandledExceptions(AccessBeanMethodInfo accessBeanMethodInfo) {
            TargetExceptionInfo unhandledExceptions = new TargetExceptionInfo();
            if (this.iInitializationExpressionUnhandledExceptions != null) {
                unhandledExceptions.addAll(this.iInitializationExpressionUnhandledExceptions);
            }
            return unhandledExceptions;
        }

        @Override
        public void replaceASTNode(ASTNode astNode, ASTNode newNode) {
            super.replaceASTNode(astNode, newNode);
            if (astNode == this.iInitializationExpression) {
                this.iInitializationExpression = (Expression)newNode;
            }
        }

        @Override
        public boolean usesVariable(String variableName) {
            boolean variableUsed = false;
            if (this.iInitializationExpression != null) {
                VariableCheckVisitor variableCheckVisitor = new VariableCheckVisitor(variableName);
                this.iInitializationExpression.accept((ASTVisitor)variableCheckVisitor);
                if (variableCheckVisitor.getVariableFound()) {
                    variableUsed = true;
                }
            }
            return variableUsed;
        }
    }

    public static class AccessBeanVariableMethodInvocationStatement
    extends AccessBeanStatement {
        private String iVariableName;
        private String iVariableType;
        private String iMethodName;
        private String iMethodKey;
        private List<Expression> iArguments = new ArrayList<Expression>();
        private TargetExceptionInfo iArgumentsUnhandledExceptions = new TargetExceptionInfo();

        public void setVariableName(String variableName) {
            this.iVariableName = variableName;
        }

        public String getVariableName() {
            return this.iVariableName;
        }

        public void setVariableType(String variableType) {
            this.iVariableType = variableType;
        }

        public String getVariableType() {
            return this.iVariableType;
        }

        public void setMethodName(String methodName) {
            this.iMethodName = methodName;
        }

        public String getMethodName() {
            return this.iMethodName;
        }

        public void setMethodKey(String methodKey) {
            this.iMethodKey = methodKey;
        }

        public String getMethodKey() {
            return this.iMethodKey;
        }

        public void addArgument(Expression argument) {
            this.iArguments.add(argument);
        }

        public List<Expression> getArguments() {
            return this.iArguments;
        }

        @Override
        public void resolve(AccessBeanMethodInfo accessBeanMethodInfo, Deque<List<AccessBeanStatement>> statementListStack) {
            EntityInfo entityInfo;
            boolean variableUsed = false;
            ApplicationInfo applicationInfo = accessBeanMethodInfo.getEntityInfo().getModuleInfo().getApplicationInfo();
            boolean isAccessBeanType = applicationInfo.isAccessBeanType(this.iVariableType);
            if (isAccessBeanType && (entityInfo = applicationInfo.getEntityInfoForType(this.iVariableType)).getUserMethodInfo(this.iMethodKey) != null) {
                variableUsed = true;
            }
            boolean isEntityCreationDataCopyFields = false;
            if (AccessBeanMethodInfo.ENTITY_CREATION_DATA.equals(this.iVariableType) && AccessBeanMethodInfo.COPY_FIELDS.equals(this.iMethodName)) {
                variableUsed = true;
                isEntityCreationDataCopyFields = true;
            }
            if (!variableUsed) {
                block0: for (List<AccessBeanStatement> statementList : statementListStack) {
                    boolean beforeCurrentStatement = true;
                    for (AccessBeanStatement statement : statementList) {
                        if (beforeCurrentStatement && statement.containsStatement(this)) {
                            beforeCurrentStatement = false;
                            continue;
                        }
                        if (!statement.usesVariable(this.iVariableName)) continue;
                        variableUsed = true;
                        continue block0;
                    }
                }
            }
            if (isEntityCreationDataCopyFields) {
                List<AccessBeanStatement> statementList;
                statementList = statementListStack.peek();
                int location = statementList.indexOf(this);
                Set<FieldInfo> fields = accessBeanMethodInfo.getEntityInfo().getEntityCreationDataFields();
                for (FieldInfo fieldInfo : fields) {
                    AccessBeanEntityCreationDataInitializedFieldStatement statement = new AccessBeanEntityCreationDataInitializedFieldStatement();
                    statement.setFieldInfo(fieldInfo);
                    statementList.add(location, statement);
                }
                statementList.remove(this);
            } else if (!variableUsed || isAccessBeanType && AccessBeanMethodInfo.COMMIT_COPY_HELPER.equals(this.iMethodName)) {
                statementListStack.peek().remove(this);
            } else {
                AccessBeanExpressionVisitor accessBeanExpressionVisitor = new AccessBeanExpressionVisitor(accessBeanMethodInfo, this);
                ModuleInfo moduleInfo = accessBeanMethodInfo.getEntityInfo().getModuleInfo();
                for (Expression argument : this.iArguments) {
                    this.iArgumentsUnhandledExceptions.addAll(TargetExceptionUtil.getUnhandledTargetExceptions(moduleInfo.getApplicationInfo(), moduleInfo.getJavaProject(), (ASTNode)argument));
                    accessBeanMethodInfo.renameVariables((ASTNode)argument);
                    argument.accept((ASTVisitor)accessBeanExpressionVisitor);
                }
            }
        }

        @Override
        public TargetExceptionInfo getUnhandledExceptions(AccessBeanMethodInfo accessBeanMethodInfo) {
            TargetExceptionInfo unhandledExceptions = new TargetExceptionInfo();
            unhandledExceptions.addAll(this.iArgumentsUnhandledExceptions);
            return unhandledExceptions;
        }

        @Override
        public void replaceASTNode(ASTNode astNode, ASTNode newNode) {
            super.replaceASTNode(astNode, newNode);
            int i = 0;
            while (i < this.iArguments.size()) {
                if (this.iArguments.get(i) == astNode) {
                    this.iArguments.set(i, (Expression)newNode);
                    break;
                }
                ++i;
            }
        }

        @Override
        public boolean usesVariable(String variableName) {
            boolean variableUsed = variableName.equals(this.iVariableName);
            if (!variableUsed) {
                VariableCheckVisitor variableCheckVisitor = new VariableCheckVisitor(variableName);
                for (Expression argument : this.iArguments) {
                    argument.accept((ASTVisitor)variableCheckVisitor);
                    if (!variableCheckVisitor.getVariableFound()) continue;
                    variableUsed = true;
                    break;
                }
            }
            return variableUsed;
        }
    }

    private static class VariableCheckVisitor
    extends ASTVisitor {
        private String iVariableName;
        private boolean iVariableFound = false;

        public VariableCheckVisitor(String variableName) {
            this.iVariableName = variableName;
        }

        public boolean visit(SimpleName simpleName) {
            if (this.iVariableName.equals(simpleName.getIdentifier())) {
                IVariableBinding variableBinding;
                IBinding binding = simpleName.resolveBinding();
                if (binding == null) {
                    this.iVariableFound = true;
                } else if (binding instanceof IVariableBinding && (variableBinding = (IVariableBinding)binding).getDeclaringMethod() != null) {
                    this.iVariableFound = true;
                }
            }
            return false;
        }

        public boolean getVariableFound() {
            return this.iVariableFound;
        }
    }

    private static class VariableRenameVisitor
    extends ASTVisitor {
        private Map<String, String> iVariableNameMap;

        public VariableRenameVisitor(Map<String, String> variableMap) {
            this.iVariableNameMap = variableMap;
        }

        public boolean visit(SimpleName simpleName) {
            IVariableBinding variableBinding;
            IBinding binding;
            if (this.iVariableNameMap.containsKey(simpleName.getIdentifier()) && (binding = simpleName.resolveBinding()) instanceof IVariableBinding && (variableBinding = (IVariableBinding)binding).getDeclaringMethod() != null) {
                simpleName.setIdentifier(this.iVariableNameMap.get(simpleName.getIdentifier()));
            }
            return false;
        }
    }
}

