/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.generators;

import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.util.AbstractEntityDataUtil;
import com.ibm.commerce.jpa.port.util.AccessBeanUtil;
import com.ibm.commerce.jpa.port.util.DataClassUtil;
import com.ibm.commerce.jpa.port.util.EntityUtil;
import com.ibm.commerce.jpa.port.util.FinderResultCacheUtil;
import com.ibm.commerce.jpa.port.util.HomeInterfaceUtil;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import com.ibm.commerce.jpa.port.util.PrimaryKeyUtil;
import com.ibm.commerce.jpa.port.util.RefreshOnceUtil;
import com.ibm.commerce.jpa.port.util.TargetExceptionUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public class PortVisitor
extends ASTVisitor {
    private static final String PROP_PORTED = "ported";
    private static final String ABSTRACT_ENTITY_ACCESS_BEAN = "com.ibm.ivj.ejb.runtime.AbstractEntityAccessBean";
    private static final String COMMIT_COPY_HELPER = "commitCopyHelper";
    private static final String REFRESH_COPY_HELPER = "refreshCopyHelper";
    private static final String INSTANTIATE_ENTITY = "instantiateEntity";
    private static final String SET_INIT_KEY = "setInitKey_";
    private static final String GET_EJB_REF = "getEJBRef";
    private static final String RESET_EJB_REF = "resetEJBRef";
    private static final String DETACH = "detach";
    private static final String REMOVE = "remove";
    private static final String EJB_OBJECT = "javax.ejb.EJBObject";
    private static final String GET_KEY = "__getKey";
    private static final Map<String, PrimitiveType.Code> PRIMITIVE_TYPES = new HashMap<String, PrimitiveType.Code>();
    private ApplicationInfo iApplicationInfo;
    private IJavaProject iJavaProject;
    private boolean iEntityReferencingType = false;

    static {
        PRIMITIVE_TYPES.put("byte", PrimitiveType.BYTE);
        PRIMITIVE_TYPES.put("short", PrimitiveType.SHORT);
        PRIMITIVE_TYPES.put("char", PrimitiveType.CHAR);
        PRIMITIVE_TYPES.put("int", PrimitiveType.INT);
        PRIMITIVE_TYPES.put("long", PrimitiveType.LONG);
        PRIMITIVE_TYPES.put("float", PrimitiveType.FLOAT);
        PRIMITIVE_TYPES.put("double", PrimitiveType.DOUBLE);
    }

    public PortVisitor(ApplicationInfo applicationInfo, IJavaProject javaProject) {
        this.iApplicationInfo = applicationInfo;
        this.iJavaProject = javaProject;
    }

    public PortVisitor(ApplicationInfo applicationInfo, IJavaProject javaProject, boolean entityReferencingType) {
        this.iApplicationInfo = applicationInfo;
        this.iJavaProject = javaProject;
        this.iEntityReferencingType = entityReferencingType;
    }

    public boolean preVisit2(ASTNode astNode) {
        boolean callVisit = true;
        if (astNode instanceof Statement) {
            callVisit = false;
            if (astNode.getProperty(PROP_PORTED) == null) {
                callVisit = true;
                this.markAsPorted(astNode);
            }
        }
        if (callVisit) {
            callVisit = super.preVisit2(astNode);
        }
        return callVisit;
    }

    public void markAsPorted(ASTNode astNode) {
        astNode.setProperty(PROP_PORTED, (Object)Boolean.TRUE);
    }

    public boolean visit(SimpleType simpleType) {
        String qualifiedTypeName;
        String newTypeName;
        ITypeBinding typeBinding = simpleType.resolveBinding();
        if (typeBinding != null && (newTypeName = this.getTypeMapping(qualifiedTypeName = typeBinding.getQualifiedName())) != null) {
            if (PRIMITIVE_TYPES.get(newTypeName) != null) {
                PrimitiveType newPrimitiveType = simpleType.getAST().newPrimitiveType(PRIMITIVE_TYPES.get(newTypeName));
                this.replaceASTNode((ASTNode)simpleType, (ASTNode)newPrimitiveType);
            } else {
                SimpleType newSimpleType = simpleType.getAST().newSimpleType(simpleType.getAST().newName(newTypeName));
                this.replaceASTNode((ASTNode)simpleType, (ASTNode)newSimpleType);
            }
        }
        return false;
    }

    public boolean visit(ParameterizedType parameterizedType) {
        String qualifiedTypeName;
        String newTypeName;
        ITypeBinding typeBinding = parameterizedType.resolveBinding();
        if (typeBinding != null && (newTypeName = this.getTypeMapping(qualifiedTypeName = typeBinding.getTypeDeclaration().getQualifiedName())) != null) {
            AST ast = parameterizedType.getAST();
            parameterizedType.setType((Type)ast.newSimpleType(ast.newName(newTypeName)));
        }
        return true;
    }

    public boolean visit(SimpleName simpleName) {
        ITypeBinding typeBinding;
        String qualifiedTypeName;
        String newTypeName;
        IBinding binding;
        if (!simpleName.isDeclaration() && (binding = simpleName.resolveBinding()) != null && binding.getKind() == 2 && (newTypeName = this.getTypeMapping(qualifiedTypeName = (typeBinding = (ITypeBinding)binding).getQualifiedName())) != null) {
            this.replaceASTNode((ASTNode)simpleName, (ASTNode)simpleName.getAST().newName(newTypeName));
        }
        return false;
    }

    public boolean visit(QualifiedName qualifiedName) {
        ITypeBinding typeBinding;
        String qualifiedTypeName;
        String newTypeName;
        boolean visitChildren = true;
        IBinding binding = qualifiedName.resolveBinding();
        if (binding != null && binding.getKind() == 2 && (newTypeName = this.getTypeMapping(qualifiedTypeName = (typeBinding = (ITypeBinding)binding).getQualifiedName())) != null) {
            this.replaceASTNode((ASTNode)qualifiedName, (ASTNode)qualifiedName.getAST().newName(newTypeName));
            visitChildren = false;
        }
        if (visitChildren && PrimaryKeyUtil.isPrimaryKeyQualifiedName(this.iApplicationInfo, qualifiedName)) {
            visitChildren = PrimaryKeyUtil.portPrimaryQualifiedName(this.iApplicationInfo, qualifiedName, this);
        }
        if (visitChildren) {
            qualifiedName.getQualifier().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(FieldAccess fieldAccess) {
        boolean visitChildren = true;
        if (PrimaryKeyUtil.isPrimaryKeyFieldAccess(this.iApplicationInfo, fieldAccess)) {
            visitChildren = PrimaryKeyUtil.portPrimaryKeyFieldAccess(this.iApplicationInfo, fieldAccess, this);
        }
        return visitChildren;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        boolean visitChildren = true;
        if (HomeInterfaceUtil.isGetHomeInterfaceMethodInvocation(this.iApplicationInfo, methodInvocation)) {
            visitChildren = HomeInterfaceUtil.portGetHomeInterfaceMethodInvocation(this.iApplicationInfo, methodInvocation, this);
        }
        if (PrimaryKeyUtil.isPrimaryKeyMethodInvocation(this.iApplicationInfo, methodInvocation, this)) {
            PrimaryKeyUtil.portPrimaryKeyMethodInvocation(this.iApplicationInfo, methodInvocation, this);
        }
        if (DataClassUtil.isGetPrimaryKeyMethodInvocation(this.iApplicationInfo, methodInvocation)) {
            DataClassUtil.portGetPrimaryKeyMethodInvocation(this.iApplicationInfo, methodInvocation, this);
        }
        if (visitChildren) {
            IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
            String methodName = methodInvocation.getName().getIdentifier();
            if (methodInvocation.getExpression() != null && methodInvocation.getExpression().getNodeType() != 52) {
                if (AccessBeanUtil.isAccessBeanType(this.iApplicationInfo, methodInvocation.getExpression()) || AccessBeanUtil.isAccessBeanSubclass(this.iApplicationInfo, methodInvocation.getExpression())) {
                    AccessBeanUtil.updateAccessBeanMethodName(this.iApplicationInfo, this, methodInvocation);
                }
                if (FinderResultCacheUtil.isFinderResultCacheUtil(methodBinding != null ? methodBinding.getDeclaringClass() : null)) {
                    if (FinderResultCacheUtil.isNewAccessBeanMethod(methodName)) {
                        ITypeBinding methodInvocationTypeBinding = methodInvocation.resolveTypeBinding();
                        String accessBeanType = methodInvocationTypeBinding.getQualifiedName();
                        if (this.iApplicationInfo.isAccessBeanType(accessBeanType)) {
                            ClassInstanceCreation classInstanceCreation = methodInvocation.getAST().newClassInstanceCreation();
                            classInstanceCreation.setType((Type)methodInvocation.getAST().newSimpleType(methodInvocation.getAST().newName(this.getTypeMapping(accessBeanType))));
                            this.replaceASTNode((ASTNode)methodInvocation, (ASTNode)classInstanceCreation);
                            visitChildren = false;
                        }
                    } else if (FinderResultCacheUtil.isFindAsCollectionMethod(methodName)) {
                        visitChildren = FinderResultCacheUtil.replaceFindAsCollectionMethodInvocation(this.iApplicationInfo, methodInvocation, this);
                    } else if (FinderResultCacheUtil.isFindUsingJDBCMethod(methodName)) {
                        visitChildren = FinderResultCacheUtil.replaceFindUsingJDBCMethodInvocation(this.iApplicationInfo, methodInvocation, this);
                    } else if (FinderResultCacheUtil.isGetAsCollectionMethod(methodName)) {
                        visitChildren = FinderResultCacheUtil.replaceGetAsCollectionMethodInvocation(this.iApplicationInfo, methodInvocation, this);
                    } else if (FinderResultCacheUtil.isFinderMethod(methodName)) {
                        visitChildren = FinderResultCacheUtil.replaceFinderMethodInvocation(this.iApplicationInfo, methodInvocation, this);
                    } else if (FinderResultCacheUtil.isUserMethod(this.iApplicationInfo, methodInvocation)) {
                        visitChildren = FinderResultCacheUtil.replaceUserMethodInvocation(this.iApplicationInfo, methodInvocation, this);
                    } else if (FinderResultCacheUtil.isAccessBeanConversionMethodInvocation(this.iApplicationInfo, methodInvocation)) {
                        visitChildren = FinderResultCacheUtil.portAccessBeanConversionMethodInvocation(this.iApplicationInfo, methodInvocation, this);
                    } else if (FinderResultCacheUtil.isGetCachedAccessBeanMethodInvocation(this.iApplicationInfo, methodInvocation)) {
                        visitChildren = FinderResultCacheUtil.portGetCachedAccessBeanMethodInvocation(this.iApplicationInfo, methodInvocation, this);
                    }
                }
                if (EntityUtil.isEntityMethodInvocation(this.iApplicationInfo, methodInvocation)) {
                    visitChildren = EntityUtil.portEntityMethodInvocation(this.iApplicationInfo, methodInvocation, this);
                } else if (HomeInterfaceUtil.isHomeInterfaceCreateMethodInvocation(this.iApplicationInfo, methodInvocation)) {
                    visitChildren = HomeInterfaceUtil.portHomeInterfaceCreateMethodInvocation(this.iApplicationInfo, methodInvocation, this);
                } else if (AbstractEntityDataUtil.isGetAbstractEntityDataMethodInvocation(this.iApplicationInfo, methodInvocation)) {
                    visitChildren = AbstractEntityDataUtil.portGetAbstractEntityDataMethodInvocation(this.iApplicationInfo, methodInvocation, this);
                } else if (AbstractEntityDataUtil.isSetAbstractEntityDataMethodInvocation(this.iApplicationInfo, methodInvocation)) {
                    visitChildren = AbstractEntityDataUtil.portSetAbstractEntityDataMethodInvocation(this.iApplicationInfo, methodInvocation, this);
                } else if (FinderResultCacheUtil.isGetClassNameMethodInvocation(methodInvocation)) {
                    visitChildren = FinderResultCacheUtil.portGetClassNameMethodInvocation(methodInvocation, this);
                } else if (RefreshOnceUtil.isRefreshOnceAccessBeanHelper(methodBinding != null ? methodBinding.getDeclaringClass() : null)) {
                    visitChildren = RefreshOnceUtil.portRefreshOnceAccessBeanHelperMethodInvocation(this.iApplicationInfo, methodInvocation, this);
                }
            }
        }
        return visitChildren;
    }

    public boolean visit(Assignment assignment) {
        boolean visitChildren = true;
        if (PrimaryKeyUtil.isPrimaryKeyAssignment(this.iApplicationInfo, assignment)) {
            visitChildren = PrimaryKeyUtil.portPrimaryKeyAssignment(this.iApplicationInfo, assignment, this);
        }
        return visitChildren;
    }

    public boolean visit(ExpressionStatement expressionStatement) {
        boolean visitChildren = true;
        Expression statementExpression = expressionStatement.getExpression();
        if (FinderResultCacheUtil.isFindByPrimaryKeyStatement(this.iApplicationInfo, expressionStatement)) {
            visitChildren = FinderResultCacheUtil.portFindByPrimaryKeyStatement(this.iApplicationInfo, expressionStatement, this);
        } else if (FinderResultCacheUtil.isConditionalFindByPrimaryKeyStatement(this.iApplicationInfo, expressionStatement)) {
            visitChildren = FinderResultCacheUtil.portConditionalFindByPrimaryKeyStatement(this.iApplicationInfo, expressionStatement, this);
        } else if (statementExpression.getNodeType() == 7) {
            Assignment assignment = (Assignment)statementExpression;
            if (FinderResultCacheUtil.isGetCachedAccessBeanAssignment(this.iApplicationInfo, assignment)) {
                expressionStatement.delete();
                visitChildren = false;
            }
        } else if (AbstractEntityDataUtil.isGetAbstractEntityDataExpressionStatement(this.iApplicationInfo, expressionStatement) || AbstractEntityDataUtil.isSetAbstractEntityDataExpressionStatement(this.iApplicationInfo, expressionStatement)) {
            expressionStatement.delete();
            visitChildren = false;
        } else if (statementExpression.getNodeType() == 32) {
            ITypeBinding typeBinding;
            MethodInvocation methodInvocation = (MethodInvocation)statementExpression;
            String methodName = methodInvocation.getName().getIdentifier();
            int argumentCount = methodInvocation.arguments().size();
            if (methodInvocation.getExpression() != null && (typeBinding = methodInvocation.getExpression().resolveTypeBinding()) != null) {
                String ejbObjectMethodName;
                MethodInvocation ejbObjectMethodInvocation;
                String qualifiedTypeName = typeBinding.getQualifiedName();
                if (ABSTRACT_ENTITY_ACCESS_BEAN.equals(qualifiedTypeName) || this.iApplicationInfo.isAccessBeanType(qualifiedTypeName) || this.iApplicationInfo.isAccessBeanSubclass(qualifiedTypeName)) {
                    if (COMMIT_COPY_HELPER.equals(methodName) || REFRESH_COPY_HELPER.equals(methodName) && argumentCount == 1 || qualifiedTypeName.equals("com.ibm.commerce.collaboration.cc.objects.QueueAccessBean") && methodName.equals("setInit_Store_id")) {
                        expressionStatement.delete();
                        visitChildren = false;
                    } else if (REFRESH_COPY_HELPER.equals(methodName) || GET_EJB_REF.equals(methodName)) {
                        methodInvocation.setName(methodInvocation.getAST().newSimpleName(INSTANTIATE_ENTITY));
                        visitChildren = false;
                    } else if (RESET_EJB_REF.equals(methodName)) {
                        methodInvocation.setName(methodInvocation.getAST().newSimpleName(DETACH));
                        visitChildren = false;
                    } else if (methodName.startsWith(SET_INIT_KEY) && argumentCount == 1) {
                        Expression expression = (Expression)methodInvocation.arguments().get(0);
                        GetKeyReferenceVisitor getKeyReferenceVisitor = new GetKeyReferenceVisitor(methodInvocation.getExpression());
                        expression.accept((ASTVisitor)getKeyReferenceVisitor);
                        if (getKeyReferenceVisitor.getReferencesGetKey()) {
                            expressionStatement.delete();
                            visitChildren = false;
                        }
                    }
                } else if (EJB_OBJECT.equals(qualifiedTypeName) && methodInvocation.getExpression().getNodeType() == 32 && methodName.equals(REMOVE) && (ejbObjectMethodInvocation = (MethodInvocation)methodInvocation.getExpression()).getExpression() != null && (typeBinding = ejbObjectMethodInvocation.getExpression().resolveTypeBinding()) != null && AccessBeanUtil.isAccessBeanType(this.iApplicationInfo, qualifiedTypeName = typeBinding.getQualifiedName()) && GET_EJB_REF.equals(ejbObjectMethodName = ejbObjectMethodInvocation.getName().getIdentifier())) {
                    Expression accessBeanExpression = ejbObjectMethodInvocation.getExpression();
                    accessBeanExpression.delete();
                    accessBeanExpression.accept((ASTVisitor)this);
                    methodInvocation.setExpression(accessBeanExpression);
                    visitChildren = false;
                }
            }
        }
        return visitChildren;
    }

    public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
        boolean visitChildren = true;
        visitChildren = FinderResultCacheUtil.isFindByPrimaryKeyStatement(this.iApplicationInfo, variableDeclarationStatement) ? FinderResultCacheUtil.portFindByPrimaryKeyStatement(this.iApplicationInfo, variableDeclarationStatement, this) : (EntityUtil.isEjbObjectVariableDeclarationStatement(variableDeclarationStatement) ? EntityUtil.portEjbObjectVariableDeclarationStatement(variableDeclarationStatement, this) : (HomeInterfaceUtil.isHomeInterfaceVariableDeclarationStatement(this.iApplicationInfo, variableDeclarationStatement) ? HomeInterfaceUtil.portHomeInterfaceVariableDeclarationStatement(this.iApplicationInfo, variableDeclarationStatement, this) : TargetExceptionUtil.portVariableDeclarationStatement(variableDeclarationStatement, this)));
        return visitChildren;
    }

    public boolean visit(ThrowStatement throwStatement) {
        TargetExceptionUtil.portThrowStatement(throwStatement, this.iEntityReferencingType);
        return true;
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        boolean visitChildren = true;
        if (PrimaryKeyUtil.isPrimaryKeyClassInstanceCreation(this.iApplicationInfo, classInstanceCreation)) {
            visitChildren = PrimaryKeyUtil.portPrimaryKeyClassInstanceCreation(this.iApplicationInfo, classInstanceCreation, this);
        } else if (AccessBeanUtil.isAccessBeanEjbObjectClassInstanceCreation(this.iApplicationInfo, classInstanceCreation)) {
            visitChildren = AccessBeanUtil.portAccessBeanEjbObjectClassInstanceCreation(this.iApplicationInfo, classInstanceCreation, this);
        }
        if (visitChildren && classInstanceCreation.getExpression() != null) {
            visitChildren = false;
            classInstanceCreation.getExpression().accept((ASTVisitor)this);
            List arguments = classInstanceCreation.arguments();
            if (arguments != null) {
                for (Expression argument : arguments) {
                    argument.accept((ASTVisitor)this);
                }
            }
        }
        return visitChildren;
    }

    public boolean visit(CastExpression castExpression) {
        boolean visitChildren = true;
        if (AccessBeanUtil.isAccessBeanNarrowCastExpression(this.iApplicationInfo, castExpression)) {
            visitChildren = AccessBeanUtil.portAccessBeanNarrowCastExpression(this.iApplicationInfo, castExpression, this);
        } else if (DataClassUtil.isGetPrimaryKeyCastExpression(this.iApplicationInfo, castExpression)) {
            visitChildren = DataClassUtil.portGetPrimaryKeyCastExpression(this.iApplicationInfo, castExpression, this);
        } else if (PrimaryKeyUtil.isGetPrimaryKeyCastExpression(this.iApplicationInfo, castExpression)) {
            visitChildren = PrimaryKeyUtil.portGetPrimaryKeyCastExpression(this.iApplicationInfo, castExpression, this);
        }
        return visitChildren;
    }

    public boolean visit(Block block) {
        boolean visitChildren = true;
        if (AccessBeanUtil.isEjbObjectRemoveBlock(block)) {
            visitChildren = AccessBeanUtil.portEjbObjectRemoveBlock(block, this);
        }
        return visitChildren;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        boolean visitChildren = true;
        if (HomeInterfaceUtil.isGetHomeInterfaceMethodDeclaration(this.iApplicationInfo, methodDeclaration)) {
            methodDeclaration.delete();
            visitChildren = false;
        }
        return visitChildren;
    }

    public boolean visit(FieldDeclaration fieldDeclaration) {
        boolean visitChildren = true;
        if (HomeInterfaceUtil.isHomeInterfaceJndiNameField(this.iApplicationInfo, fieldDeclaration)) {
            fieldDeclaration.delete();
            visitChildren = false;
        }
        return visitChildren;
    }

    public void endVisit(TryStatement tryStatement) {
        TargetExceptionUtil.portTryStatement(this.iJavaProject, tryStatement, this, this.iEntityReferencingType);
    }

    public void replaceASTNode(ASTNode astNode, ASTNode newNode) {
        JavaUtil.replaceASTNode(astNode, newNode);
    }

    public void replaceStatement(Statement statement, List<Statement> newStatementList) {
        JavaUtil.replaceStatement(statement, newStatementList);
    }

    public String getTypeMapping(String typeName) {
        return this.iApplicationInfo.getTypeMapping(typeName);
    }

    private static class GetKeyReferenceVisitor
    extends ASTVisitor {
        private Expression iAccessBeanExpression;
        private boolean iReferencesGetKey = false;

        public GetKeyReferenceVisitor(Expression accessBeanExpression) {
            this.iAccessBeanExpression = accessBeanExpression;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            if (methodInvocation.getExpression() != null && PortVisitor.GET_KEY.equals(methodInvocation.getName().getIdentifier()) && methodInvocation.getExpression().toString().equals(this.iAccessBeanExpression.toString())) {
                this.iReferencesGetKey = true;
            }
            return true;
        }

        public boolean getReferencesGetKey() {
            return this.iReferencesGetKey;
        }
    }
}

