/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.generators;

import com.ibm.commerce.jpa.port.info.PersistenceUnitInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;

public class PersistenceXmlGenerator {
    private PersistenceUnitInfo iPersistenceUnitInfo;

    public PersistenceXmlGenerator(PersistenceUnitInfo persistenceUnitInfo) {
        this.iPersistenceUnitInfo = persistenceUnitInfo;
    }

    public void generate(IProgressMonitor progressMonitor) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        sb.append("<persistence version=\"2.0\" xmlns=\"http://java.sun.com/xml/ns/persistence\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/persistence http://java.sun.com/xml/ns/persistence/persistence_2_0.xsd\">\r\n");
        sb.append("\t<persistence-unit name=\"WC\">\r\n");
        sb.append("\t\t<jta-data-source>jdbc/WebSphere Commerce Cloudscape DataSource demo</jta-data-source>\r\n");
        sb.append("\t\t<jar-file>../Enablement-BaseComponentsData.jar</jar-file>\r\n");
        List<IJavaProject> entityJarProjects = this.iPersistenceUnitInfo.getEntityJarProjects();
        for (IJavaProject entityJarProject : entityJarProjects) {
            if ("Enablement-BaseComponentsData".equals(entityJarProject.getElementName())) continue;
            sb.append("\t\t<jar-file>../");
            sb.append(entityJarProject.getElementName());
            sb.append(".jar</jar-file>\r\n");
        }
        sb.append("\t\t<properties>\r\n");
        sb.append("\t\t\t<property name=\"openjpa.jdbc.DBDictionary\" value=\"storeCharsAsNumbers=false\"/>\r\n");
        sb.append("\t\t\t<property name=\"openjpa.Multithreaded\" value=\"true\"/>\r\n");
        sb.append("\t\t</properties>\r\n");
        sb.append("\t</persistence-unit>\r\n");
        sb.append("</persistence>");
        IFolder metaInfFolder = this.iPersistenceUnitInfo.getPersistenceUnitRootProject().getProject().getFolder("src").getFolder("META-INF");
        IFile persistenceXmlFile = metaInfFolder.getFile("persistence.xml");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(sb.toString().getBytes());
        try {
            if (persistenceXmlFile.exists()) {
                persistenceXmlFile.setContents((InputStream)inputStream, true, false, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            } else {
                persistenceXmlFile.create((InputStream)inputStream, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

