/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.generators;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.generators.EntityAccessBeanClassGenerator;
import com.ibm.commerce.jpa.port.generators.EntityAccessHelperClassGenerator;
import com.ibm.commerce.jpa.port.generators.EntityClassGenerator;
import com.ibm.commerce.jpa.port.generators.EntityDataClassGenerator;
import com.ibm.commerce.jpa.port.generators.EntityEntityCreationDataClassGenerator;
import com.ibm.commerce.jpa.port.generators.EntityKeyClassGenerator;
import com.ibm.commerce.jpa.port.generators.EntityQueryHelperClassGenerator;
import com.ibm.commerce.jpa.port.generators.ModuleInfoXmlGenerator;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.util.BackupUtil;
import com.ibm.commerce.jpa.port.util.EjbProjectUtil;
import java.util.Collection;
import java.util.logging.Logger;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTParser;

public class ModuleGenerator {
    private static final Logger LOGGER = LoggerHelper.getLogger(ModuleGenerator.class);
    private ASTParser iASTParser = ASTParser.newParser((int)3);
    private IWorkspace iWorkspace;
    private IJavaProject iJavaProject;
    private ModuleInfo iModuleInfo;
    private BackupUtil iBackupUtil;

    public ModuleGenerator(IWorkspace workspace, ModuleInfo moduleInfo) {
        this.iWorkspace = workspace;
        this.iJavaProject = moduleInfo.getJavaProject();
        this.iModuleInfo = moduleInfo;
        this.iBackupUtil = moduleInfo.getApplicationInfo().getBackupUtil(this.iJavaProject.getProject());
    }

    public IStatus generate(IProgressMonitor progressMonitor) {
        LOGGER.info("generating entities for " + this.iModuleInfo.getJavaProject().getElementName());
        IStatus status = Status.OK_STATUS;
        try {
            Collection<EntityInfo> entities = this.iModuleInfo.getEntities();
            LOGGER.info(String.valueOf(this.getClass().getCanonicalName()) + "] Total entities to process on this job=" + entities.size());
            progressMonitor.beginTask("Generate " + this.iJavaProject.getProject().getName(), entities.size() * 1000 + 100);
            if (entities.size() > 0) {
                EjbProjectUtil projectUtil = new EjbProjectUtil(this.iWorkspace, this.iJavaProject);
                for (EntityInfo entityInfo : entities) {
                    if (progressMonitor.isCanceled()) {
                        status = Status.CANCEL_STATUS;
                        break;
                    }
                    if (entityInfo.getSubtypes() == null) continue;
                    this.generateEntity(progressMonitor, entityInfo);
                }
                for (EntityInfo entityInfo : entities) {
                    if (progressMonitor.isCanceled()) {
                        status = Status.CANCEL_STATUS;
                        break;
                    }
                    if (entityInfo.getSubtypes() != null) continue;
                    this.generateEntity(progressMonitor, entityInfo);
                }
                ModuleInfoXmlGenerator moduleInfoXMLGenerator = new ModuleInfoXmlGenerator(this.iModuleInfo);
                moduleInfoXMLGenerator.generate(progressMonitor);
            }
        }
        finally {
            progressMonitor.done();
        }
        return status;
    }

    private void generateEntity(IProgressMonitor progressMonitor, EntityInfo entityInfo) {
        LOGGER.info("entity=" + entityInfo.getEjbName());
        EntityClassGenerator entityClassGenerator = new EntityClassGenerator(this.iASTParser, this.iBackupUtil, entityInfo);
        entityClassGenerator.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
        EntityKeyClassGenerator entityKeyClassGenerator = new EntityKeyClassGenerator(this.iBackupUtil, entityInfo);
        entityKeyClassGenerator.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
        EntityQueryHelperClassGenerator entityQueryHelperClassGenerator = new EntityQueryHelperClassGenerator(this.iASTParser, this.iBackupUtil, entityInfo);
        entityQueryHelperClassGenerator.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
        if (entityInfo.getAccessBeanInfo() != null && entityInfo.getAccessBeanInfo().getDataClassType()) {
            EntityDataClassGenerator entityDataClassGenerator = new EntityDataClassGenerator(this.iASTParser, this.iBackupUtil, entityInfo);
            entityDataClassGenerator.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
        } else if (entityInfo.getAccessBeanInfo() != null) {
            EntityAccessBeanClassGenerator entityAccessBeanClassGenerator = new EntityAccessBeanClassGenerator(this.iBackupUtil, entityInfo);
            entityAccessBeanClassGenerator.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
        }
        if (entityInfo.getAccessBeanInfo() != null) {
            EntityAccessHelperClassGenerator entityAccessHelperClassGenerator = new EntityAccessHelperClassGenerator(this.iASTParser, this.iBackupUtil, entityInfo);
            entityAccessHelperClassGenerator.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
            EntityEntityCreationDataClassGenerator entityEntityCreationDataClassGenerator = new EntityEntityCreationDataClassGenerator(this.iBackupUtil, entityInfo);
            entityEntityCreationDataClassGenerator.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 200));
        }
    }
}

