/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.generators;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.ProjectInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class EntityReferenceSubclassesXmlGenerator {
    private static final Logger LOGGER = LoggerHelper.getLogger(EntityReferenceSubclassesXmlGenerator.class);
    private ProjectInfo iProjectInfo;
    private IProject iProject;

    public EntityReferenceSubclassesXmlGenerator(ProjectInfo projectInfo) {
        this.iProjectInfo = projectInfo;
        this.iProject = projectInfo.getProject();
    }

    public void generate(IProgressMonitor progressMonitor) {
        LOGGER.info("generate project info for " + this.iProject.getName());
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        sb.append("<ProjectInfo>\r\n");
        Set<String> entityReferenceSubclasses = this.iProjectInfo.getEntityReferenceSubclasses();
        for (String entityReferenceSubclass : entityReferenceSubclasses) {
            sb.append("\t<EntityReferenceSubclass>");
            sb.append(entityReferenceSubclass);
            sb.append("</EntityReferenceSubclass>\r\n");
        }
        sb.append("</ProjectInfo>");
        IFile projectInfoXmlFile = this.iProject.getFile(".jpaEntityReferenceSubclasses.xml");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(sb.toString().getBytes());
        try {
            if (projectInfoXmlFile.exists()) {
                projectInfoXmlFile.setContents((InputStream)inputStream, true, false, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            } else {
                projectInfoXmlFile.create((InputStream)inputStream, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            }
            this.iProjectInfo.getApplicationInfo().incrementGeneratedAssetCount();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

