/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.generators;

import com.ibm.commerce.jpa.port.info.ClassInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.FieldInfo;
import com.ibm.commerce.jpa.port.info.KeyClassConstructorInfo;
import com.ibm.commerce.jpa.port.info.RelatedEntityInfo;
import com.ibm.commerce.jpa.port.util.BackupUtil;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;

public class EntityKeyClassGenerator {
    private static Map<String, String> PRIMITIVE_TYPE_MAP = new HashMap<String, String>();
    private static final String INT_PRIMITIVE = "int";
    private static final String INTEGER_WRAPPER = "java.lang.Integer";
    private static final String LONG_PRIMITIVE = "long";
    private static final String LONG_WRAPPER = "java.lang.Long";
    private BackupUtil iBackupUtil;
    private EntityInfo iEntityInfo;
    private ClassInfo iEntityKeyClassInfo;

    static {
        PRIMITIVE_TYPE_MAP.put(INT_PRIMITIVE, INTEGER_WRAPPER);
        PRIMITIVE_TYPE_MAP.put(LONG_PRIMITIVE, LONG_WRAPPER);
    }

    public EntityKeyClassGenerator(BackupUtil backupUtil, EntityInfo entityInfo) {
        this.iBackupUtil = backupUtil;
        this.iEntityInfo = entityInfo;
        this.iEntityKeyClassInfo = entityInfo.getEntityKeyClassInfo();
    }

    public void generate(IProgressMonitor progressMonitor) {
        try {
            progressMonitor.beginTask("generate key class for " + this.iEntityInfo.getEjbName(), -1);
            if (!(this.iEntityKeyClassInfo == null || this.iEntityInfo.getSupertype() != null && this.iEntityInfo.getPrimaryKeyClass().equals(this.iEntityInfo.getSupertype().getPrimaryKeyClass()))) {
                try {
                    StringBuilder sb = new StringBuilder();
                    sb.append("package ");
                    sb.append(this.iEntityKeyClassInfo.getPackageFragment().getElementName());
                    sb.append(";\r\n");
                    JavaUtil.appendCopyrightComment(sb);
                    sb.append("\r\nimport java.io.Serializable;\r\n");
                    sb.append("\r\npublic class ");
                    sb.append(this.iEntityKeyClassInfo.getClassName());
                    sb.append(" implements Serializable {\r\n");
                    JavaUtil.appendCopyrightField(sb);
                    this.appendFieldDeclarations(sb);
                    this.appendConstructors(sb);
                    progressMonitor.worked(100);
                    this.appendGettersAndSetters(sb);
                    progressMonitor.worked(100);
                    this.appendEqualsMethod(sb);
                    progressMonitor.worked(100);
                    this.appendHashCodeMethod(sb);
                    progressMonitor.worked(100);
                    sb.append("}");
                    ICompilationUnit compilationUnit = this.iEntityKeyClassInfo.getPackageFragment().createCompilationUnit(String.valueOf(this.iEntityKeyClassInfo.getClassName()) + ".java", sb.toString(), true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                    this.iBackupUtil.addGeneratedFile((IFile)compilationUnit.getResource(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                    this.iEntityInfo.getModuleInfo().getApplicationInfo().incrementGeneratedAssetCount();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private void appendConstructors(StringBuilder sb) {
        sb.append("\r\n\tpublic ");
        sb.append(this.iEntityKeyClassInfo.getClassName());
        sb.append("(){\r\n\t}\r\n");
        List<KeyClassConstructorInfo> constructors = this.iEntityInfo.getKeyClassConstructors();
        for (KeyClassConstructorInfo constructorInfo : constructors) {
            RelatedEntityInfo relatedEntityInfo;
            List<FieldInfo> fields = constructorInfo.getFields();
            if (fields.size() <= 0) continue;
            sb.append("\r\n\tpublic ");
            sb.append(this.iEntityKeyClassInfo.getClassName());
            sb.append("(");
            HashSet<RelatedEntityInfo> processedRelatedEntities = new HashSet<RelatedEntityInfo>();
            boolean first = true;
            for (FieldInfo fieldInfo : fields) {
                relatedEntityInfo = fieldInfo.getRelatedEntityInfo();
                if (relatedEntityInfo == null) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(fieldInfo.getTypeName());
                    sb.append(" ");
                    sb.append(fieldInfo.getTargetFieldName());
                    continue;
                }
                if (processedRelatedEntities.contains(relatedEntityInfo)) continue;
                processedRelatedEntities.add(relatedEntityInfo);
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(relatedEntityInfo.getKeyFieldType());
                sb.append(" ");
                sb.append(relatedEntityInfo.getFieldName());
            }
            sb.append(") {");
            processedRelatedEntities.clear();
            for (FieldInfo fieldInfo : fields) {
                relatedEntityInfo = fieldInfo.getRelatedEntityInfo();
                if (relatedEntityInfo == null) {
                    sb.append("\r\n\t\tthis.");
                    sb.append(fieldInfo.getTargetFieldName());
                    sb.append(" = ");
                    sb.append(fieldInfo.getTargetFieldName());
                    sb.append(";");
                    continue;
                }
                if (processedRelatedEntities.contains(relatedEntityInfo)) continue;
                processedRelatedEntities.add(relatedEntityInfo);
                sb.append("\r\n\t\tthis.");
                sb.append(relatedEntityInfo.getFieldName());
                sb.append(" = ");
                sb.append(relatedEntityInfo.getFieldName());
                sb.append(";");
            }
            sb.append("\r\n\t}\r\n");
        }
    }

    private void appendFieldDeclarations(StringBuilder sb) {
        List<FieldInfo> keyFields = this.iEntityInfo.getKeyFields();
        for (FieldInfo keyField : keyFields) {
            if (keyField.getRelatedEntityInfo() != null) continue;
            sb.append("\r\n\tprivate ");
            sb.append(keyField.getTypeName());
            sb.append(" ");
            sb.append(keyField.getTargetFieldName());
            sb.append(";\r\n");
        }
        List<RelatedEntityInfo> keyRelatedEntities = this.iEntityInfo.getKeyRelatedEntities();
        for (RelatedEntityInfo relatedEntityInfo : keyRelatedEntities) {
            sb.append("\r\n\tprivate ");
            sb.append(relatedEntityInfo.getKeyFieldType());
            sb.append(" ");
            sb.append(relatedEntityInfo.getFieldName());
            sb.append(";\r\n");
        }
    }

    private void appendGettersAndSetters(StringBuilder sb) {
        List<FieldInfo> keyFields = this.iEntityInfo.getKeyFields();
        for (FieldInfo keyField : keyFields) {
            if (keyField.getRelatedEntityInfo() != null) continue;
            sb.append("\r\n\tpublic ");
            sb.append(keyField.getTypeName());
            sb.append(" ");
            sb.append(keyField.getTargetGetterName());
            sb.append("() {\r\n\t\treturn ");
            sb.append(keyField.getTargetFieldName());
            sb.append(";\r\n\t}\r\n");
            sb.append("\r\n\tpublic void ");
            sb.append(keyField.getTargetSetterName());
            sb.append("(");
            sb.append(keyField.getTypeName());
            sb.append(" ");
            sb.append(keyField.getTargetFieldName());
            sb.append(") {\r\n\t\tthis.");
            sb.append(keyField.getTargetFieldName());
            sb.append(" = ");
            sb.append(keyField.getTargetFieldName());
            sb.append(";\r\n\t}\r\n");
        }
        List<RelatedEntityInfo> keyRelatedEntities = this.iEntityInfo.getKeyRelatedEntities();
        for (RelatedEntityInfo relatedEntityInfo : keyRelatedEntities) {
            sb.append("\r\n\tpublic ");
            sb.append(relatedEntityInfo.getKeyFieldType());
            sb.append(" ");
            sb.append(relatedEntityInfo.getGetterName());
            sb.append("() {\r\n\t\treturn ");
            sb.append(relatedEntityInfo.getFieldName());
            sb.append(";\r\n\t}\r\n");
            sb.append("\r\n\tpublic void ");
            sb.append(relatedEntityInfo.getSetterName());
            sb.append("(");
            sb.append(relatedEntityInfo.getKeyFieldType());
            sb.append(" ");
            sb.append(relatedEntityInfo.getFieldName());
            sb.append(") {\r\n\t\tthis.");
            sb.append(relatedEntityInfo.getFieldName());
            sb.append(" = ");
            sb.append(relatedEntityInfo.getFieldName());
            sb.append(";\r\n\t}\r\n");
        }
    }

    private void appendEqualsMethod(StringBuilder sb) {
        sb.append("\r\n\tpublic boolean equals(Object o) {\r\n");
        sb.append("\t\tboolean result = this == o;\r\n");
        sb.append("\t\tif (!result && o instanceof ");
        sb.append(this.iEntityKeyClassInfo.getClassName());
        sb.append(") {\r\n");
        sb.append("\t\t\t");
        sb.append(this.iEntityKeyClassInfo.getClassName());
        sb.append(" otherKey = (");
        sb.append(this.iEntityKeyClassInfo.getClassName());
        sb.append(") o;\r\n");
        sb.append("\t\t\tresult = ");
        boolean firstField = true;
        List<FieldInfo> keyFields = this.iEntityInfo.getKeyFields();
        for (FieldInfo keyField : keyFields) {
            if (keyField.getRelatedEntityInfo() != null) continue;
            if (firstField) {
                firstField = false;
            } else {
                sb.append(" &&\r\n\t\t\t\t");
            }
            sb.append("(");
            sb.append(keyField.getTargetFieldName());
            sb.append(" == otherKey.");
            sb.append(keyField.getTargetFieldName());
            if (!PRIMITIVE_TYPE_MAP.containsKey(keyField.getTypeName())) {
                sb.append(" || ");
                sb.append(keyField.getTargetFieldName());
                sb.append(" != null && ");
                sb.append(keyField.getTargetFieldName());
                sb.append(".equals(otherKey.");
                sb.append(keyField.getTargetFieldName());
                sb.append(")");
            }
            sb.append(")");
        }
        List<RelatedEntityInfo> keyRelatedEntities = this.iEntityInfo.getKeyRelatedEntities();
        for (RelatedEntityInfo relatedEntityInfo : keyRelatedEntities) {
            if (firstField) {
                firstField = false;
            } else {
                sb.append(" &&\r\n\t\t\t\t");
            }
            sb.append("(");
            sb.append(relatedEntityInfo.getFieldName());
            sb.append(" == otherKey.");
            sb.append(relatedEntityInfo.getFieldName());
            if (!PRIMITIVE_TYPE_MAP.containsKey(relatedEntityInfo.getKeyFieldType())) {
                sb.append(" || ");
                sb.append(relatedEntityInfo.getFieldName());
                sb.append(" != null && ");
                sb.append(relatedEntityInfo.getFieldName());
                sb.append(".equals(otherKey.");
                sb.append(relatedEntityInfo.getFieldName());
                sb.append(")");
            }
            sb.append(")");
        }
        sb.append(";\r\n\t\t}\r\n");
        sb.append("\t\treturn result;\r\n\t}\r\n");
    }

    private void appendHashCodeMethod(StringBuilder sb) {
        sb.append("\r\n\tpublic int hashCode() {\r\n");
        boolean firstField = true;
        List<FieldInfo> keyFields = this.iEntityInfo.getKeyFields();
        for (FieldInfo keyField : keyFields) {
            if (keyField.getRelatedEntityInfo() != null) continue;
            if (firstField) {
                sb.append("\t\tint hashCode = (");
                firstField = false;
            } else {
                sb.append("\t\thashCode = hashCode * 31 + (");
            }
            if (PRIMITIVE_TYPE_MAP.containsKey(keyField.getTypeName())) {
                sb.append("new ");
                sb.append(PRIMITIVE_TYPE_MAP.get(keyField.getTypeName()));
                sb.append("(");
                sb.append(keyField.getTargetFieldName());
                sb.append(")");
            } else {
                sb.append(keyField.getTargetFieldName());
                sb.append(" == null ? 0 : ");
                sb.append(keyField.getTargetFieldName());
            }
            sb.append(".hashCode());\r\n");
        }
        List<RelatedEntityInfo> keyRelatedEntities = this.iEntityInfo.getKeyRelatedEntities();
        for (RelatedEntityInfo relatedEntityInfo : keyRelatedEntities) {
            if (firstField) {
                sb.append("\t\tint hashCode = (");
                firstField = false;
            } else {
                sb.append("\t\thashCode = hashCode * 31 + (");
            }
            if (PRIMITIVE_TYPE_MAP.containsKey(relatedEntityInfo.getKeyFieldType())) {
                sb.append("new ");
                sb.append(PRIMITIVE_TYPE_MAP.get(relatedEntityInfo.getKeyFieldType()));
                sb.append("(");
                sb.append(relatedEntityInfo.getFieldName());
                sb.append(")");
            } else {
                sb.append(relatedEntityInfo.getFieldName());
                sb.append(" == null ? 0 : ");
                sb.append(relatedEntityInfo.getFieldName());
            }
            sb.append(".hashCode());\r\n");
        }
        sb.append("\t\treturn hashCode;\r\n\t}\r\n");
    }
}

