/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port.generators;

import com.ibm.commerce.jpa.port.generators.PortVisitor;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.ClassInfo;
import com.ibm.commerce.jpa.port.info.EntityInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.util.BackupUtil;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import com.ibm.commerce.jpa.port.util.TargetExceptionUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class EntityEntityCreationDataClassGenerator {
    private static final String COPY_FIELDS = "copyFields";
    private ApplicationInfo iApplicationInfo;
    private BackupUtil iBackupUtil;
    private EntityInfo iEntityInfo;
    private ModuleInfo iModuleInfo;
    private IType iType;
    private ClassInfo iEntityEntityCreationDataClassInfo;
    private String iOldName;
    private String iNewName;

    public EntityEntityCreationDataClassGenerator(BackupUtil backupUtil, EntityInfo entityInfo) {
        this.iBackupUtil = backupUtil;
        this.iEntityInfo = entityInfo;
        this.iModuleInfo = entityInfo.getModuleInfo();
        this.iApplicationInfo = entityInfo.getModuleInfo().getApplicationInfo();
        this.iType = entityInfo.getEjbEntityCreationDataType();
        this.iEntityEntityCreationDataClassInfo = entityInfo.getEntityEntityCreationDataClassInfo();
    }

    public void generate(IProgressMonitor progressMonitor) {
        try {
            progressMonitor.beginTask("generate entity creation data class " + this.iEntityInfo.getEjbName(), -1);
            if (this.iType != null) {
                this.generateEntityEntityCreationDataType(progressMonitor);
                progressMonitor.worked(1000);
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    public void generateEntityEntityCreationDataType(IProgressMonitor progressMonitor) {
        try {
            this.iOldName = this.iType.getTypeQualifiedName();
            this.iNewName = this.iEntityEntityCreationDataClassInfo.getClassName();
            CompilationUnit astCompilationUnit = this.iEntityInfo.getEjbEntityCreationDataCompilationUnit();
            astCompilationUnit.recordModifications();
            astCompilationUnit.accept((ASTVisitor)new EntityCreationDataPortVisitor());
            IDocument document = JavaUtil.getDocument(this.iType);
            TextEdit edits = astCompilationUnit.rewrite(document, null);
            edits.apply(document);
            ICompilationUnit compilationUnit = this.iType.getPackageFragment().createCompilationUnit(String.valueOf(this.iEntityEntityCreationDataClassInfo.getClassName()) + ".java", document.get(), true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            this.iBackupUtil.addGeneratedFile((IFile)compilationUnit.getResource(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
            this.iApplicationInfo.incrementGeneratedAssetCount();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private class EntityCreationDataPortVisitor
    extends PortVisitor {
        public EntityCreationDataPortVisitor() {
            super(EntityEntityCreationDataClassGenerator.this.iApplicationInfo, EntityEntityCreationDataClassGenerator.this.iModuleInfo.getJavaProject());
        }

        @Override
        public boolean visit(SimpleName simpleName) {
            if (simpleName.getIdentifier().equals(EntityEntityCreationDataClassGenerator.this.iOldName)) {
                this.replaceASTNode((ASTNode)simpleName, (ASTNode)simpleName.getAST().newName(EntityEntityCreationDataClassGenerator.this.iNewName));
            } else {
                super.visit(simpleName);
            }
            return false;
        }

        @Override
        public boolean visit(MethodDeclaration methodDeclaration) {
            boolean visitChildren = false;
            if (methodDeclaration.getName().getIdentifier().equals(EntityEntityCreationDataClassGenerator.COPY_FIELDS)) {
                methodDeclaration.delete();
            } else {
                TargetExceptionUtil.getUnhandledTargetExceptions(EntityEntityCreationDataClassGenerator.this.iApplicationInfo, EntityEntityCreationDataClassGenerator.this.iModuleInfo.getJavaProject(), (ASTNode)methodDeclaration.getBody());
                visitChildren = super.visit(methodDeclaration);
            }
            return visitChildren;
        }

        public boolean visit(Initializer initializer) {
            TargetExceptionUtil.getUnhandledTargetExceptions(EntityEntityCreationDataClassGenerator.this.iApplicationInfo, EntityEntityCreationDataClassGenerator.this.iModuleInfo.getJavaProject(), (ASTNode)initializer.getBody());
            return super.visit(initializer);
        }
    }
}

