/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commerce.jpa.port;

import com.ibm.commerce.jpa.logger.LoggerHelper;
import com.ibm.commerce.jpa.port.info.AccessBeanSubclassInfo;
import com.ibm.commerce.jpa.port.info.ApplicationInfo;
import com.ibm.commerce.jpa.port.info.ModuleInfo;
import com.ibm.commerce.jpa.port.info.ProjectInfo;
import com.ibm.commerce.jpa.port.parsers.ModuleInfoXmlParser;
import com.ibm.commerce.jpa.port.parsers.ProjectInfoXmlParser;
import com.ibm.commerce.jpa.port.util.BackupUtil;
import com.ibm.commerce.jpa.port.util.JPASeederUtilBase;
import com.ibm.commerce.jpa.port.util.JavaUtil;
import com.ibm.commerce.jpa.updaters.ModuleUpdater;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;

public class ReplaceEjbsJob
extends Job {
    private static final Logger LOGGER = LoggerHelper.getLogger(ReplaceEjbsJob.class);
    private static final int PARALLEL_JOBS = 4;
    private static final Collection<String> EXTRA_DELETE_INTENDED_TYPES = new HashSet<String>();
    private IWorkspace iWorkspace;
    private ApplicationInfo iApplicationInfo = new ApplicationInfo();
    private IProgressMonitor iProgressGroup;
    private Map<String, String> iNameMap = new HashMap<String, String>();
    private Collection<IProject> iBuildPendingProjects = Collections.synchronizedCollection(new HashSet());

    static {
        EXTRA_DELETE_INTENDED_TYPES.add("com.ibm.commerce.negotiation.helpers._AuctionJDBCHelper_Stub");
        EXTRA_DELETE_INTENDED_TYPES.add("com.ibm.commerce.negotiation.helpers._EJSRemoteStatelessAuctionJDBCHelper_7ccf3f64_Tie");
        EXTRA_DELETE_INTENDED_TYPES.add("com.ibm.commerce.rfq.helpers._EJSRemoteStatelessRFQJdbcHelper_1fd90e60_Tie");
        EXTRA_DELETE_INTENDED_TYPES.add("com.ibm.commerce.rfq.helpers._RFQJdbcHelper_Stub");
        EXTRA_DELETE_INTENDED_TYPES.add("com.ibm.commerce.context.objects.util.EJBLocalHomeFactory");
        EXTRA_DELETE_INTENDED_TYPES.add("com.ibm.commerce.negotiation.util.SortingAttribute");
        EXTRA_DELETE_INTENDED_TYPES.add("com.ibm.commerce.utf.helper.SortingAttribute");
    }

    public ReplaceEjbsJob() {
        super("Entity Reference Port");
        this.iWorkspace = ResourcesPlugin.getWorkspace();
        this.iProgressGroup = Job.getJobManager().createProgressGroup();
        this.setProgressGroup(this.iProgressGroup, 82000);
    }

    public IStatus run(IProgressMonitor progressMonitor) {
        IStatus status = Status.OK_STATUS;
        try {
            try {
                this.iProgressGroup.beginTask("Replace EJBs", 82000);
                progressMonitor.beginTask("replace EJBs", 82000);
                this.initializeApplicationInfo();
                this.restoreProjects(progressMonitor);
                this.buildProjects(progressMonitor);
                this.parseModules(progressMonitor);
                this.parseProjects(progressMonitor);
                this.parseGeneratedFileLists(progressMonitor);
                this.deleteEjbFiles(progressMonitor);
                this.deleteEntityReferencingFiles(progressMonitor);
                this.renameGeneratedFiles(progressMonitor);
                this.updateModules(progressMonitor);
                this.iApplicationInfo.printSummary();
                this.iApplicationInfo = null;
                HashSet<IProject> buildPendingProjects = new HashSet<IProject>();
                buildPendingProjects.addAll(this.iBuildPendingProjects);
                this.buildProjects(progressMonitor);
                this.iBuildPendingProjects = buildPendingProjects;
                this.buildProjects(progressMonitor);
            }
            catch (InterruptedException e) {
                status = Status.CANCEL_STATUS;
                progressMonitor.done();
                this.iProgressGroup.done();
            }
        }
        finally {
            progressMonitor.done();
            this.iProgressGroup.done();
        }
        return status;
    }

    private void initializeApplicationInfo() {
        this.iApplicationInfo = new ApplicationInfo();
    }

    private void restoreProjects(IProgressMonitor progressMonitor) throws InterruptedException {
        IWorkspaceRoot root = this.iWorkspace.getRoot();
        IProject[] projects = root.getProjects();
        HashSet<IProject> projectSet = new HashSet<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            projectSet.add(project);
            ++n2;
        }
        HashSet<RestoreProjectJob> restoreProjectJobs = new HashSet<RestoreProjectJob>();
        int i = 0;
        while (i < 4) {
            RestoreProjectJob restoreProjectJob = new RestoreProjectJob(this.iApplicationInfo, this.iBuildPendingProjects, projectSet);
            restoreProjectJob.setProgressGroup(this.iProgressGroup, 250);
            restoreProjectJob.schedule();
            restoreProjectJobs.add(restoreProjectJob);
            ++i;
        }
        for (RestoreProjectJob restoreProjectJob : restoreProjectJobs) {
            restoreProjectJob.join();
            progressMonitor.worked(250);
        }
    }

    private void parseModules(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            IWorkspaceRoot root = this.iWorkspace.getRoot();
            IProject[] projects = root.getProjects();
            HashSet<ModuleInfo> modules = new HashSet<ModuleInfo>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                IFile moduleInfoXmlFile = project.getFile(".jpaModuleInfo.xml");
                if (moduleInfoXmlFile.exists()) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    ModuleInfo moduleInfo = new ModuleInfo(this.iApplicationInfo, javaProject);
                    this.iApplicationInfo.addModule(moduleInfo);
                    modules.add(moduleInfo);
                }
                ++n2;
            }
            HashSet<ParseModuleJob> parseModuleJobs = new HashSet<ParseModuleJob>();
            int i = 0;
            while (i < 4) {
                ParseModuleJob parseModuleJob = new ParseModuleJob(modules);
                parseModuleJob.setProgressGroup(this.iProgressGroup, 1250);
                parseModuleJob.schedule();
                parseModuleJobs.add(parseModuleJob);
                ++i;
            }
            for (ParseModuleJob parseModuleJob : parseModuleJobs) {
                parseModuleJob.join();
                progressMonitor.worked(1250);
            }
        }
    }

    private void parseProjects(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            IWorkspaceRoot root = this.iWorkspace.getRoot();
            IProject[] projects = root.getProjects();
            HashSet<ProjectInfo> projectInfos = new HashSet<ProjectInfo>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                IFile accessBeanSubclassInfoXmlFile = project.getFile(".jpaAccessBeanSubclassInfo.xml");
                IFile entityReferencesXmlFile = project.getFile(".jpaEntityReferences.xml");
                IFile entityReferenceSubclassesXmlFile = project.getFile(".jpaEntityReferenceSubclasses.xml");
                if (accessBeanSubclassInfoXmlFile.exists() || entityReferencesXmlFile.exists() || entityReferenceSubclassesXmlFile.exists()) {
                    ProjectInfo projectInfo = this.iApplicationInfo.getProjectInfo(project);
                    projectInfos.add(projectInfo);
                }
                ++n2;
            }
            HashSet<ParseProjectJob> parseProjectJobs = new HashSet<ParseProjectJob>();
            int i = 0;
            while (i < 4) {
                ParseProjectJob parseProjectJob = new ParseProjectJob(projectInfos);
                parseProjectJob.setProgressGroup(this.iProgressGroup, 1250);
                parseProjectJob.schedule();
                parseProjectJobs.add(parseProjectJob);
                ++i;
            }
            for (ParseProjectJob parseProjectJob : parseProjectJobs) {
                parseProjectJob.join();
                progressMonitor.worked(1250);
            }
        }
    }

    private void parseGeneratedFileLists(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            IWorkspaceRoot root = this.iWorkspace.getRoot();
            IProject[] projects = root.getProjects();
            HashSet<IFile> fileListFiles = new HashSet<IFile>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IFile generatedFileList2;
                IProject project = iProjectArray[n2];
                IFile generatedFileList = project.getFile(".jpaGeneratedFileList");
                if (generatedFileList.exists()) {
                    fileListFiles.add(generatedFileList);
                }
                if ((generatedFileList2 = project.getFile(".jpaGeneratedFileList2")).exists()) {
                    fileListFiles.add(generatedFileList2);
                }
                ++n2;
            }
            HashSet<ParseGeneratedFileListFileJob> jobs = new HashSet<ParseGeneratedFileListFileJob>();
            int i = 0;
            while (i < 4) {
                ParseGeneratedFileListFileJob job = new ParseGeneratedFileListFileJob(this.iApplicationInfo, fileListFiles, this.iNameMap);
                job.setProgressGroup(this.iProgressGroup, 1250);
                job.schedule();
                jobs.add(job);
                ++i;
            }
            for (ParseGeneratedFileListFileJob job : jobs) {
                job.join();
                progressMonitor.worked(1250);
            }
        }
    }

    private void deleteEjbFiles(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            HashSet<ModuleInfo> modules = new HashSet<ModuleInfo>();
            modules.addAll(this.iApplicationInfo.getModules());
            HashSet<DeleteEjbFilesJob> jobs = new HashSet<DeleteEjbFilesJob>();
            int i = 0;
            while (i < 4) {
                DeleteEjbFilesJob job = new DeleteEjbFilesJob(modules, this.iBuildPendingProjects);
                job.setProgressGroup(this.iProgressGroup, 2500);
                job.schedule();
                jobs.add(job);
                ++i;
            }
            for (DeleteEjbFilesJob job : jobs) {
                job.join();
                progressMonitor.worked(2500);
            }
        }
    }

    private void deleteEntityReferencingFiles(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            HashSet<ProjectInfo> projects = new HashSet<ProjectInfo>();
            projects.addAll(this.iApplicationInfo.getProjects());
            HashSet<DeleteEntityReferencingFilesJob> jobs = new HashSet<DeleteEntityReferencingFilesJob>();
            int i = 0;
            while (i < 4) {
                DeleteEntityReferencingFilesJob job = new DeleteEntityReferencingFilesJob(projects, this.iBuildPendingProjects);
                job.setProgressGroup(this.iProgressGroup, 2500);
                job.schedule();
                jobs.add(job);
                ++i;
            }
            for (DeleteEntityReferencingFilesJob job : jobs) {
                job.join();
                progressMonitor.worked(2500);
            }
        }
    }

    private void renameGeneratedFiles(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            IWorkspaceRoot root = this.iWorkspace.getRoot();
            IProject[] projects = root.getProjects();
            HashSet<IFile> fileListFiles = new HashSet<IFile>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IFile generatedFileList2;
                IProject project = iProjectArray[n2];
                IFile generatedFileList = project.getFile(".jpaGeneratedFileList");
                if (generatedFileList.exists()) {
                    fileListFiles.add(generatedFileList);
                }
                if ((generatedFileList2 = project.getFile(".jpaGeneratedFileList2")).exists()) {
                    fileListFiles.add(generatedFileList2);
                }
                ++n2;
            }
            HashSet<RenameGeneratedFilesJob> jobs = new HashSet<RenameGeneratedFilesJob>();
            int i = 0;
            while (i < 4) {
                RenameGeneratedFilesJob job = new RenameGeneratedFilesJob(fileListFiles, this.iNameMap, this.iApplicationInfo, this.iBuildPendingProjects);
                job.setProgressGroup(this.iProgressGroup, 5000);
                job.schedule();
                jobs.add(job);
                ++i;
            }
            for (RenameGeneratedFilesJob job : jobs) {
                job.join();
                progressMonitor.worked(5000);
            }
        }
    }

    private void updateModules(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            HashSet<ModuleInfo> modules = new HashSet<ModuleInfo>();
            modules.addAll(this.iApplicationInfo.getModules());
            HashSet<UpdateModuleJob> jobs = new HashSet<UpdateModuleJob>();
            int i = 0;
            while (i < 4) {
                UpdateModuleJob job = new UpdateModuleJob(this.iWorkspace, modules);
                job.setProgressGroup(this.iProgressGroup, 1250);
                job.schedule();
                jobs.add(job);
                ++i;
            }
            for (UpdateModuleJob job : jobs) {
                job.join();
                progressMonitor.worked(1250);
            }
        }
    }

    private void buildProjects(IProgressMonitor progressMonitor) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            HashSet<BuildProjectJob> buildProjectJobs = new HashSet<BuildProjectJob>();
            int i = 0;
            while (i < 4) {
                BuildProjectJob buidProjectJob = new BuildProjectJob(this.iBuildPendingProjects);
                buidProjectJob.setProgressGroup(this.iProgressGroup, 2500);
                buidProjectJob.schedule();
                buildProjectJobs.add(buidProjectJob);
                ++i;
            }
            for (BuildProjectJob buidProjectJob : buildProjectJobs) {
                buidProjectJob.join();
                progressMonitor.worked(2500);
            }
        }
    }

    private void seedNewClasses(IProgressMonitor progressMonitor, String sourceFolderName) throws InterruptedException {
        if (!progressMonitor.isCanceled()) {
            SeedNewClassesJob seedNewClassesJob = new SeedNewClassesJob(this.iApplicationInfo, this.iBuildPendingProjects, sourceFolderName);
            seedNewClassesJob.setProgressGroup(this.iProgressGroup, 100);
            seedNewClassesJob.schedule();
            seedNewClassesJob.join();
            progressMonitor.worked(100);
        }
    }

    private static class BuildProjectJob
    extends Job {
        private Collection<IProject> iBuildPendingProjects;

        public BuildProjectJob(Collection<IProject> buildPendingProjects) {
            super("Build projects");
            this.iBuildPendingProjects = buildPendingProjects;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Build projects", -1);
                Object project = this.getProject();
                while (project != null) {
                    if (!progressMonitor.isCanceled() && status != Status.CANCEL_STATUS) {
                        try {
                            LOGGER.info("building " + project.getName());
                            project.build(10, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            status = Status.CANCEL_STATUS;
                        }
                    } else {
                        status = Status.CANCEL_STATUS;
                    }
                    project = !progressMonitor.isCanceled() && status != Status.CANCEL_STATUS ? this.getProject() : null;
                }
            }
            finally {
                progressMonitor.done();
                this.iBuildPendingProjects = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IProject getProject() {
            IProject project = null;
            Collection<IProject> collection = this.iBuildPendingProjects;
            synchronized (collection) {
                Iterator<IProject> iterator = this.iBuildPendingProjects.iterator();
                if (iterator.hasNext()) {
                    IProject currentProject;
                    project = currentProject = iterator.next();
                }
                if (project != null) {
                    this.iBuildPendingProjects.remove(project);
                }
            }
            return project;
        }
    }

    private static class DeleteEjbFilesJob
    extends Job {
        private Set<ModuleInfo> iModules;
        private Collection<IProject> iBuildPendingProjects;

        public DeleteEjbFilesJob(Set<ModuleInfo> modules, Collection<IProject> buildPendingProjects) {
            super("delete EJB files");
            this.iModules = modules;
            this.iBuildPendingProjects = buildPendingProjects;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("delete EJB files", -1);
                ModuleInfo moduleInfo = this.getModuleInfo();
                while (moduleInfo != null) {
                    IJavaProject javaProject = moduleInfo.getJavaProject();
                    BackupUtil backupUtil = moduleInfo.getApplicationInfo().getBackupUtil(javaProject.getProject());
                    if (!progressMonitor.isCanceled()) {
                        HashSet<String> deleteIntendedTypes = new HashSet<String>();
                        deleteIntendedTypes.addAll(moduleInfo.getDeleteIntendedTypes());
                        deleteIntendedTypes.addAll(moduleInfo.getApplicationInfo().getEjbStubTypes());
                        for (String deleteIntendedType : deleteIntendedTypes) {
                            try {
                                IType type = javaProject.findType(deleteIntendedType, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                                if (type != null && type.getCompilationUnit().getResource().getProject().equals((Object)javaProject.getProject())) {
                                    IFile file = (IFile)type.getCompilationUnit().getResource();
                                    backupUtil.backupFile3(file, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                                    file.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                                    moduleInfo.getApplicationInfo().incrementDeleteCount();
                                    continue;
                                }
                                if (type != null || moduleInfo.getApplicationInfo().getEjbStubTypes().contains(deleteIntendedType)) continue;
                                LOGGER.info("unable to find deleteIntendedType: " + deleteIntendedType + " in " + javaProject.getProject().getName());
                            }
                            catch (JavaModelException e) {
                                e.printStackTrace();
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        }
                        this.iBuildPendingProjects.add(javaProject.getProject());
                    } else {
                        status = Status.CANCEL_STATUS;
                        moduleInfo = null;
                    }
                    if (!progressMonitor.isCanceled()) {
                        moduleInfo = this.getModuleInfo();
                        continue;
                    }
                    status = Status.CANCEL_STATUS;
                    moduleInfo = null;
                }
            }
            finally {
                progressMonitor.done();
                this.iModules = null;
                this.iBuildPendingProjects = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ModuleInfo getModuleInfo() {
            ModuleInfo moduleInfo = null;
            Set<ModuleInfo> set = this.iModules;
            synchronized (set) {
                Iterator<ModuleInfo> iterator = this.iModules.iterator();
                if (iterator.hasNext()) {
                    ModuleInfo currentModuleInfo;
                    moduleInfo = currentModuleInfo = iterator.next();
                }
                if (moduleInfo != null) {
                    this.iModules.remove(moduleInfo);
                }
            }
            return moduleInfo;
        }
    }

    private static class DeleteEntityReferencingFilesJob
    extends Job {
        private Set<ProjectInfo> iProjects;
        private Collection<IProject> iBuildPendingProjects;

        public DeleteEntityReferencingFilesJob(Set<ProjectInfo> projects, Collection<IProject> buildPendingProjects) {
            super("delete entity referencing files");
            this.iProjects = projects;
            this.iBuildPendingProjects = buildPendingProjects;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("delete entity referencing files", -1);
                ProjectInfo projectInfo = this.getProjectInfo();
                while (projectInfo != null) {
                    BackupUtil backupUtil = projectInfo.getApplicationInfo().getBackupUtil(projectInfo.getProject());
                    IJavaProject javaProject = projectInfo.getJavaProject();
                    if (!progressMonitor.isCanceled()) {
                        if (javaProject.getJavaModel() != null) {
                            HashSet<String> deleteIntendedTypes = new HashSet<String>();
                            deleteIntendedTypes.addAll(projectInfo.getEntityReferencingTypes());
                            deleteIntendedTypes.addAll(projectInfo.getDeleteIntendedTypes());
                            deleteIntendedTypes.addAll(projectInfo.getApplicationInfo().getEjbStubTypes());
                            deleteIntendedTypes.addAll(EXTRA_DELETE_INTENDED_TYPES);
                            Collection<AccessBeanSubclassInfo> accessBeanSubclasses = projectInfo.getAccessBeanSubclasses();
                            for (AccessBeanSubclassInfo accessBeanSubclassInfo : accessBeanSubclasses) {
                                deleteIntendedTypes.add(accessBeanSubclassInfo.getName());
                            }
                            for (String deleteIntendedType : deleteIntendedTypes) {
                                try {
                                    IType type = javaProject.findType(deleteIntendedType, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                                    if (type != null && type.getCompilationUnit() != null && type.getCompilationUnit().getResource().getProject().equals((Object)javaProject.getProject())) {
                                        IFile file = (IFile)type.getCompilationUnit().getResource();
                                        backupUtil.backupFile3(file, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                                        file.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                                        projectInfo.getApplicationInfo().incrementDeleteCount();
                                        continue;
                                    }
                                    if (type != null || projectInfo.getApplicationInfo().getEjbStubTypes().contains(deleteIntendedType) || EXTRA_DELETE_INTENDED_TYPES.contains(deleteIntendedType)) continue;
                                    LOGGER.info("unable to find type " + deleteIntendedType + " in " + javaProject.getProject());
                                }
                                catch (JavaModelException type) {
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                }
                            }
                            this.iBuildPendingProjects.add(javaProject.getProject());
                        }
                    } else {
                        status = Status.CANCEL_STATUS;
                        projectInfo = null;
                    }
                    if (!progressMonitor.isCanceled()) {
                        projectInfo = this.getProjectInfo();
                        continue;
                    }
                    status = Status.CANCEL_STATUS;
                    projectInfo = null;
                }
            }
            finally {
                progressMonitor.done();
                this.iProjects = null;
                this.iBuildPendingProjects = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ProjectInfo getProjectInfo() {
            ProjectInfo projectInfo = null;
            Set<ProjectInfo> set = this.iProjects;
            synchronized (set) {
                Iterator<ProjectInfo> iterator = this.iProjects.iterator();
                if (iterator.hasNext()) {
                    ProjectInfo currentProjectInfo;
                    projectInfo = currentProjectInfo = iterator.next();
                }
                if (projectInfo != null) {
                    this.iProjects.remove(projectInfo);
                }
            }
            return projectInfo;
        }
    }

    private static class ParseGeneratedFileListFileJob
    extends Job {
        private ApplicationInfo iApplicationInfo;
        private Set<IFile> iFiles;
        private Map<String, String> iNameMap;

        public ParseGeneratedFileListFileJob(ApplicationInfo applicationInfo, Set<IFile> files, Map<String, String> nameMap) {
            super("Parse Generated File List Files");
            this.iApplicationInfo = applicationInfo;
            this.iFiles = files;
            this.iNameMap = nameMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Parse generated file list files", -1);
                IFile file = this.getFile();
                while (file != null) {
                    block33: {
                        if (!progressMonitor.isCanceled()) {
                            try {
                                InputStream inputStream = file.getContents(true);
                                try {
                                    try {
                                        InputStreamReader reader = new InputStreamReader(inputStream);
                                        BufferedReader bufferedReader = new BufferedReader(reader);
                                        String portableString = bufferedReader.readLine();
                                        while (portableString != null && !progressMonitor.isCanceled()) {
                                            Map<String, String> map;
                                            String name = portableString.substring(portableString.lastIndexOf(47) + 1, portableString.lastIndexOf(46));
                                            if (name.contains("$JPA")) {
                                                map = this.iNameMap;
                                                synchronized (map) {
                                                    this.iNameMap.put(name, name.replace("$JPA", ""));
                                                }
                                            }
                                            if (name.endsWith("JPAEntity")) {
                                                map = this.iNameMap;
                                                synchronized (map) {
                                                    this.iNameMap.put(name, name.replace("JPAEntity", ""));
                                                }
                                            }
                                            if (name.contains("JPA")) {
                                                map = this.iNameMap;
                                                synchronized (map) {
                                                    this.iNameMap.put(name, name.replace("JPA", ""));
                                                }
                                            }
                                            portableString = bufferedReader.readLine();
                                        }
                                        this.iApplicationInfo.incrementParsedAssetCount();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        try {
                                            inputStream.close();
                                        }
                                        catch (IOException e2) {
                                            e2.printStackTrace();
                                        }
                                        break block33;
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    throw throwable;
                                }
                                try {
                                    inputStream.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        } else {
                            status = Status.CANCEL_STATUS;
                            file = null;
                        }
                    }
                    if (!progressMonitor.isCanceled()) {
                        file = this.getFile();
                        continue;
                    }
                    status = Status.CANCEL_STATUS;
                    file = null;
                }
            }
            finally {
                progressMonitor.done();
                this.iApplicationInfo = null;
                this.iFiles = null;
                this.iNameMap = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IFile getFile() {
            IFile file = null;
            Set<IFile> set = this.iFiles;
            synchronized (set) {
                Iterator<IFile> iterator = this.iFiles.iterator();
                if (iterator.hasNext()) {
                    IFile currentFile;
                    file = currentFile = iterator.next();
                }
                if (file != null) {
                    this.iFiles.remove(file);
                }
            }
            return file;
        }
    }

    private static class ParseModuleJob
    extends Job {
        private Set<ModuleInfo> iModules;

        public ParseModuleJob(Set<ModuleInfo> modules) {
            super("Parse modules");
            this.iModules = modules;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Parse modules", -1);
                ModuleInfo moduleInfo = this.getModule();
                while (moduleInfo != null) {
                    if (!progressMonitor.isCanceled()) {
                        ModuleInfoXmlParser moduleInfoXmlParser = new ModuleInfoXmlParser(moduleInfo);
                        moduleInfoXmlParser.parse((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                    } else {
                        status = Status.CANCEL_STATUS;
                    }
                    moduleInfo = this.getModule();
                }
            }
            finally {
                progressMonitor.done();
                this.iModules = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ModuleInfo getModule() {
            ModuleInfo module = null;
            Set<ModuleInfo> set = this.iModules;
            synchronized (set) {
                Iterator<ModuleInfo> iterator = this.iModules.iterator();
                if (iterator.hasNext()) {
                    ModuleInfo currentModule;
                    module = currentModule = iterator.next();
                }
                if (module != null) {
                    this.iModules.remove(module);
                }
            }
            return module;
        }
    }

    private static class ParseProjectJob
    extends Job {
        private Set<ProjectInfo> iProjects;

        public ParseProjectJob(Set<ProjectInfo> projects) {
            super("Parse projects");
            this.iProjects = projects;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Parse projects", -1);
                ProjectInfo projectInfo = this.getProjectInfo();
                while (projectInfo != null) {
                    if (!progressMonitor.isCanceled()) {
                        ProjectInfoXmlParser projectInfoXmlParser = new ProjectInfoXmlParser(projectInfo);
                        projectInfoXmlParser.parse((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                        projectInfo = this.getProjectInfo();
                        continue;
                    }
                    status = Status.CANCEL_STATUS;
                    projectInfo = null;
                }
            }
            finally {
                progressMonitor.done();
                this.iProjects = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ProjectInfo getProjectInfo() {
            ProjectInfo projectInfo = null;
            Set<ProjectInfo> set = this.iProjects;
            synchronized (set) {
                Iterator<ProjectInfo> iterator = this.iProjects.iterator();
                if (iterator.hasNext()) {
                    ProjectInfo currentProject;
                    projectInfo = currentProject = iterator.next();
                }
                if (projectInfo != null) {
                    this.iProjects.remove(projectInfo);
                }
            }
            return projectInfo;
        }
    }

    private static class RenameGeneratedFilesJob
    extends Job {
        private Set<IFile> iFiles;
        private Map<String, String> iNameMap;
        private ApplicationInfo iApplicationInfo;
        private Collection<IProject> iBuildPendingProjects;
        private ASTParser iASTParser = ASTParser.newParser((int)3);

        public RenameGeneratedFilesJob(Set<IFile> files, Map<String, String> nameMap, ApplicationInfo applicationInfo, Collection<IProject> buildPendingProjects) {
            super("Rename generated files job");
            this.iFiles = files;
            this.iNameMap = nameMap;
            this.iApplicationInfo = applicationInfo;
            this.iBuildPendingProjects = buildPendingProjects;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Rename generated files job", -1);
                IFile file = this.getFile();
                while (file != null) {
                    block26: {
                        if (!progressMonitor.isCanceled()) {
                            try {
                                InputStream inputStream = file.getContents(true);
                                try {
                                    try {
                                        InputStreamReader reader = new InputStreamReader(inputStream);
                                        BufferedReader bufferedReader = new BufferedReader(reader);
                                        String portableString = bufferedReader.readLine();
                                        while (portableString != null && !progressMonitor.isCanceled()) {
                                            IPath path = Path.fromPortableString((String)portableString);
                                            IFile generatedFile = file.getProject().getFile(path);
                                            if (generatedFile.exists()) {
                                                BackupUtil backupUtil = this.iApplicationInfo.getBackupUtil(generatedFile.getProject());
                                                String name = portableString.substring(portableString.lastIndexOf(47) + 1, portableString.lastIndexOf(46));
                                                if (name.contains("$JPA")) {
                                                    backupUtil.backupFile3(generatedFile, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                                                    generatedFile.delete(true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
                                                    this.iApplicationInfo.incrementDeleteCount();
                                                } else if (name.contains("JPA")) {
                                                    String targetName = name.replace("JPA", "");
                                                    if (name.endsWith("JPAEntity")) {
                                                        targetName = name.replace("JPAEntity", "");
                                                    }
                                                    ICompilationUnit compilationUnit = (ICompilationUnit)JavaCore.create((IFile)generatedFile);
                                                    this.iBuildPendingProjects.add(compilationUnit.getResource().getProject());
                                                    JavaUtil.renameJavaClass(backupUtil, this.iASTParser, compilationUnit, targetName, this.iNameMap, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                                                    this.iApplicationInfo.incrementGeneratedAssetCount();
                                                }
                                            }
                                            portableString = bufferedReader.readLine();
                                        }
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        try {
                                            inputStream.close();
                                        }
                                        catch (IOException e2) {
                                            e2.printStackTrace();
                                        }
                                        break block26;
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    throw throwable;
                                }
                                try {
                                    inputStream.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        } else {
                            status = Status.CANCEL_STATUS;
                            file = null;
                        }
                    }
                    if (!progressMonitor.isCanceled()) {
                        file = this.getFile();
                        continue;
                    }
                    status = Status.CANCEL_STATUS;
                    file = null;
                }
            }
            finally {
                progressMonitor.done();
                this.iFiles = null;
                this.iNameMap = null;
                this.iApplicationInfo = null;
                this.iBuildPendingProjects = null;
                this.iASTParser = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IFile getFile() {
            IFile file = null;
            Set<IFile> set = this.iFiles;
            synchronized (set) {
                Iterator<IFile> iterator = this.iFiles.iterator();
                if (iterator.hasNext()) {
                    IFile currentFile;
                    file = currentFile = iterator.next();
                }
                if (file != null) {
                    this.iFiles.remove(file);
                }
            }
            return file;
        }
    }

    private static class RestoreProjectJob
    extends Job {
        private ApplicationInfo iApplicationInfo;
        private Collection<IProject> iBuildPendingProjects;
        private Set<IProject> iProjects;

        public RestoreProjectJob(ApplicationInfo applicationInfo, Collection<IProject> buildPendingProjects, Set<IProject> projects) {
            super("Restore projects");
            this.iApplicationInfo = applicationInfo;
            this.iBuildPendingProjects = buildPendingProjects;
            this.iProjects = projects;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Restore projects", -1);
                IProject project = this.getProject();
                while (project != null) {
                    boolean restored = false;
                    if (!progressMonitor.isCanceled()) {
                        BackupUtil backupUtil = this.iApplicationInfo.getBackupUtil(project);
                        try {
                            restored = backupUtil.restore3((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                            if (restored) {
                                this.iBuildPendingProjects.add(project);
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            status = Status.CANCEL_STATUS;
                        }
                    } else {
                        status = Status.CANCEL_STATUS;
                    }
                    if (status != Status.CANCEL_STATUS && !progressMonitor.isCanceled()) {
                        project = this.getProject();
                        continue;
                    }
                    project = null;
                    status = Status.CANCEL_STATUS;
                }
            }
            finally {
                progressMonitor.done();
                this.iApplicationInfo = null;
                this.iProjects = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IProject getProject() {
            IProject project = null;
            Set<IProject> set = this.iProjects;
            synchronized (set) {
                Iterator<IProject> iterator = this.iProjects.iterator();
                if (iterator.hasNext()) {
                    IProject currentProject;
                    project = currentProject = iterator.next();
                }
                if (project != null) {
                    this.iProjects.remove(project);
                }
            }
            return project;
        }
    }

    private static class SeedNewClassesJob
    extends Job {
        private ApplicationInfo iApplicationInfo;
        private Collection<IProject> iBuildPendingProjects;
        private String iSourceFolderName;

        public SeedNewClassesJob(ApplicationInfo applicationInfo, Collection<IProject> buildPendingProjects, String sourceFolderName) {
            super("Seed new classes");
            this.iApplicationInfo = applicationInfo;
            this.iBuildPendingProjects = buildPendingProjects;
            this.iSourceFolderName = sourceFolderName;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            LOGGER.info("Seed new classes");
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Seed new classes", -1);
                if (!progressMonitor.isCanceled()) {
                    JPASeederUtilBase seederUtil = new JPASeederUtilBase(this.iApplicationInfo, this.iBuildPendingProjects, this.iSourceFolderName, false);
                    seederUtil.seedNewClasses(progressMonitor);
                } else {
                    status = Status.CANCEL_STATUS;
                }
            }
            finally {
                progressMonitor.done();
                this.iApplicationInfo = null;
                this.iBuildPendingProjects = null;
            }
            return status;
        }
    }

    private static class UpdateModuleJob
    extends Job {
        private IWorkspace iWorkspace;
        private Set<ModuleInfo> iModules;

        public UpdateModuleJob(IWorkspace workspace, Set<ModuleInfo> modules) {
            super("Update modules");
            this.iWorkspace = workspace;
            this.iModules = modules;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            IStatus status = Status.OK_STATUS;
            try {
                progressMonitor.beginTask("Update modules", -1);
                ModuleInfo moduleInfo = this.getModule();
                while (moduleInfo != null) {
                    if (!progressMonitor.isCanceled()) {
                        ModuleUpdater moduleUpdater = new ModuleUpdater(this.iWorkspace, moduleInfo);
                        moduleUpdater.update((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1000));
                    } else {
                        status = Status.CANCEL_STATUS;
                    }
                    moduleInfo = this.getModule();
                }
            }
            finally {
                progressMonitor.done();
                this.iWorkspace = null;
                this.iModules = null;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ModuleInfo getModule() {
            ModuleInfo module = null;
            Set<ModuleInfo> set = this.iModules;
            synchronized (set) {
                Iterator<ModuleInfo> iterator = this.iModules.iterator();
                if (iterator.hasNext()) {
                    ModuleInfo currentModule;
                    module = currentModule = iterator.next();
                }
                if (module != null) {
                    this.iModules.remove(module);
                }
            }
            return module;
        }
    }
}

