package com.mycompany.commerce.rest.catalog.handler;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2011
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */

import java.util.logging.Logger;

import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.rest.search.handler.ProductViewHandler;

@Path("store/{storeId}/productview")// make sure you have the same path as the super class
@Encoded
public class ProductViewHandlerExt extends ProductViewHandler {
	private static final String CLASSNAME = ProductViewHandlerExt.class.getName();
	private static final Logger LOGGER = LoggingHelper.getLogger(ProductViewHandlerExt.class);

	public static final String FORMATTING_GROUP = "ShowCatalogNavigationView";

	@Override
	public String getFormattingGroupName() {// optionally you can overwrite this method if you want to change the OOB formatting group name provided in the OOB Resource handler...  
		return FORMATTING_GROUP;
	}
	
	@GET
	@Path("{partNumber}")// make sure you have the same path as the super class
	@Produces( { "application/json", "application/xml", "application/custom+xml" })// Add your custom response format here...
	@Override
	public Response findProductByPartNumber(@PathParam("storeId") String storeId,// make sure that you set the same annotations matching the super class method.
			@PathParam("partNumber") String partNumber,
			@QueryParam(value = "responseFormat") String responseFormat)
			{
		// write your custom logic here....
		return super.findProductByPartNumber(storeId, partNumber, responseFormat);// delegate the call to the super class method...
	}
}
