package com.mycompany.commerce.foundation.rest.providers;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2011
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;

import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.rest.providers.AbstractEntityProvider;

@Provider
@Produces(value = { "application/custom+xml" })
public class CustomXMLEntityProvider extends AbstractEntityProvider {

	private static final String CLASSNAME = CustomXMLEntityProvider.class.getName();
	private static final java.util.logging.Logger LOGGER = LoggingHelper.getLogger(CustomXMLEntityProvider.class);
	
	private static final String ACTION_FORMAT_CUSTOM = "/{0}Custom/{1}";

	/**
	 * @see AbstractEntityProvider#getActionFormat()
	 */
	@Override
	protected String getActionFormat() {// You need to overwrite this method so that you return the struts action format for your custom format.... 
		return ACTION_FORMAT_CUSTOM;
	}

	/**
	 * This method uses the helper method {@link AbstractEntityProvider#formatResponseUsingJsp(Map)} to format
	 * the response using a JSP. It gets the byte array returned by <code>formatResponseUsingJsp</code> and writes it to
	 * response output stream.
	 * @see MessageBodyWriter#writeTo(Object, Class, Type, Annotation[], javax.ws.rs.core.MediaType, MultivaluedMap, OutputStream)
	 */
	@Override
	public void writeTo(Map dataMap, Class<?> dataObjectClass, Type dataObjectType,
			Annotation[] resourceAnnotations, javax.ws.rs.core.MediaType responseMediaType,
			MultivaluedMap<String, Object> responseHttpHeaders, OutputStream responseOutputStream)
			throws IOException, WebApplicationException {
		final String METHODNAME = "writeTo(Map, Class<?>, Type, Annotation{}, MediaType, MultivaluedMap<String, Object>, OutputStream)";

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME);
		}

		try {
			// refer to the documentation of AbstractEntityProvider.formatResponseUsingJsp().
			//When you use this method a JSP will be invoked passing the data object. 
			byte[] response = formatResponseUsingJsp(dataMap); 

			// If you have a marshaller/unmarshaller for your custom format you can use it such that the respone gets validated before sending it out. 
			//For example, for Atom feed you call the marshaller/unmarshaller as shown in the code commented out below: 
			//AtomFeed feed = AtomFeed.unmarshal(new InputStreamReader(new ByteArrayInputStream(response), RestProviderConstants.UTF8_ENCODING));
			//AtomFeed.marshal(feed, responseOutputStream);
			responseOutputStream.write(response); // finally write the response to the out put stream..
		}
		catch (Exception e) {
			throw new WebApplicationException(e);
		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}
}
