/*
 *==================================================
 * Licensed Materials - Property of HCL Technologies
 *
 * HCL Commerce
 *
 * (C) Copyright HCL Technologies Limited 2021
 *
 *==================================================
 */
//Standard libraries
import { call, put } from "redux-saga/effects";
//Foundation libraries
import wishListService from "../../../_foundation/apis/transaction/wishList.service";
//Redux
import * as ACTIONS from "../../action-types/wishList";

/**
 * Saga worker to invoke get wish list details
 */
export function* fetchWishListDetails(action: any) {
  try {
    const payload = action.payload;

    const response = yield call(wishListService.findWishlist, payload);
    const wishListData = response.data;

    yield put({
      type: ACTIONS.WISHLIST_GET_SUCCESS,
      response: wishListData,
    });
  } catch (error) {
    yield put({ type: ACTIONS.WISHLIST_GET_ERROR, error });
  }
}
