/*
 *==================================================
 * Licensed Materials - Property of HCL Technologies
 *
 * HCL Commerce
 *
 * (C) Copyright HCL Technologies Limited 2021
 *
 *==================================================
 */
//Standard libraries
import React, { Fragment, useState, useEffect } from "react";
//UI
import {
  StyledTypography,
  StyledCard,
  StyledCardMedia,
  StyledGrid,
  StyledCircularProgress,
} from "@hcl-commerce-store-sdk/react-component";

interface DisplayWishListWidgetProps {
  translation: any;
  wishList: any;
  deleteWishList: Function;
  productsData: any[];
}

const DisplayWishListWidget: React.FC<DisplayWishListWidgetProps> = (
  props: any
) => {
  const { translation, wishList, deleteWishList, productsData } = props;
  const [loading, setLoading] = useState<boolean>(true);
  const recentProducts = productsData.slice(0, 2);

  useEffect(() => {
    if (productsData && productsData.length > 0) {
      setLoading(false);
    }
    if (!wishList.item) {
      setLoading(false);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [productsData]);

  const cardActions = [
    {
      text: translation.ViewList,
      link: "#",
    },
    {
      text: translation.Delete,
      handleClick: () =>
        deleteWishList(wishList.uniqueID, wishList.description),
    },
  ];
  const contentComponent = (
    <>
      <StyledTypography variant="body1" className="shipment-group-heading">
        {wishList.description}
      </StyledTypography>
      {wishList.item && (
        <StyledTypography variant="body1">
          {translation.WishListItemsMessage}
        </StyledTypography>
      )}
      <StyledGrid container spacing={1} justify="flex-start">
        {recentProducts.map((product) => (
          <Fragment key={product.partNumber}>
            <StyledGrid item>
              <StyledCardMedia image={product.thumbnail} />
            </StyledGrid>
          </Fragment>
        ))}
      </StyledGrid>
      {!wishList.item && (
        <StyledTypography
          variant="body1"
          className="top-margin-1 bottom-margin-10">
          {translation.WishListEmptyMessage}
        </StyledTypography>
      )}
    </>
  );
  return loading ? (
    <StyledCircularProgress />
  ) : (
    <StyledCard
      className="product-card"
      contentComponent={contentComponent}
      cardActions={cardActions}
      confirmLabel={translation.Confirm}
      cancelLabel={translation.Cancel}
    />
  );
};

export default DisplayWishListWidget;
