/*
 *==================================================
 * Licensed Materials - Property of HCL Technologies
 *
 * HCL Commerce
 *
 * (C) Copyright HCL Technologies Limited 2021
 *
 *==================================================
 */
//Standard libraries
import React from "react";
//UI
import {
  StyledGrid,
  StyledTextField,
  StyledBox,
  StyledPaper,
  StyledIconLabel,
  StyledButton,
} from "@hcl-commerce-store-sdk/react-component";
import Add from "@material-ui/icons/Add";

interface CreateWishListWidgetProps {
  translation: any;
  wishListName: string;
  handleWishListName: Function;
  validateWishListName: Function;
  canCreateWishList: Function;
  createWishList: Function;
  EMPTY_STRING: string;
}

const CreateWishListWidget: React.FC<CreateWishListWidgetProps> = (
  props: any
) => {
  const {
    translation,
    wishListName,
    handleWishListName,
    validateWishListName,
    canCreateWishList,
    createWishList,
    EMPTY_STRING,
  } = props;
  const addWishList = () => {
    createWishList();
  };
  return (
    <StyledPaper className="horizontal-padding-3 vertical-padding-3">
      <StyledGrid
        container
        direction="column"
        justify="flex-start"
        alignItems="flex-start"
        spacing={3}>
        <StyledGrid item>
          <StyledBox flexDirection="row" alignItems="flex-start">
            <StyledIconLabel
              icon={<Add color="primary" className="full-center" />}
              label={translation.WishListMessage}
            />
          </StyledBox>
        </StyledGrid>
        <StyledGrid item>
          <StyledGrid container spacing={2}>
            <StyledGrid item>
              <StyledTextField
                required
                id="create-wish-list-name"
                name="wishListName"
                label={translation.WishListName}
                value={wishListName}
                inputProps={{ maxLength: 128 }}
                autoComplete="wishListName"
                onChange={(event) => handleWishListName(event)}
                error={validateWishListName()}
                helperText={
                  validateWishListName()
                    ? translation.InvalidWishListName
                    : EMPTY_STRING
                }
              />
            </StyledGrid>
            <StyledGrid item>
              <StyledButton
                size="small"
                color="primary"
                disabled={canCreateWishList()}
                onClick={addWishList}
                className="vertical-margin-3">
                {translation.AddWishList}
              </StyledButton>
            </StyledGrid>
          </StyledGrid>
        </StyledGrid>
      </StyledGrid>
    </StyledPaper>
  );
};

export default CreateWishListWidget;
