/*
 *==================================================
 * Licensed Materials - Property of HCL Technologies
 *
 * HCL Commerce
 *
 * (C) Copyright HCL Technologies Limited 2021
 *
 *==================================================
 */
//Standard libraries
import React, { useEffect } from "react";
import { useSelector, useDispatch } from "react-redux";
import Axios, { Canceler } from "axios";
import { useTranslation } from "react-i18next";
import { Redirect } from "react-router-dom";
import getDisplayName from "react-display-name";
//Foundation libraries
import { SIGNIN } from "../../../constants/routes";
//Redux
import { loginStatusSelector } from "../../../redux/selectors/user";
import { GetWishListSelector } from "../../../redux/selectors/wishList";
import * as wishListActions from "../../../redux/actions/wishList";
//UI
import {
  StyledGrid,
  StyledTypography,
  StyledContainer,
} from "@hcl-commerce-store-sdk/react-component";
//Custom libraries
import AccountSidebar from "../../widgets/account-sidebar/AccountSidebar";
import { TitleLayout } from "../../widgets/title/TitleLayout";
import DisplayWishListView from "./display-wishlist-view";
import CreateWishListView from "./create-wishlist-view";

const WishListView: React.FC = (props: any) => {
  const loginStatus = useSelector(loginStatusSelector);
  const userWishList = useSelector(GetWishListSelector);
  const widgetName = getDisplayName(WishListView);
  const CancelToken = Axios.CancelToken;
  let cancels: Canceler[] = [];
  const { t } = useTranslation();
  const dispatch = useDispatch();
  const payloadBase: any = {
    widget: widgetName,
    cancelToken: new CancelToken(function executor(c) {
      cancels.push(c);
    }),
  };

  useEffect(() => {
    if (!userWishList) {
      let payload = {
        ...payloadBase,
      };
      dispatch(wishListActions.GET_USER_WISHLIST_ACTION(payload));
    }
    return () => {
      cancels.forEach((cancel) => cancel());
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  if (!loginStatus) {
    return <Redirect to={SIGNIN} />;
  } else {
    return (
      <StyledContainer cid="wish-list-view">
        <TitleLayout title={t("WishList.Title")} cid="wish-list-view-title" />
        <StyledGrid container spacing={3}>
          <StyledGrid item xs={12} md={3} className="sidebar">
            <AccountSidebar />
          </StyledGrid>
          <StyledGrid item xs={12} md={9}>
            <StyledGrid container spacing={4}>
              <StyledGrid item xs={12}>
                <CreateWishListView />
              </StyledGrid>
              {userWishList && userWishList.length > 0 && (
                <StyledGrid item xs={12}>
                  <StyledGrid
                    container
                    spacing={2}
                    alignItems="stretch"
                    direction="row">
                    {userWishList.map((wishList: any) => (
                      <StyledGrid item xs={12} sm={6} key={wishList.uniqueID}>
                        <DisplayWishListView
                          userWishList={userWishList}
                          wishList={wishList}
                        />
                      </StyledGrid>
                    ))}
                  </StyledGrid>
                </StyledGrid>
              )}
              {!userWishList && (
                <StyledGrid item>
                  <StyledTypography variant="body2">
                    {t("WishList.NoWishListMessage")}
                  </StyledTypography>
                </StyledGrid>
              )}
            </StyledGrid>
          </StyledGrid>
        </StyledGrid>
      </StyledContainer>
    );
  }
};

export default WishListView;
