/*
 *==================================================
 * Licensed Materials - Property of HCL Technologies
 *
 * HCL Commerce
 *
 * (C) Copyright HCL Technologies Limited 2021
 *
 *==================================================
 */

//Standard libraries
import React, { useState, useEffect } from "react";
import { useDispatch } from "react-redux";
import Axios, { Canceler } from "axios";
import { useTranslation } from "react-i18next";
import getDisplayName from "react-display-name";
//Foundation libraries
import wishListService from "../../../_foundation/apis/transaction/wishList.service";
import productsService from "../../../_foundation/apis/search/products.service";
//Redux
import * as successActions from "../../../redux/actions/success";
import * as wishListActions from "../../../redux/actions/wishList";
//Custom libraries
import { DisplayWishListWidget } from "../../widgets/wish-list";

interface DisplayWishListViewProps {
  userWishList: any[];
  wishList: any;
}

const DisplayWishListView: React.FC<DisplayWishListViewProps> = (
  props: any
) => {
  const { userWishList, wishList } = props;
  const CancelToken = Axios.CancelToken;
  let cancels: Canceler[] = [];
  const widgetName = getDisplayName(DisplayWishListView);
  const { t } = useTranslation();
  const dispatch = useDispatch();
  const [productsData, setProductsData] = useState<any[]>(() => []);

  const payloadBase: any = {
    widget: widgetName,
    cancelToken: new CancelToken(function executor(c) {
      cancels.push(c);
    }),
  };

  const DisplayWishListTranslation: any = {
    ViewList: t("WishList.ViewList"),
    Delete: t("WishList.Delete"),
    Confirm: t("WishList.Confirm"),
    Cancel: t("WishList.Cancel"),
    WishListEmptyMessage: t("WishList.WishListEmptyMessage"),
    WishListItemsMessage: t("WishList.WishListItemsMessage"),
  };

  const deleteWishList = (wishListId: string, wishListName: string) => {
    const parameters: any = {
      externalId: wishListId,
      ...payloadBase,
    };
    wishListService
      .deleteWishlist(parameters)
      .then((res) => {
        if (res.data?.uniqueID) {
          if (userWishList.length === 1) {
            dispatch(wishListActions.WISHLIST_RESET_ACTION());
          } else {
            dispatch(
              wishListActions.GET_USER_WISHLIST_ACTION({ ...payloadBase })
            );
          }
          const successMessage = {
            key: "success-message.DELETE_WISHLIST_SUCCESS",
            messageParameters: {
              "0": wishListName,
            },
          };
          dispatch(
            successActions.HANDLE_SUCCESS_MESSAGE_ACTION(successMessage)
          );
        }
      })
      .catch((e) => {
        console.log("Could not delete wish list", e);
      });
  };
  useEffect(() => {
    let productIds: string[] = [];
    if (wishList.item) {
      for (let product of wishList.item) {
        if (product.productId) productIds.push(product.productId);
      }
    }
    if (productIds.length > 0) {
      const requestParameters = {
        id: productIds,
        ...payloadBase,
      };
      productsService
        .findProductsUsingGET(requestParameters)
        .then((res) => {
          const products = res?.data.contents;
          if (products) {
            setProductsData(products);
          }
        })
        .catch((e) =>
          console.log("Could not retrieve wish list products details", e)
        );
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [userWishList]);

  useEffect(() => {
    return () => {
      cancels.forEach((cancel) => cancel());
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  return (
    <DisplayWishListWidget
      translation={DisplayWishListTranslation}
      wishList={wishList}
      deleteWishList={deleteWishList}
      productsData={productsData}
    />
  );
};

export default DisplayWishListView;
