/*
 *==================================================
 * Licensed Materials - Property of HCL Technologies
 *
 * HCL Commerce
 *
 * (C) Copyright HCL Technologies Limited 2021
 *
 *==================================================
 */
//Standard libraries
import React, { useState, useEffect } from "react";
import { useDispatch } from "react-redux";
import { useHistory } from "react-router";
import Axios, { Canceler } from "axios";
import { useTranslation } from "react-i18next";
import getDisplayName from "react-display-name";
//Foundation libraries
import wishListService from "../../../_foundation/apis/transaction/wishList.service";
//Redux
import * as successActions from "../../../redux/actions/success";
import * as wishListActions from "../../../redux/actions/wishList";
//Custom libraries
import { EMPTY_STRING, REG_EX } from "../../../constants/common";
import { CreateWishListWidget } from "../../widgets/wish-list";
import { WISH_LIST as WISH_LIST_ROUTE } from "../../../constants/routes";

const CreateWishListView: React.FC = (props: any) => {
  const [wishListName, setWishListName] = useState<string>(() => {
    return EMPTY_STRING;
  });
  const widgetName = getDisplayName(CreateWishListView);
  const CancelToken = Axios.CancelToken;
  let cancels: Canceler[] = [];
  const { t } = useTranslation();
  const dispatch = useDispatch();
  const history = useHistory();
  const payloadBase: any = {
    widget: widgetName,
    cancelToken: new CancelToken(function executor(c) {
      cancels.push(c);
    }),
  };
  const handleWishListName = (event) => {
    setWishListName(event.target.value);
  };

  const createWishListTranslation: any = {
    WishListMessage: t("WishList.WishListMessage"),
    WishListName: t("WishList.WishListName"),
    InvalidWishListName: t("WishList.InvalidWishListName"),
    AddWishList: t("WishList.AddWishList"),
  };

  const validateWishListName = () => {
    const WISHLISTNAME_ALPHA_NUMERIC_SPECIAL_CHAR =
      REG_EX.NICKNAME_ALPHA_NUMERIC_SPECIAL_CHAR;
    if (wishListName.length > 0 && wishListName.trim() === EMPTY_STRING)
      return true;
    if (!WISHLISTNAME_ALPHA_NUMERIC_SPECIAL_CHAR.test(wishListName)) {
      return true;
    }
    return false;
  };

  const canCreateWishList = () => {
    if (
      wishListName.trim() === EMPTY_STRING ||
      wishListName.length === 0 ||
      validateWishListName()
    ) {
      return true;
    }
    return false;
  };
  const createWishList = () => {
    const params = {
      body: {
        description: wishListName.trim(),
        registry: false,
      },
      ...payloadBase,
    };
    wishListService
      .createWishlist(params)
      .then((res) => {
        if (res.data?.uniqueID) {
          dispatch(
            wishListActions.GET_USER_WISHLIST_ACTION({ ...payloadBase })
          );
          const successMessage = {
            key: "success-message.CREATE_WISHLIST_SUCCESS",
            messageParameters: {
              "0": wishListName.trim(),
            },
          };
          dispatch(
            successActions.HANDLE_SUCCESS_MESSAGE_ACTION(successMessage)
          );
          setWishListName(EMPTY_STRING);
        }
      })
      .catch((e) => {
        console.log("Could not create new wish list", e);
      });

    history.push(WISH_LIST_ROUTE);
  };

  useEffect(() => {
    return () => {
      cancels.forEach((cancel) => cancel());
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  return (
    <CreateWishListWidget
      translation={createWishListTranslation}
      wishListName={wishListName}
      handleWishListName={handleWishListName}
      validateWishListName={validateWishListName}
      createWishList={createWishList}
      EMPTY_STRING={EMPTY_STRING}
      canCreateWishList={canCreateWishList}
    />
  );
};

export default CreateWishListView;
