package com.mycompany.commerce.sample.commands;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;

import com.ibm.commerce.command.ControllerCommandImpl;
import com.ibm.commerce.datatype.TypedProperty;
import com.ibm.commerce.exception.ECException;
import com.ibm.commerce.foundation.persistence.EntityDao;
import com.ibm.commerce.member.facade.datatypes.PersonType;
import com.ibm.commerce.member.facade.datatypes.ShowPersonDataAreaType;
import com.mycompany.commerce.sample.objects.SocialAccount;
import com.mycompany.commerce.sample.persistence.SocialAccountDaoImpl;

public class GetSocialAccountCmdImpl extends ControllerCommandImpl implements GetSocialAccountCmd {

	public void performExecute() throws ECException {

		System.out.println("GetSocialAccountCmdImpl start...");
		if (responseProperties == null) {
			responseProperties = new TypedProperty();
		}
		
		HttpServletRequest requeset = (HttpServletRequest) requestProperties.get("request");
		Response originResponse = (Response) requeset.getAttribute("originResponse");
		
		Map map1=(Map)originResponse.getEntity();
		List dataList=(List)map1.get("dataList");
		Map map2=(Map)dataList.get(0);
		ShowPersonDataAreaType person=(ShowPersonDataAreaType)map2.get("dataObject");
		System.out.println("person:"+person);
		PersonType personSDO=(PersonType)person.getPerson().get(0);
		Long memberId=Long.valueOf(personSDO.getPersonIdentifier().getUniqueID());
		
		EntityDao<SocialAccount, Long> socialAccountDao = new SocialAccountDaoImpl();
		List<SocialAccount> socialAccountList = socialAccountDao.query("SocialAccount.getSocialAccountsByMemberId", memberId);
		System.out.println("find socialAccount:" + socialAccountList);
		
		if(socialAccountList!=null && socialAccountList.size()>0){
			SocialAccount socialAccount=(SocialAccount)socialAccountList.get(0);
			if(socialAccount!=null){
				responseProperties.put("ext_facebookId", socialAccount.getFacebookId());
				responseProperties.put("ext_facebookName", socialAccount.getName());
			}
		}

		System.out.println("GetSocialAccountCmdImpl: responseProperties:" + responseProperties);
	}
}
