package com.mycompany.commerce.sample.commands;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;

import com.ibm.commerce.command.ControllerCommandImpl;
import com.ibm.commerce.exception.ECException;
import com.ibm.commerce.foundation.persistence.EntityDao;
import com.mycompany.commerce.sample.commands.CreateSocialAccountCmd;
import com.mycompany.commerce.sample.objects.SocialAccount;
import com.mycompany.commerce.sample.persistence.SocialAccountDaoImpl;

public class CreateSocialAccountCmdImpl extends ControllerCommandImpl implements CreateSocialAccountCmd {

	public void performExecute() throws ECException {
		System.out.println("CreateSocialAccountCmdImpl start...");
		
		HttpServletRequest requeset = (HttpServletRequest) requestProperties.get("request");
		Map<String, Object> bodyMap = (Map) requeset.getAttribute("resolvedBodyParams");
		Response originResponse = (Response) requeset.getAttribute("originResponse");
		
		String facebookId = (String) bodyMap.get("ext_facebookId");
		String facebookName = (String) bodyMap.get("ext_facebookName");

		Map map1=(Map)originResponse.getEntity();
		Map map2=(Map)map1.get("resultData");
		Long userId=Long.valueOf((String)map2.get("userId"));
		
		EntityDao<SocialAccount, Long> socialAccountDao = new SocialAccountDaoImpl();
		SocialAccount socialAccount = new SocialAccount();
		socialAccount.setFacebookId(facebookId);
		socialAccount.setName(facebookName);
		socialAccount.setMemberId(userId);
		socialAccount.setStoreId(Integer.valueOf(1));
		socialAccount.setSocialAccountId(socialAccountDao.generatePrimaryKey("xsocialaccount"));
		socialAccountDao.persist(socialAccount);

		System.out.println("CreateSocialAccountCmdImpl: bodyMap:" + bodyMap);
	}
}
