package com.mycompany.commerce.sample.persistence;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2015, 2017
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */
import java.util.ArrayList;
import java.util.List;

import java.util.logging.Logger;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.persistence.AbstractJPAEntityDaoImpl;
import com.mycompany.commerce.sample.objects.SocialAccount;

/**
 * SocialAccount DAO implementation as a sample.
 */
public class SocialAccountDaoImpl extends AbstractJPAEntityDaoImpl<SocialAccount, Long> {

	private static final Logger LOGGER = LoggingHelper.getLogger(SocialAccountDaoImpl.class);
	private static final String CLASS_NAME = SocialAccountDaoImpl.class.getName();

	/**
	 * Default constructor.
	 */
	public SocialAccountDaoImpl() {
		super(SocialAccount.class);
	}

	@Override
	protected Predicate[] buildPredicates(CriteriaBuilder cb, CriteriaQuery<?> cq, Root<SocialAccount> root,
			String query, Object... queryParameters) {
		List<Predicate> predicateList = new ArrayList<Predicate>();
		if (query != null) {
			if ("SocialAccount.getSocialAccountsByMemberId".equals(query)) {
				if (queryParameters != null && queryParameters.length == 1) {
					Long memberId = (Long) queryParameters[0];
					if (memberId != null) {
						predicateList.add(cb.equal(root.get("memberId"), memberId));
					}
				}
			}
		}
		Predicate[] predicates = new Predicate[predicateList.size()];
		predicateList.toArray(predicates);
		return predicates;
	}

}