package com.mycompany.commerce.sample.objects;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2017
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */


import java.io.Serializable;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import com.ibm.commerce.base.objects.EntityBase;
import com.ibm.commerce.security.AccessHelper;
import com.ibm.commerce.security.Protectable;
import com.mycompany.commerce.sample.objsrc.SocialAccountAccessHelper;

/**
 * Entity class for social account as a sample.
 */
@Entity
@Table(name = "XSOCIALACCOUNT")
@NamedQueries({
		@NamedQuery(name = "SocialAccount.getSocialAccountsByMemberId", query = "select c from SocialAccount c where c.memberId = :memberId") })
public class SocialAccount extends EntityBase implements Serializable, Protectable {

	private static final long serialVersionUID = 1L;

	private Long socialAccountId;

	private String facebookId;

	private String name;

	private Integer storeId;

	private Long memberId;

	/**
	 * Default constructor.
	 */
	public SocialAccount() {
	}

	/**
	 * Returns the social account id.
	 * 
	 * @return The social account id.
	 */
	@Column(name = "XSOCIALACCOUNT_ID", nullable = false)
	@Basic(optional = false)
	@Id
	public Long getSocialAccountId() {
		return socialAccountId;
	}

	/**
	 * Sets the social account ID.
	 * 
	 * @param social account ID
	 *            The social account ID.
	 */
	public void setSocialAccountId(Long socialAccountId) {
		this.socialAccountId = socialAccountId;
	}

	/**
	 * Returns the first name.
	 * 
	 * @return The first name.
	 */
	@Column(name = "FACEBOOK_ID")
	public String getFacebookId() {
		return facebookId;
	}

	/**
	 * Sets the first name.
	 * 
	 * @param firstName
	 *            The first name.
	 */
	public void setFacebookId(String facebookId) {
		this.facebookId = facebookId;
	}

	/**
	 * Returns the last name.
	 * 
	 * @return The last name.
	 */
	@Column(name = "NAME")
	public String getName() {
		return name;
	}

	/**
	 * Sets the last name.
	 * 
	 * @param lastName
	 *            The last name.
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Returns the store id.
	 * 
	 * @return The store id.
	 */
	@Column(name = "STORE_ID")
	public Integer getStoreId() {
		return storeId;
	}

	/**
	 * Sets the store id.
	 * 
	 * @param sotreId
	 *            the store id.
	 */
	public void setStoreId(Integer storeId) {
		this.storeId = storeId;
	}

	/**
	 * Returns the member id.
	 * 
	 * @return The member id.
	 */
	@Column(name = "MEMBER_ID")
	public Long getMemberId() {
		return memberId;
	}

	/**
	 * Sets the member id.
	 * 
	 * @param memberId
	 *            the member id.
	 */
	public void setMemberId(Long memberId) {
		this.memberId = memberId;
	}

	@Override
	protected AccessHelper getAccessHelper() {
		if (accessHelper == null) {
			accessHelper = new SocialAccountAccessHelper();
		}
		return accessHelper;
	}

}
