package com.mycompany.data.ingest.product.processors;

import java.util.HashMap;
import java.util.Map;

import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.exception.ProcessException;

import com.hcl.software.data.ingest.processors.IngestFlowPostProcessor;

public class ChangeDocument implements IngestFlowPostProcessor{

	private ComponentLog LOGGER = null;

	@Override
	public Map<String, Object> invoke(ProcessContext context, ProcessSession session, FlowFile flowFile,
			                          Map<String, Object> data, Map<String, Object> document) throws ProcessException {

		// Retrieving ORGENTITYDESC from the SQL result set
		String object = (String) data.get("ORGENTITYDESC");
		if (object == null || object.equals("null")) { 
			object = "";
		}
		
		final Map<String, String> map = new HashMap<String, String>();
		final String description = object.trim();
		// seller_description.raw
		map.put("raw", description);
		// seller_description.text
		map.put("text", description);
		// seller_description
		document.put("seller_description", map);

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("document: " + document);
		}

		return document;
	}

	@Override
	public void init(ProcessorInitializationContext context) {
		LOGGER = context.getLogger();
	}
}