package com.mycompany.commerce.rest.extension.project.handler;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2011
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */

import java.util.Map;
import java.util.logging.Logger;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.DELETE;
import javax.ws.rs.Produces;
import com.ibm.commerce.foundation.rest.resourcehandler.AbstractResourceHandler;

import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

import org.apache.wink.common.http.HttpStatus;

import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.mycompany.commerce.rest.extension.bod.helpers.ProjectHelper;
import commonj.sdo.DataObject;
import com.ibm.icu.text.MessageFormat;
import com.ibm.commerce.rest.config.ResourceConfigManager;

/**
 * This class provides RESTful services to retrieve Project details.
 */

@Path("store/{storeId}/project")
@Encoded
public class ProjectHandler extends AbstractResourceHandler {

	private static final String CLASSNAME = ProjectHandler.class.getName();
	private static final Logger LOGGER = LoggingHelper.getLogger(ProjectHandler.class);

	/** The Constant RESOURCE_NAME. */
	public static final String RESOURCE_NAME = "project";
	
	/** The Constant RESOURCE_MAPPING_KEY. */
	public static final String RESOURCE_MAPPING_KEY = "project";

	/** The constant FORMAT_GROUP_NAME */
	public static final String FORMAT_GROUP_NAME = "ShowProject";
	
	/**
	 * Helper to retrieve and deal with BOD.
	 */
	protected ProjectHelper helper = getHelper();
	
	/**
	 * @see com.ibm.commerce.foundation.rest.resourcehandler.IResourceHandler#getResourceName()
	 */
	public String getResourceName() {
		return RESOURCE_NAME;
	}
	
	/**
	 * @see com.ibm.commerce.foundation.rest.resourcehandler.AbstractResourceHandler#getFormattingGroupName()
	 */
	@Override
	public String getFormattingGroupName() {
		return FORMAT_GROUP_NAME;
	}
	
	/**
	 * This method returns the BOD helper associated with the project resource.
	 * This method can be override to use the extended <code>ProjectHelper</code> for customization.
	 * @return ProjectHelper
	 */
	public ProjectHelper getHelper() {
		if(null == helper){
			helper = new ProjectHelper();
		}
		return helper;
	}
	
	
	/**
	 * This method returns the project details by specified projectid.
	 *
	 * @param storeId the store identifier, this is mandatory parameter and cann't be null or empty.
	 * @param projectid the noun's projectid, this is mandatory parameter and cann't be null or empty.
	 * @param responseFormat the response format (xml, json, or atom).
	 * @return The array of project details in the specified format.
	 */
	@GET
	@Path("byProjectId/{projectid}")
	@Produces( { "application/atom+xml", "application/json", "application/xml", "application/xhtml+xml" })
	public Response findProjectByProjectId(
			@PathParam("storeId") String storeId,
			@PathParam("projectid") String projectid,
			@QueryParam(value = "responseFormat") String responseFormat) {
		
		final String METHODNAME = "findProjectByProjectId(String, String, String)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[]{storeId, projectid, responseFormat});
		}
		final String uriPath = "store/{storeId}/project/byProjectId/{projectid}"; 
		final String accessProfile = ResourceConfigManager.getInstance().getAccessProfile(RESOURCE_NAME, uriPath);
		
		// Perform the service request and return the response in the appropriate format.
		Object[] params = { projectid };
		String expression = MessageFormat.format(
				ProjectHelper.FIND_BY_PROJECTID_XPATH, params);
		
		Response result = renderGetProject(expression, accessProfile, responseFormat);
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, new Object[]{result});
		}
		return result;
	}
	
	/**
	 * This method builds the response in appropriate format.
	 *
	 * @param dataArea the resulted data area for Project.
	 * @param responseFormat the response format.
	 * @return the response for Project.
	 */
	protected Response renderGetProject(String expression, String accessProfile,
			String responseFormat) {
		
		final String METHODNAME = "renderGetProject(String, String, String)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[]{expression, accessProfile, responseFormat});
		}
		
		Response result = null;
		try {

			// call helper to get project from service client
			DataObject dataArea = helper.getProject(businessContext,
					activityTokenCallbackHandler, expression, accessProfile);

			Map<String, Object> dataMap = createMapForProvider(dataArea,
					getResourceName(), RESOURCE_MAPPING_KEY, true);

			result = generateResponseFromHttpStatusCodeAndRespData(
					responseFormat, dataMap, HttpStatus.OK);

		} catch (Exception ex) {
			// Call handleException to generate response with error status code
    		result = handleException(responseFormat, ex, METHODNAME);
    	}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, new Object[]{result});
		}
		return result;
	}

	
	
	
}
