BEGIN_SYMBOL_DEFINITIONS
	<!-- XPRJCOL table -->	
	COLS:XPRJCOL_ID=XPRJCOL:XPRJCOL_ID
  	COLS:XPRJCOL=XPRJCOL:*  
	<!-- XPRJCOLDES table -->	
  	COLS:XPRJCOLDES=XPRJCOLDES:*

END_SYMBOL_DEFINITIONS
<!-- ============================================================= -->
<!-- This SQL will return the elements of the ProjectCollection    -->
<!-- noun(s) given the specified search criteria.                  -->
<!-- The access profiles that apply to this SQL are:               -->
<!-- All ProjectCollection profiles                                -->
<!-- @param Context:StoreID - The store for which to retrieve the  -->
<!--        project. This parameter is retrieved from within       -->
<!--	    the business context.           	                   -->
<!-- ============================================================= -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/ProjectCollection[search()]
	base_table=XPRJCOL
	sql=
		SELECT 
			XPRJCOL.$COLS:XPRJCOL_ID$	   
		FROM
			XPRJCOL, $ATTR_TBLS$
		WHERE 
			XPRJCOL.STOREENT_ID IN ($STOREPATH:recipe$) AND
			( $ATTR_CNDS$ ) 
END_XPATH_TO_SQL_STATEMENT
<!-- ============================================================ -->
<!-- This associated SQL:                                         -->
<!-- Adds ProjectCollection with description                      -->
<!-- to the resultant data graph.                                 -->
<!-- ============================================================ -->
BEGIN_ASSOCIATION_SQL_STATEMENT
	name=MyCompany_Details
	base_table=XPRJCOL
	sql=
		SELECT 
	     				XPRJCOL.$COLS:XPRJCOL$,
	     				XPRJCOLDES.$COLS:XPRJCOLDES$

	     	FROM
	     				XPRJCOL
	     				LEFT OUTER JOIN XPRJCOLDES ON XPRJCOL.XPRJCOL_ID = XPRJCOLDES.XPRJCOL_ID 
	     				AND XPRJCOLDES.LANGUAGE_ID IN ($CONTROL:LANGUAGES$)	
	     	WHERE
					XPRJCOL.XPRJCOL_ID in ($ENTITY_PKS$) 

END_ASSOCIATION_SQL_STATEMENT
<!-- ============================================================= -->
<!-- This SQL will return the elements of the ProjectCollection    -->
<!-- noun(s) given ProjectCollection identifier(s)                 -->
<!-- The access profiles that apply to this SQL are:               -->
<!-- MyCompany_Details project profiles                            -->
<!-- @param UniqueID - The ProjectCollection  identifier(s) .      -->
<!-- ============================================================= -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/ProjectCollection[ProjectCollectionIdentifier[(UniqueID=)]]+MyCompany_Admin_Details
	base_table=XPRJCOL
	sql=
			SELECT 
	     				XPRJCOL.$COLS:XPRJCOL$,
	     				XPRJCOLDES.$COLS:XPRJCOLDES$

	     	FROM
	     				XPRJCOL
	     				LEFT OUTER JOIN XPRJCOLDES ON XPRJCOL.XPRJCOL_ID = XPRJCOLDES.XPRJCOL_ID 					
					AND XPRJCOLDES.LANGUAGE_ID IN ($CONTROL:LANGUAGES$)
	     	WHERE
					XPRJCOL.XPRJCOL_ID in (?UniqueID?) 

	     			
END_XPATH_TO_SQL_STATEMENT
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/ProjectCollection[ProjectCollectionIdentifier[(UniqueID=)]]+MyCompany_Store_Details
	base_table=XPRJCOL
	sql=
			SELECT 
	     				XPRJCOL.$COLS:XPRJCOL$,
	     				XPRJCOLDES.$COLS:XPRJCOLDES$

	     	FROM
	     				XPRJCOL
	     				LEFT OUTER JOIN XPRJCOLDES ON XPRJCOL.XPRJCOL_ID = XPRJCOLDES.XPRJCOL_ID 					
					AND XPRJCOLDES.LANGUAGE_ID IN ($CONTROL:LANGUAGES$)
	     	WHERE
					XPRJCOL.XPRJCOL_ID in (?UniqueID?) 

	     			
END_XPATH_TO_SQL_STATEMENT
<!-- ============================================================= -->
<!-- This SQL will return all of the ProjectCollection             -->
<!-- noun(s)                                                       -->
<!-- The access profiles that apply to this SQL are:               -->
<!-- MyCompany_All profiles                                        -->
<!-- @param Context:StoreID - The store for which to retrieve the  -->
<!--        project. This parameter is retrieved from within       -->
<!--	    the business context.           	                   -->
<!-- ============================================================= -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/ProjectCollection+MyCompany_Admin_Details
	base_table=XPRJCOL
	sql=
			SELECT 
	     				XPRJCOL.$COLS:XPRJCOL$,
	     				XPRJCOLDES.$COLS:XPRJCOLDES$

	     	FROM
	     				XPRJCOL
	     				LEFT OUTER JOIN XPRJCOLDES ON XPRJCOL.XPRJCOL_ID = XPRJCOLDES.XPRJCOL_ID 
	     				AND XPRJCOLDES.LANGUAGE_ID IN ($CONTROL:LANGUAGES$)
		WHERE
					XPRJCOL.STOREENT_ID IN ($STOREPATH:recipe$)
	     			
END_XPATH_TO_SQL_STATEMENT
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/ProjectCollection+MyCompany_Store_Details
	base_table=XPRJCOL
	sql=
			SELECT 
	     				XPRJCOL.$COLS:XPRJCOL$,
	     				XPRJCOLDES.$COLS:XPRJCOLDES$

	     	FROM
	     				XPRJCOL
	     				LEFT OUTER JOIN XPRJCOLDES ON XPRJCOL.XPRJCOL_ID = XPRJCOLDES.XPRJCOL_ID 
	     				AND XPRJCOLDES.LANGUAGE_ID IN ($CONTROL:LANGUAGES$)
		WHERE
					XPRJCOL.STOREENT_ID IN ($STOREPATH:recipe$)
	     			
END_XPATH_TO_SQL_STATEMENT
<!-- ========================================================= -->
<!-- ProjectCollection Details Access Profile.                 -->
<!-- This profile returns the following info:                  -->
<!-- 	ProjectCollection with description.                     -->
<!-- ========================================================= -->

BEGIN_PROFILE 
	name=MyCompany_Admin_Details
	BEGIN_ENTITY 
	  base_table=XPRJCOL
	  className=com.ibm.commerce.foundation.internal.server.services.dataaccess.graphbuilderservice.DefaultGraphComposer
      
	associated_sql_statement=MyCompany_Details

    END_ENTITY
END_PROFILE
BEGIN_PROFILE 
	name=MyCompany_Store_Details
	BEGIN_ENTITY 
	  base_table=XPRJCOL
	  className=com.ibm.commerce.foundation.internal.server.services.dataaccess.graphbuilderservice.DefaultGraphComposer
      
	associated_sql_statement=MyCompany_Details

    END_ENTITY
END_PROFILE

