package com.mycompany.commerce.project.facade.server.metadata;

/*
 *-------------------------------------------------------------------
 * IBM Confidential
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (c) Copyright International Business Machines Corporation.
 *     2008
 *     All rights reserved.
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has been
 * deposited with the US Copyright Office.
 *-------------------------------------------------------------------
 */

import java.io.UnsupportedEncodingException;
import java.util.logging.Level;

import org.eclipse.emf.ecore.EClass;

import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.services.dataaccess.DataServiceFacade;
import com.ibm.commerce.foundation.server.services.dataaccess.db.jdbc.ComponentMetadata;


/**
 * The metadata class for Project component
 */
public class ProjectMetadata extends ComponentMetadata {


	private static final String CLASSNAME = ProjectMetadata.class.getName();
	private static final java.util.logging.Logger LOGGER = com.ibm.commerce.foundation.common.util.logging.LoggingHelper.getLogger(ProjectMetadata.class);

    private static final String UTF8_ENCODING = "UTF-8";
	private static final String COMPONENT_ID = "com.mycompany.commerce.project";

    private static DataServiceFacade dataServiceFacade = DataServiceFacade.getInstance(COMPONENT_ID);    

    // Noun's meta data constants
    public static final int PROJECT_NAME_LENGTH_LIMIT = 64;
	public static final int PROJECT_SHORT_DESCRIPTION_LENGTH_LIMIT = 254;
	public static final int PROJECT_LONG_DESCRIPTION_LENGTH_LIMIT = 1024;
    public static final int PROJECTCOLLECTION_NAME_LENGTH_LIMIT = 64;
	public static final int PROJECTCOLLECTION_DESCRIPTION_LENGTH_LIMIT = 254;

	private static final String PACKAGE_NAME = "com.mycompany.commerce.project.facade.server.entity.datatypes.impl.ProjectEntityPackageImpl";
	


	/**
	 * @see com.ibm.commerce.foundation.server.services.dataaccess.db.jdbc.ComponentMetadata#getComponentId()
	 */
	protected String getComponentId() {
		return COMPONENT_ID;
	}
	
	/**
	 * By default will return null. If there is a static SDO defined for this component, then
	 * override the method and return the root EClass. 
	 * 
	 * @return  The root EClass; null if there is no static SDO defined
	 */
	public EClass getRootEClass() {	
		
 		 return com.mycompany.commerce.project.facade.server.entity.datatypes.impl.ProjectEntityPackageImpl.eINSTANCE.getProjectRoot();
		
		
 		
	}
	
	/**
	 * @see com.ibm.commerce.foundation.server.services.dataaccess.db.jdbc.ComponentMetadata#getEPackageName()
	 */
	public String getEPackageName() {
		return PACKAGE_NAME;
	}
	
	/**
	 * This method returns the data service facade to use for interaction with the persistence layer.
	 * @return This method returns the data service facade to use for interaction with the persistence layer.
	 */
	public static DataServiceFacade getDataServiceFacade() {
		return dataServiceFacade;
	}
	
	
	/**
	 * This method checks if the specified string exceed the maximum length that can be stored
	 * in the database. The maxiumum length is specified in the number of bytes.
	 * @param str The string to check.
	 * @param maxLength The maxiumum length of the string specified in the number of bytes.
	 * @return This method returns true if the string length exceeds the maxiumum number
	 * of bytes, otherwise it will return false.
	 */
	public static boolean invalidStringLength(String str, int maxLength) {
		final String METHODNAME = "invalidStringLength";
		try {
			if (str != null && str.length() > 0 && str.getBytes(UTF8_ENCODING).length > maxLength) {
				return true;
			}
		} catch (UnsupportedEncodingException e) {
			if (LoggingHelper.isTraceEnabled(LOGGER)) {
				LOGGER.logp(Level.FINE, CLASSNAME, METHODNAME, "UnsupportedEncodingException: " + e);
			}
		}
		return false;
	}
	
}
