package com.mycompany.commerce.project.facade.server.commands;

import java.util.Map;
import java.util.logging.Logger;

import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.command.bod.bom.AbstractProcessNounUsingBusinessObjectMediatorCmdImpl;
import com.mycompany.commerce.project.facade.datatypes.AcknowledgeProjectType;
import com.mycompany.commerce.project.facade.datatypes.ProjectFactory;
import com.ibm.commerce.oagis9.datatypes.BusinessObjectDocumentType;

/**
 * This class handles the processing of Project activities. The applicable process action 
 * command will be called based on the action of the request. 
 */
public class ProcessProjectCmdImpl extends AbstractProcessNounUsingBusinessObjectMediatorCmdImpl 
		implements ProcessProjectCmd {

	private static final String CLASSNAME = ProcessProjectCmdImpl.class.getName();
	private static final Logger LOGGER = LoggingHelper.getLogger(ProcessProjectCmdImpl.class);

	/**
	 * This method returns the default instance of the Project Factory.
	 * This factory can be used to create objects defined by the Project component.
	 * @return This method returns the default Project Factory.
	 */
	protected ProjectFactory getProjectFactory() {
		return ProjectFactory.eINSTANCE;
	}

	/**
	 * This method builds and returns the business object document that represents the
	 * response of this process request.  
	 * @param nounsAndActions The nouns and actions provided with the process request.
	 * @param persistentObjects The persistent objects that were passed around to the commands
	 * involved with this request.
	 * @return The business object document that represents the response for this request.
	 */
	protected BusinessObjectDocumentType buildAcknowledgeBusinessObjectDocument(
			Map nounsAndActions, Map persistentObjects) {
		final String METHODNAME = "buildAcknowledgeBusinessObjectDocument(Map, Map)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			Object[] param = { nounsAndActions, persistentObjects };
			LOGGER.entering(CLASSNAME, METHODNAME, param);
		}
		AcknowledgeProjectType response = getProjectFactory().createAcknowledgeProjectType();
		response.setDataArea(getProjectFactory().createAcknowledgeProjectDataAreaType());
		response.getDataArea().setAcknowledge(getOagis9Factory().createAcknowledgeType());
		response.getDataArea().getProject().addAll(nounsAndActions.keySet());
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, response);
		}
		return response;
	}

}
