package com.mycompany.commerce.project.facade.server.commands;

import java.util.List;

import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.command.CommandFactory;
import com.ibm.commerce.foundation.server.command.GenericCommandKeyImpl;
import com.ibm.commerce.foundation.server.command.bod.SearchExpression;
import com.ibm.commerce.foundation.server.util.oagis.SelectionCriteriaMapper;
import com.mycompany.commerce.project.facade.ProjectFacadeConstants;
import com.mycompany.commerce.project.facade.datatypes.DocumentRoot;
import com.mycompany.commerce.project.facade.datatypes.ProjectFactory;
import com.mycompany.commerce.project.facade.datatypes.ShowProjectType;
import com.mycompany.commerce.project.facade.datatypes.GetProjectType;
import com.ibm.commerce.oagis9.datatypes.BusinessObjectDocumentType;
import com.ibm.commerce.oagis9.datatypes.ShowType;

/**
 * This command gets activities based on the search criteria and the access profile.  
 * The parent class will call the <code>FetchProjectCmd</code> command to get the nouns,
 * and the method <code>buildShowBusinessObjectDocument</code> returns the response
 * business object document.
 */
public class GetProjectCmdImpl extends
		com.ibm.commerce.foundation.server.command.bod.AbstractGetBusinessObjectDocumentCmdImpl implements GetProjectCmd {

	private static final String CLASSNAME = GetProjectCmdImpl.class.getName();
	private static final java.util.logging.Logger LOGGER = com.ibm.commerce.foundation.common.util.logging.LoggingHelper.getLogger(GetProjectCmdImpl.class);
	
	/**
	 * This method is the default constructor. It performs no actions.
	 */
	public GetProjectCmdImpl() {
		super();
	}

	/**
	 * This method constructs the response Show business object document for the 
	 * given get request.  This method will wrap the specified nouns in the appropriate business object document envelop.
	 * @param show The Show verb to add to the responsing Show business object document.
	 * @param nouns The list of nouns to add to the responding Show business object document.
	 * @return The appropriate Show business object document for the given Get request.
	 */
	protected BusinessObjectDocumentType buildShowBusinessObjectDocument(ShowType show, List nouns) {
		final String METHODNAME = "buildShowBusinessObjectDocument(ShowType,List)";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME,new Object[]{show,nouns});
		}
		
		ShowProjectType bod = getProjectFactory().createShowProjectType();
		bod.setDataArea(getProjectFactory().createShowProjectDataAreaType());
		bod.getDataArea().setShow(show);
		bod.getDataArea().getProject().addAll(nouns);
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
            LOGGER.exiting(CLASSNAME, METHODNAME,bod);
        }
		return bod;
	}
	   
	/**
	 * This method sets the <code>GetProjectType</code> business object document that this command will process.
	 * @param getProject The <code>GetProjectType</code> business object document.
	 */
	public void setGetProject(com.mycompany.commerce.project.facade.datatypes.GetProjectType getProject) {
		setRequestBusinessObjectDocument(getProject);
	}

	/**
	 * This method gets the <code>ShowProjectType</code> business object document result.
	 * @return This method returns the <code>ShowProjectType</code> business object document result to the client.
	 */
	public com.mycompany.commerce.project.facade.datatypes.ShowProjectType getShowProject() {
		return (ShowProjectType) getResultBusinessObjectDocument();
	}
	
	/**
	 * This method returns the default instance of the Project Factory.
	 * This factory can be used to create objects defined by the Project component.
	 * @return This method returns the default Project Factory.
	 */
	protected ProjectFactory getProjectFactory() {
		return ProjectFactory.eINSTANCE;
	}
	
}
