package com.mycompany.commerce.project.facade.server.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import com.ibm.commerce.foundation.common.exception.AbstractApplicationException;
import com.ibm.commerce.foundation.common.exception.ApplicationError;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.internal.common.exception.FoundationApplicationException;
import com.ibm.commerce.foundation.server.command.bod.bom.AbstractChangeNounPartUsingBusinessObjectMediatorCmdImpl;
import com.mycompany.commerce.project.logging.ProjectApplicationMessageKeys;

/**
 * This command is used to change the Instruction part of Project nouns.
 * This commands performs business logic validation and its parent will call the <code>ChangeProjectInstructionPartMediator</code>
 * to persist the changes to the database. 
 */
public class ChangeProjectInstructionPartCmdImpl extends AbstractChangeNounPartUsingBusinessObjectMediatorCmdImpl implements ChangeProjectPartActionCmd {


	/**
	 * Constants for logging and tracing.
	 */
	private static final String CLASSNAME = "com.mycompany.commerce.project.facade.server.commands.ChangeProjectPartCmdImpl";
	private static final Logger LOGGER = LoggingHelper.getLogger(ChangeProjectInstructionPartCmdImpl.class);
	
	/**
	 * This method is the default constructor. It calls the parent method that will call the change mediator.
	 */
	public ChangeProjectInstructionPartCmdImpl() {
		super();
		final String METHODNAME = "ChangeProjectPartCmdImpl()";
    	if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
    		LOGGER.entering(CLASSNAME, METHODNAME);
    		LOGGER.exiting(CLASSNAME, METHODNAME);
    	}
	}
	
	/**
	 * This method performs custom business logic validation when adding a noun part to a noun.
	 * This implemtation blocks the request from proceeding.
	 * @param noun The noun to perform the operation on.
	 * @param nounPart The part of the noun to add.
	 * @param controlParameters The control parameters associated with the operation.
	 * @throws AbstractApplicationException A problem occurred while adding the noun part.
	 */
	protected void validateAdd(Object noun, Object nounPart, List controlParameters) throws AbstractApplicationException {
		final String METHODNAME = "validateAdd(Object,Object,List)";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			Object[] param = { noun, nounPart, controlParameters };
			LOGGER.entering(CLASSNAME, METHODNAME, param);
		}
		
		// TODO: Add business logic validation.
		
		// The following sample code creates an invalid operation exception. 	
		//List validationErrors = new ArrayList();
		//ApplicationError validateError = new ApplicationError(
		//		ApplicationError.TYPE_GENERIC_ERROR,
		//		ProjectApplicationMessageKeys._APP_INVALID_OPERATION,
		//		new Object[] {noun}, LOGGER.getResourceBundleName());
		//validationErrors.add(validateError);
		//if (validationErrors != null && validationErrors.size() > 0) {
		//	throw new FoundationApplicationException(validationErrors, CLASSNAME, METHODNAME, null);
		//}
		
		// Must always call super() to run the data service layer validation.
		super.validateAdd(noun, nounPart, controlParameters);						
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}
	/**
	 * This method performs custom business logic validation when changing a noun part.
	 * This implemtation blocks the request from proceeding.	 
	 * @param noun The noun to perform the operation on.
	 * @param nounPart The part of the noun to change.
	 * @param controlParameters The control parameters associated with the operation.
	 * @throws AbstractApplicationException A problem occurred while adding the noun part.
	 */
	protected void validateChange(Object noun, Object nounPart, List controlParameters) throws AbstractApplicationException {
		final String METHODNAME = "validateChange(Object,Object,List)";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			Object[] param = { noun, nounPart, controlParameters };
			LOGGER.entering(CLASSNAME, METHODNAME, param);
		}
		
		// TODO: Add business logic validation.
		
		// The following sample code creates an invalid operation exception. 	
		//List validationErrors = new ArrayList();
		//ApplicationError validateError = new ApplicationError(
		//		ApplicationError.TYPE_GENERIC_ERROR,
		//		ProjectApplicationMessageKeys._APP_INVALID_OPERATION,
		//		new Object[] {noun}, LOGGER.getResourceBundleName());
		//validationErrors.add(validateError);
		//if (validationErrors != null && validationErrors.size() > 0) {
		//	throw new FoundationApplicationException(validationErrors, CLASSNAME, METHODNAME, null);
		//}
		
		// Must always call super() to run the data service layer validation.
		super.validateChange(noun, nounPart, controlParameters);	
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}
	/**
	 * This method performs custom business logic validation when deleting a noun part.
	 * This implementation blocks the request from proceeding.	 
	 * @param noun The noun to perform the operation on.
	 * @param nounPart The part of the noun to delete.
	 * @param controlParameters The control parameters associated with the operation.
	 * @throws AbstractApplicationException A problem occurred while adding the noun part.
	 */
	protected void validateDelete(Object noun, Object nounPart, List controlParameters) throws AbstractApplicationException {
		final String METHODNAME = "validateDelete(Object,Object,List)";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			Object[] param = { noun, nounPart, controlParameters };
			LOGGER.entering(CLASSNAME, METHODNAME, param);
		}
		
		// TODO: Add business logic validation.
		
		// The following sample code creates an invalid operation exception. 	
		//List validationErrors = new ArrayList();
		//ApplicationError validateError = new ApplicationError(
		//		ApplicationError.TYPE_GENERIC_ERROR,
		//		ProjectApplicationMessageKeys._APP_INVALID_OPERATION,
		//		new Object[] {noun}, LOGGER.getResourceBundleName());
		//validationErrors.add(validateError);
		//if (validationErrors != null && validationErrors.size() > 0) {
		//	throw new FoundationApplicationException(validationErrors, CLASSNAME, METHODNAME, null);
		//}
		
		// Must always call super() to run the data service layer validation.
		super.validateDelete(noun, nounPart, controlParameters);	
		
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

}

