package com.mycompany.commerce.project.facade.client;

import javax.security.auth.callback.CallbackHandler;

import com.ibm.commerce.foundation.common.datatypes.BusinessContextType;
import com.mycompany.commerce.project.facade.ExternalProjectFacadeConstants;
import com.mycompany.commerce.project.facade.datatypes.AcknowledgeProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.AcknowledgeProjectType;
import com.mycompany.commerce.project.facade.datatypes.ChangeProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.ChangeProjectType;
import com.mycompany.commerce.project.facade.datatypes.DocumentRoot;
import com.mycompany.commerce.project.facade.datatypes.GetProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.GetProjectType;
import com.mycompany.commerce.project.facade.datatypes.ProcessProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.ProcessProjectType;
import com.mycompany.commerce.project.facade.datatypes.ProjectFactory;
import com.mycompany.commerce.project.facade.datatypes.RespondProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.RespondProjectType;
import com.mycompany.commerce.project.facade.datatypes.ShowProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.ShowProjectType;



/**
 * <p>This class provides a set of methods that can be used to communicate with the
 * Project facade running on an external system.</p>
 */
public abstract class AbstractExternalProjectFacadeClient extends com.mycompany.commerce.project.facade.client.AbstractProjectFacadeClient {

	
	// ==============================================================================
	// Constants for logging and tracing.
	// ==============================================================================
	private static final String CLASSNAME = AbstractExternalProjectFacadeClient.class.getName();
	private static final java.util.logging.Logger LOGGER = com.ibm.commerce.foundation.common.util.logging.LoggingHelper.getLogger(AbstractExternalProjectFacadeClient.class);
	
	// ==============================================================================
	// Constructors for the client to the ExternalProject facade.
	// ==============================================================================
	
	/**
	 * Creates an instance of the client to communicate with the ExternalProject facade.
	 */
	public AbstractExternalProjectFacadeClient() {
		super();
	}
	/**
	 * Creates an instance of the client to communicate with the ExternalProject facade.
	 * @param businessContext The default business context to associate with the messages
	 * when making requests.
	 * @param callbackHandler Used for authentication purposes so the controller can give
	 * the authentication information to the transport when required.
	 */
	public AbstractExternalProjectFacadeClient(BusinessContextType businessContext,
			CallbackHandler callbackHandler) {
		super(businessContext, callbackHandler);
	}	
	
	/**
	 * This method will return the default instance of the Project Factory.
	 * This factory can be used to create objects defined by the Project.
	 * @return The default Project Factory.
	 */
	protected ProjectFactory getProjectFactory() {
		return ProjectFactory.eINSTANCE;		
	}
	
	
	// ==============================================================================
	// The high level service operations that make the request to the ExternalProject facade.
	// These operations are for Project.
	// ==============================================================================
	
	/**
	 * This method will communicate with the ExternalProject facade and send the specified
	 * GetProject. request.
	 * @param aGetProject The GetProject request document.
	 * @return The resulting <code>ShowProject</code> response document.
	 */
	public ShowProjectType 
				getProject(GetProjectType aGetProject) {
		final String METHODNAME = "getProject(GetProjectType)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.entering(CLASSNAME, METHODNAME, aGetProject);
		}
		
		DocumentRoot docRoot = getProjectFactory().createDocumentRoot();
		docRoot.setGetProject(aGetProject);
		aGetProject.setVersionID(docRoot.getProjectBODVersion());
		
		ShowProjectType response = 
			(ShowProjectType) sendBusinessObjectDocument(
					com.mycompany.commerce.project.facade.ProjectFacade.class, ExternalProjectFacadeConstants.COMPONENT_NAME, aGetProject);
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.exiting(CLASSNAME, METHODNAME, response);
		}
		return response;
	}
	
	/**
	 * This method will communicate with the ExternalProject facade and send the specified
	 * ProcessProject request.
	 * @param aProcessProject The ProcessProject request document.
	 * @return The resulting AcknowledgeProject response document.
	 */
	public AcknowledgeProjectType 
			processProject(ProcessProjectType aProcessProject) {
		final String METHODNAME = "processProject(ProcessProjectType)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.entering(CLASSNAME, METHODNAME, aProcessProject);
		}
		
		DocumentRoot docRoot = getProjectFactory().createDocumentRoot();
		docRoot.setProcessProject(aProcessProject);
		aProcessProject.setVersionID(docRoot.getProjectBODVersion());
		
		AcknowledgeProjectType response = 
			(AcknowledgeProjectType) sendBusinessObjectDocument(
					com.mycompany.commerce.project.facade.ProjectFacade.class, ExternalProjectFacadeConstants.COMPONENT_NAME, aProcessProject);
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.exiting(CLASSNAME, METHODNAME, response);
		}
		return response;
	}
	
	/**
	 * This method will communicate with the ExternalProject facade and send the specified
	 * ChangeProject request.
	 * @param aChangeProject The ChangeProject request document.
	 * @return The resulting RespondProject response document.
	 */
	public RespondProjectType 
			changeProject(ChangeProjectType aChangeProject) {
		final String METHODNAME = "changeProject(ChangeProjectType)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.entering(CLASSNAME, METHODNAME, aChangeProject);
		}
		
		DocumentRoot docRoot = getProjectFactory().createDocumentRoot();
		docRoot.setChangeProject(aChangeProject);
		aChangeProject.setVersionID(docRoot.getProjectBODVersion());		
		
		RespondProjectType response = 
			(RespondProjectType) sendBusinessObjectDocument(
					com.mycompany.commerce.project.facade.ProjectFacade.class, ExternalProjectFacadeConstants.COMPONENT_NAME, aChangeProject);
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.exiting(CLASSNAME, METHODNAME, response);
		}
		return response;
	}
	

	
	// ==============================================================================
	// The high level service operations that make the request to the ExternalProject facade.
	// These operations are for ProjectCollection.
	// ==============================================================================
	
	/**
	 * This method will communicate with the ExternalProject facade and send the specified
	 * GetProjectCollection. request.
	 * @param aGetProjectCollection The GetProjectCollection request document.
	 * @return The resulting <code>ShowProjectCollection</code> response document.
	 */
	public ShowProjectCollectionType 
				getProjectCollection(GetProjectCollectionType aGetProjectCollection) {
		final String METHODNAME = "getProjectCollection(GetProjectCollectionType)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.entering(CLASSNAME, METHODNAME, aGetProjectCollection);
		}
		
		DocumentRoot docRoot = getProjectFactory().createDocumentRoot();
		docRoot.setGetProjectCollection(aGetProjectCollection);
		aGetProjectCollection.setVersionID(docRoot.getProjectCollectionBODVersion());
		
		ShowProjectCollectionType response = 
			(ShowProjectCollectionType) sendBusinessObjectDocument(
					com.mycompany.commerce.project.facade.ProjectCollectionFacade.class, ExternalProjectFacadeConstants.COMPONENT_NAME, aGetProjectCollection);
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.exiting(CLASSNAME, METHODNAME, response);
		}
		return response;
	}
	
	/**
	 * This method will communicate with the ExternalProject facade and send the specified
	 * ProcessProjectCollection request.
	 * @param aProcessProjectCollection The ProcessProjectCollection request document.
	 * @return The resulting AcknowledgeProjectCollection response document.
	 */
	public AcknowledgeProjectCollectionType 
			processProjectCollection(ProcessProjectCollectionType aProcessProjectCollection) {
		final String METHODNAME = "processProjectCollection(ProcessProjectCollectionType)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.entering(CLASSNAME, METHODNAME, aProcessProjectCollection);
		}
		
		DocumentRoot docRoot = getProjectFactory().createDocumentRoot();
		docRoot.setProcessProjectCollection(aProcessProjectCollection);
		aProcessProjectCollection.setVersionID(docRoot.getProjectCollectionBODVersion());
		
		AcknowledgeProjectCollectionType response = 
			(AcknowledgeProjectCollectionType) sendBusinessObjectDocument(
					com.mycompany.commerce.project.facade.ProjectCollectionFacade.class, ExternalProjectFacadeConstants.COMPONENT_NAME, aProcessProjectCollection);
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.exiting(CLASSNAME, METHODNAME, response);
		}
		return response;
	}
	
	/**
	 * This method will communicate with the ExternalProjectCollection facade and send the specified
	 * ChangeProjectCollection request.
	 * @param aChangeProjectCollection The ChangeProjectCollection request document.
	 * @return The resulting RespondProjectCollection response document.
	 */
	public RespondProjectCollectionType 
			changeProjectCollection(ChangeProjectCollectionType aChangeProjectCollection) {
		final String METHODNAME = "changeProjectCollection(ChangeProjectCollectionType)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.entering(CLASSNAME, METHODNAME, aChangeProjectCollection);
		}
		
		DocumentRoot docRoot = getProjectFactory().createDocumentRoot();
		docRoot.setChangeProjectCollection(aChangeProjectCollection);
		aChangeProjectCollection.setVersionID(docRoot.getProjectCollectionBODVersion());		
		
		RespondProjectCollectionType response = 
			(RespondProjectCollectionType) sendBusinessObjectDocument(
					com.mycompany.commerce.project.facade.ProjectCollectionFacade.class, ExternalProjectFacadeConstants.COMPONENT_NAME, aChangeProjectCollection);
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {			
			LOGGER.exiting(CLASSNAME, METHODNAME, response);
		}
		return response;
	}
	

	
}
