package com.mycompany.commerce.project.facade.server.services.dataaccess.bom.mediator;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp.  2008
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import com.ibm.commerce.foundation.common.datatypes.CommerceFoundationFactory;
import com.ibm.commerce.foundation.common.datatypes.StoreIdentifierType;
import com.ibm.commerce.foundation.common.datatypes.UserDataType;
import com.ibm.commerce.foundation.common.exception.AbstractApplicationException;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.exception.BusinessObjectMediatorException;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.AbstractReadBusinessObjectMediatorImpl;
import com.mycompany.commerce.project.facade.datatypes.ProjectDifficultyType;
import com.mycompany.commerce.project.facade.datatypes.ProjectFactory;
import com.mycompany.commerce.project.facade.datatypes.ProjectExternalIdentifierType;
import com.mycompany.commerce.project.facade.datatypes.ProjectIdentifierType;
import com.mycompany.commerce.project.facade.datatypes.ProjectType;
import com.mycompany.commerce.project.facade.server.entity.datatypes.Xproject;

/**
 * Read operation on the logical noun for Project
 */
public class ReadProjectMediator extends AbstractReadBusinessObjectMediatorImpl {

	private static final String CLASSNAME = ReadProjectMediator.class.getName();

	private static final Logger LOGGER = LoggingHelper
			.getLogger(ReadProjectMediator.class);

	/**
	 * @see com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.ReadBusinessObjectMediator#buildNoun(java.lang.Object,
	 *      java.lang.Object)
	 */
	public void buildNoun(Object aLogicalEntityType, Object aPhysicalEntityType)
			throws BusinessObjectMediatorException,
			AbstractApplicationException {
		final String METHODNAME = "buildNoun";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] {
					aLogicalEntityType, aPhysicalEntityType });
		}

		

		ProjectType aProjectLogicalDO = (ProjectType) aLogicalEntityType;
		Xproject aProjectPhysicalDO = (Xproject) aPhysicalEntityType;

		// build the logical SDO by using the Phyical SDO

		// build the id type with uid and name
		buildProjectIdentifier(aProjectLogicalDO, aProjectPhysicalDO);
		buildDifficult(aProjectLogicalDO, aProjectPhysicalDO);
		if (aProjectPhysicalDO.getTime() != null) {
			aProjectLogicalDO.setTimeToComplete(new BigInteger(
					aProjectPhysicalDO.getTime().toString()));
		}

		

		// build the userdata from logical DataObject into Physical DataObject
		buildUserData(aProjectLogicalDO, aProjectPhysicalDO);

		

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, aLogicalEntityType);
		}

	}

	/**
	 * Builds the Project entry identifier
	 * 
	 * @param aProjectLogicalDO
	 *            The logical entity
	 * @param aPhysicalEntityType
	 *            The physical entity
	 */
	protected void buildProjectIdentifier(ProjectType aProjectLogicalDO,
			Object aPhysicalEntityType) {

		final String METHODNAME = "buildProjectIdentifier";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] {
					aProjectLogicalDO, aPhysicalEntityType });
		}

		// create the ID object and set to the logical data object
		ProjectIdentifierType aProjectIdentifier = getProjectFactory()
				.createProjectIdentifierType();
		aProjectLogicalDO.setProjectIdentifier(aProjectIdentifier);

		Xproject aProjectPhysicalDO = (Xproject) aPhysicalEntityType;

		// set the uid in ID object
		aProjectIdentifier.setUniqueID(Long.toString(aProjectPhysicalDO
				.getXproject_id()));

		if (aProjectPhysicalDO.getPrjname() != null) {
			// set the name in ID object
			ProjectExternalIdentifierType exId = getProjectFactory()
					.createProjectExternalIdentifierType();
			aProjectIdentifier.setExternalIdentifier(exId);
			exId.setName(aProjectPhysicalDO.getPrjname());
			StoreIdentifierType storeIdentifier = CommerceFoundationFactory.eINSTANCE
					.createStoreIdentifierType();
			storeIdentifier.setUniqueID((new Integer(aProjectPhysicalDO
					.getStoreent_id())).toString());
			exId.setStoreIdentifier(storeIdentifier);
		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

	/**
	 * @see com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.ReadBusinessObjectMediator#createNounType()
	 */
	public Object createNounType() throws BusinessObjectMediatorException {
		return getProjectFactory().createProjectType();
	}

	/**
	 * Getter method which returns the <code>ProjectFactory</code>.
	 * 
	 * @return an object of type <code>ProjectFactory</code>
	 */
	protected ProjectFactory getProjectFactory() {
		return ProjectFactory.eINSTANCE;
	}

	/**
	 * This method populates the Project noun level configurable user data.
	 * 
	 * @param aLogicalEntityType
	 *            The logical noun.
	 * @param aPhysicalEntity
	 *            The physical data object.
	 * @throws AbstractApplicationException
	 */
	
	public void buildUserData(ProjectType aLogicalEntityType,
			Xproject aPhysicalEntity) throws AbstractApplicationException {
		final String METHODNAME = "buildUserData";

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] {
					aLogicalEntityType, aPhysicalEntity });
		}
		Map attributes = new HashMap();
		populateNameValuePairType(attributes, aLogicalEntityType,
				aPhysicalEntity);
		UserDataType userData = getCommerceFoundationFactory()
				.createUserDataType();
		aLogicalEntityType.setUserData(userData);
		Iterator anIter = attributes.entrySet().iterator();
		while (anIter.hasNext()) {
			Map.Entry anEntry = (Map.Entry) anIter.next();
			if (anEntry.getKey() != null && anEntry.getValue() != null) {
				aLogicalEntityType.getUserData().getUserDataField().put(
						anEntry.getKey().toString(),
						anEntry.getValue().toString());
			}
		}
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}
	

	/**
	 * This method will return the default instance of the Commerce Foundation
	 * Factory. This factory can be used to create objects defined by the
	 * Commerce Foundation.
	 * 
	 * @return The default Commerce Foundation Factory.
	 */
	protected CommerceFoundationFactory getCommerceFoundationFactory() {
		return CommerceFoundationFactory.eINSTANCE;
	}

	protected void buildDifficult(ProjectType aLogicalEntity,
			Xproject aPhysicalEntity) throws BusinessObjectMediatorException {
		if (aPhysicalEntity.getDifficulty() != null) {
			ProjectDifficultyType aProjectDiff = null;

			int state = aPhysicalEntity.getDifficulty().intValue();
			switch (state) {
			case 0:
				aProjectDiff = ProjectDifficultyType.EASY_LITERAL;
				break;
			case 1:
				aProjectDiff = ProjectDifficultyType.NORMAL_LITERAL;
				break;
			case 2:
				aProjectDiff = ProjectDifficultyType.DIFFICULT_LITERAL;
				break;
			}

			aLogicalEntity.setDifficulty(aProjectDiff);
		}

	}
}
