package com.mycompany.commerce.project.facade.server.services.dataaccess.bom.mediator;
/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp.  2008
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import com.ibm.commerce.foundation.common.datatypes.CommerceFoundationFactory;
import com.ibm.commerce.foundation.common.datatypes.DescriptionType;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.exception.BusinessObjectMediatorException;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.AbstractReadBusinessObjectPartMediatorImpl;
import com.mycompany.commerce.project.facade.datatypes.ProjectFactory;
import com.mycompany.commerce.project.facade.datatypes.ProjectInstructionType;
import com.mycompany.commerce.project.facade.datatypes.ProjectType;
import com.mycompany.commerce.project.facade.server.entity.datatypes.Xprjins;
import com.mycompany.commerce.project.facade.server.entity.datatypes.Xprjinsdes;
import com.mycompany.commerce.project.facade.server.entity.datatypes.Xproject;

/**
 * Read operation on the logical noun for Project
 */
public class ReadProjectInstructionPartMediator extends
		AbstractReadBusinessObjectPartMediatorImpl {

	private static final String CLASSNAME = ReadProjectInstructionPartMediator.class
			.getName();

	private static final Logger LOGGER = LoggingHelper
			.getLogger(ReadProjectInstructionPartMediator.class);

	/**
	 * This method reads the logical Project description noun part and adds it to the main Project noun.
	 * @param aLogicalEntityType The root noun which will contain the noun part built through this mediator.
	 * @param aPhysicalEntityType The root physical data object.
	 * @throws BusinessObjectMediatorException
	 */
	public void buildNounPart(Object aLogicalEntityType,
			Object aPhysicalEntityType) throws BusinessObjectMediatorException {
		final String METHODNAME = "buildNounPart";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] {
					aLogicalEntityType, aPhysicalEntityType });
		}

		if (aPhysicalEntityType != null) {
			ProjectType aProjectLogicalDO = (ProjectType) aLogicalEntityType;
			Xproject aProjectPhysicalDO = (Xproject) aPhysicalEntityType;

			// build the logical SDO by using the Phyical SDO 

			List aListIns = aProjectPhysicalDO.getXprjinsForXproject();
			if (aListIns != null) {
				Iterator objIter = aListIns.iterator();

				while (objIter.hasNext()) {

					Xprjins aPhysicalIns = (Xprjins) objIter.next();

					ProjectInstructionType instructionType = getProjectFactory()
							.createProjectInstructionType();

					instructionType.setUniqueID(Long.toString(aPhysicalIns
							.getXprjins_id()));
					instructionType.setDisplaySequence(aPhysicalIns.getSeq()
							.intValue());
					if (aPhysicalIns.getIsoptional().intValue() == 1)
						instructionType.setOptional(true);
					else
						instructionType.setOptional(false);

					buildInstructionDescription(instructionType, aPhysicalIns);

					aProjectLogicalDO.getInstruction().add(instructionType);

				}
			}

		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

	private void buildInstructionDescription(
			ProjectInstructionType instructionType, Xprjins aPhysicalIns) {
		final String METHODNAME = "buildInstructionDescription";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] {
					instructionType, aPhysicalIns });
		}

		List aListDescription = aPhysicalIns.getXprjinsdesForXprjins();
		if (aListDescription != null) {
			Iterator objIter = aListDescription.iterator();

			while (objIter.hasNext()) {

				Xprjinsdes aDescription = (Xprjinsdes) objIter.next();

				DescriptionType descriptionType = getCommerceFoundationFactory()
						.createDescriptionType();
				descriptionType.setLanguage(Integer.toString(aDescription
						.getLanguage_id()));
				descriptionType.setValue(aDescription.getShortdesc());

				instructionType.getProjectInstructionDescription().add(
						descriptionType);
			}
		}
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

	/**
	 * Getter method which returns the <code>ProjectFactory</code>. 
	 * @return an object of type <code>ProjectFactory</code>
	 */
	protected ProjectFactory getProjectFactory() {
		return ProjectFactory.eINSTANCE;
	}

	/**
	 * This method will return the default instance of the Commerce Foundation Factory.
	 * This factory can be used to create objects defined by the Commerce Foundation.
	 * @return The default Commerce Foundation Factory.
	 */
	protected CommerceFoundationFactory getCommerceFoundationFactory() {
		return CommerceFoundationFactory.eINSTANCE;
	}

}
