package com.mycompany.commerce.project.facade.server.services.dataaccess.bom.mediator;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2008
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import com.ibm.commerce.foundation.common.datatypes.CommerceFoundationFactory;
import com.ibm.commerce.foundation.common.datatypes.StoreIdentifierType;
import com.ibm.commerce.foundation.common.datatypes.UserDataType;
import com.ibm.commerce.foundation.common.exception.AbstractApplicationException;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.exception.BusinessObjectMediatorException;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.AbstractReadBusinessObjectMediatorImpl;
import com.ibm.wsspi.sib.exitpoint.ra.HashMap;
import com.mycompany.commerce.project.facade.datatypes.ProjectCollectionExternalIdentifierType;
import com.mycompany.commerce.project.facade.datatypes.ProjectCollectionIdentifierType;
import com.mycompany.commerce.project.facade.datatypes.ProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.ProjectFactory;
import com.mycompany.commerce.project.facade.server.entity.datatypes.Xprjcol;

/**
 * Read operation on the logical noun for ProjectCollection
 */
public class ReadProjectCollectionMediator extends
		AbstractReadBusinessObjectMediatorImpl {

	private static final String CLASSNAME = ReadProjectCollectionMediator.class
			.getName();

	private static final Logger LOGGER = LoggingHelper
			.getLogger(ReadProjectCollectionMediator.class);

	/**
	 * @throws AbstractApplicationException
	 * @see com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.ReadBusinessObjectMediator#buildNoun(java.lang.Object,
	 *      java.lang.Object)
	 */
	public void buildNoun(Object aLogicalEntityType, Object aPhysicalEntityType)
			throws AbstractApplicationException {
		final String METHODNAME = "buildNoun";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] {
					aLogicalEntityType, aPhysicalEntityType });
		}

		ProjectCollectionType aProjectCollectionLogicalDO = (ProjectCollectionType) aLogicalEntityType;
		Xprjcol aProjectCollectionPhysicalDO = (Xprjcol) aPhysicalEntityType;

		// build the logical SDO by using the Phyical SDO

		// build the id type with uid and name
		buildProjectCollectionIdentifier(aProjectCollectionLogicalDO,
				aProjectCollectionPhysicalDO);

		// build the userdata from logical DataObject into Physical DataObject
		buildUserData(aProjectCollectionLogicalDO, aProjectCollectionPhysicalDO);

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, aLogicalEntityType);
		}

	}

	/**
	 * Builds the ProjectCollection entry identifier
	 * 
	 * @param aProjectCollectionLogicalDO
	 *            The logical entity
	 * @param aPhysicalEntityType
	 *            The physical entity
	 */
	protected void buildProjectCollectionIdentifier(
			ProjectCollectionType aProjectCollectionLogicalDO,
			Object aPhysicalEntityType) {

		final String METHODNAME = "buildProjectCollectionIdentifier";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] {
					aProjectCollectionLogicalDO, aPhysicalEntityType });
		}

		// create the ID object and set to the logical data object
		ProjectCollectionIdentifierType aProjectCollectionIdentifier = getProjectFactory()
				.createProjectCollectionIdentifierType();
		aProjectCollectionLogicalDO
				.setProjectCollectionIdentifier(aProjectCollectionIdentifier);

		Xprjcol aProjectCollectionPhysicalDO = (Xprjcol) aPhysicalEntityType;

		// set the uid in ID object
		aProjectCollectionIdentifier.setUniqueID(Long
				.toString(aProjectCollectionPhysicalDO.getXprjcol_id()));

		// set the name in ID object
		ProjectCollectionExternalIdentifierType exId = getProjectFactory()
				.createProjectCollectionExternalIdentifierType();
		aProjectCollectionIdentifier.setExternalIdentifier(exId);
		exId.setName(aProjectCollectionPhysicalDO.getPrjcolname());
		// set store in ID object
		StoreIdentifierType storeIdentifier = getCommerceFoundationFactory()
				.createStoreIdentifierType();
		storeIdentifier.setUniqueID(String.valueOf(aProjectCollectionPhysicalDO
				.getStoreent_id()));
		exId.setStoreIdentifier(storeIdentifier);

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

	/**
	 * @see com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.ReadBusinessObjectMediator#createNounType()
	 */
	public Object createNounType() throws BusinessObjectMediatorException {
		return getProjectFactory().createProjectCollectionType();
	}

	/**
	 * Getter method which returns the <code>ProjectFactory</code>.
	 * 
	 * @return an object of type <code>ProjectFactory</code>
	 */
	protected ProjectFactory getProjectFactory() {
		return ProjectFactory.eINSTANCE;
	}

	/**
	 * This method populates the ProjectCollection noun level configurable user
	 * data.
	 * 
	 * @param aLogicalEntityType
	 *            The logical noun.
	 * @param aPhysicalEntity
	 *            The physical data object.
	 * @throws AbstractApplicationException
	 */

	public void buildUserData(ProjectCollectionType aLogicalEntityType,
			Xprjcol aPhysicalEntity) throws AbstractApplicationException {
		final String METHODNAME = "buildUserData";

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] {
					aLogicalEntityType, aPhysicalEntity });
		}
		Map attributes = new HashMap();
		populateNameValuePairType(attributes, aLogicalEntityType,
				aPhysicalEntity);
		UserDataType userData = getCommerceFoundationFactory()
				.createUserDataType();
		aLogicalEntityType.setUserData(userData);
		Iterator anIter = attributes.entrySet().iterator();
		while (anIter.hasNext()) {
			Map.Entry anEntry = (Map.Entry) anIter.next();
			if (anEntry.getKey() != null && anEntry.getValue() != null) {
				aLogicalEntityType.getUserData().getUserDataField().put(
						anEntry.getKey().toString(),
						anEntry.getValue().toString());
			}
		}
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

	/**
	 * This method will return the default instance of the Commerce Foundation
	 * Factory. This factory can be used to create objects defined by the
	 * Commerce Foundation.
	 * 
	 * @return The default Commerce Foundation Factory.
	 */
	protected CommerceFoundationFactory getCommerceFoundationFactory() {
		return CommerceFoundationFactory.eINSTANCE;
	}

}
