package com.mycompany.commerce.project.facade.server.exception;

import com.ibm.commerce.foundation.common.exception.AbstractApplicationException;

/**
 * This is the exception class that can be used for any application level exceptions
 * to be thrown during the execution of Project services. See the constructor details
 * for creating this exception. See documentation for 
 * <code>com.ibm.commerce.foundation.common.exception.AbstractApplicationException</code>
 * for more details on the behaviour of this exception.
 */
public class ProjectApplicationException extends AbstractApplicationException {


	/**
	 * This method creates the ProjectApplicationException.
	 * @param messageKey The message key of the exception.
	 * @param params The parameters used for the message key of the exception.
	 * @param className The name of the class throwing the exception.
	 * @param methodName The name of the method throwing the exception.
	 */
	public ProjectApplicationException(String messageKey, Object[] params,
			String className, String methodName) {
		super(messageKey, params, className, methodName);
	}
	
	/**
	 * This method creates the ProjectApplicationException.
	 * @param astrMessageKey The message key of the exception.
	 * @param aParams The parameters used for the message key of the exception.
	 * @param aResourceBundle The resource bundle associated with the message key
	 * @param astrClassName The name of the class throwing the exception.
	 * @param astrMethodName The name of the method throwing the exception.
	 * @param aCause The cause of the exception.
	 */
	public ProjectApplicationException(String astrMessageKey, Object[] aParams, String aResourceBundle,
			String astrClassName, String astrMethodName, Throwable aCause) {
		super(astrMessageKey, null, null, aParams, aResourceBundle, astrClassName, astrMethodName, aCause);
	}
}
