package com.mycompany.commerce.project.facade.server.commands;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2008
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.ibm.commerce.catalog.facade.client.CatalogEntryException;
import com.ibm.commerce.catalog.facade.client.CatalogEntryFacadeClient;
import com.ibm.commerce.catalog.facade.datatypes.CatalogDescriptionType;
import com.ibm.commerce.catalog.facade.datatypes.CatalogEntryType;
import com.ibm.commerce.foundation.client.util.oagis.SelectionCriteriaHelper;
import com.ibm.commerce.foundation.common.datatypes.CommerceFoundationFactory;
import com.ibm.commerce.foundation.common.datatypes.DescriptionType;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.command.bod.AbstractInsertMoreNounDataCmdImpl;
import com.mycompany.commerce.project.facade.datatypes.CatentryReferenceType;
import com.mycompany.commerce.project.facade.datatypes.ProjectFactory;
import com.mycompany.commerce.project.facade.datatypes.ProjectMaterialType;
import com.mycompany.commerce.project.facade.datatypes.ProjectType;

/**
 * The command used to insert more Project data based on MyCompany_Admin_Details
 * access profile. 
 * It gets catentry name by invoke catalog services
 * /CatalogEntry[CatalogEntryIdentifier[(UniqueID='catentryID')]]+IBM_Admin_CatalogEntryDescription
 * The services is provided by catalog services as a SOA interface.
 */
public class InsertMoreProjectDataAdminCmdImpl extends
		AbstractInsertMoreNounDataCmdImpl {

	private static final java.util.logging.Logger LOGGER = com.ibm.commerce.foundation.common.util.logging.LoggingHelper
			.getLogger(InsertMoreProjectDataAdminCmdImpl.class);

	private static final String CLASSNAME = InsertMoreProjectDataAdminCmdImpl.class
			.getName();

	/**
	 * 
	 * @see com.ibm.websphere.command.TargetableCommand#performExecute()
	 */
	public void performExecute() throws Exception {

		final String METHODNAME = "performExecute";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME);
		}

		List projectNouns = getNouns();
		Iterator projectIterator = projectNouns.iterator();

		// a map of catalog entry id and a list of references to populate.
		Map catentryReferences = new HashMap();

		// resolve all the catalog entries to look for and associate them with
		// the
		// object to populate.
		while (projectIterator.hasNext()) {

			ProjectType project = (ProjectType) projectIterator.next();
			List tools = project.getTool();
			associateCatalogEntryReferenceList(catentryReferences, tools);

			List materials = project.getMaterial();
			Iterator anItMtr = materials.iterator();
			while (anItMtr.hasNext()) {
				ProjectMaterialType aMaterail = (ProjectMaterialType) anItMtr
						.next();
				CatentryReferenceType aCatentry = aMaterail.getCatalogEntry();
				if (aCatentry != null) {					
					associateCatalogEntryReferenceList(catentryReferences, aCatentry);
				}
			}
			//	populate all the catalog entry references
			if(catentryReferences.keySet().size()>0){
				populateCatalogEntryReferences(catentryReferences);
			}

			
		}
		

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}

	}

	/**
	 * This class creates a catlogEntryId association with a list of catalog
	 * entry references that refer to it. The reason why we want this
	 * association is so we do one catalog entry request for specific catalog
	 * entries instead of making a service request for each catalog entry
	 * reference.
	 * 
	 * @param catalogIdAssociation
	 * @param catalogEntryReferences
	 */
	private void associateCatalogEntryReferenceList(Map catalogIdAssociation,
			List catalogEntryReferences) {
		final String METHODNAME = "associateCatalogEntryReferenceList(Map,List)";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			Object[] param = { catalogIdAssociation, catalogEntryReferences };
			LOGGER.entering(CLASSNAME, METHODNAME, param);
		}

		Iterator itr = catalogEntryReferences.iterator();
		while (itr.hasNext()) {
			CatentryReferenceType catalogEntryReference = (CatentryReferenceType) itr
					.next();
			String uniqueID = catalogEntryReference.getCatalogEntryIdentifier()
					.getUniqueID();
			List references = (List) catalogIdAssociation.get(uniqueID);
			if (references == null) {
				references = new ArrayList();
				catalogIdAssociation.put(uniqueID, references);
			}
			references.add(catalogEntryReference);
		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}
	/**
	 * This class creates a catlogEntryId association with a list of catalog
	 * entry references that refer to it. The reason why we want this
	 * association is so we do one catalog entry request for specific catalog
	 * entries instead of making a service request for each catalog entry
	 * reference.
	 * 
	 * @param catalogIdAssociation
	 * @param catalogEntryReferences
	 */
	private void associateCatalogEntryReferenceList(Map catalogIdAssociation,
			CatentryReferenceType catalogEntryReference) {
		final String METHODNAME = "associateCatalogEntryReferenceList(Map,CatentryReferenceType )";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			Object[] param = { catalogIdAssociation, catalogEntryReference};
			LOGGER.entering(CLASSNAME, METHODNAME, param);
		}

			String uniqueID = catalogEntryReference.getCatalogEntryIdentifier()
					.getUniqueID();
			List references = (List) catalogIdAssociation.get(uniqueID);
			if (references == null) {
				references = new ArrayList();
				catalogIdAssociation.put(uniqueID, references);
			}
			references.add(catalogEntryReference);
		

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

	/**
	 * This method will execute one CatalogEntry get service to retrieve all the
	 * catalog entries and then populate the catalog entry reference objects.
	 * 
	 * @param catentryReferences
	 * @throws CatalogEntryException
	 */
	private void populateCatalogEntryReferences(Map catalogIdAssociation)
			throws CatalogEntryException {
		final String METHODNAME = "populateCatalogEntryReferences(Map)";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			Object[] param = { catalogIdAssociation };
			LOGGER.entering(CLASSNAME, METHODNAME, param);
		}
		//	invoke catalog services
		// /CatalogEntry[CatalogEntryIdentifier[(UniqueID='catentryID' or UniqueID='catentryID...')]]+IBM_Admin_CatalogEntryDescription
		CatalogEntryFacadeClient catalogClient = new CatalogEntryFacadeClient();

		Iterator input = catalogIdAssociation.keySet().iterator();		
		StringBuffer xpathStr = new StringBuffer(
				"/CatalogEntry[CatalogEntryIdentifier[(");
		while (input.hasNext()) {
			if (xpathStr.toString().equals(
					"/CatalogEntry[CatalogEntryIdentifier[(")) {
				xpathStr.append("UniqueID=");
				xpathStr.append(input.next());
			} else {
				xpathStr.append(" or UniqueID=");
				xpathStr.append(input.next());
			}

		}
		xpathStr.append(")]]");		

		List catalogEntries = catalogClient.getCatalogEntry(
				SelectionCriteriaHelper.STR_XPATH_LANG, "{"
						+ SelectionCriteriaHelper.STR_ACCESS_PROFILE_PARAMETER
						+ "=IBM_Admin_CatalogEntryDescription}" + xpathStr);
		Iterator itr = catalogEntries.iterator();

		while (itr.hasNext()) {
			CatalogEntryType catalogEntry = (CatalogEntryType) itr.next();
			String uniqueId = catalogEntry.getCatalogEntryIdentifier()
					.getUniqueID();
			List catalogEntryReferences = (List) catalogIdAssociation
					.get(uniqueId);
			if (catalogEntryReferences != null) {

				CatalogDescriptionType description = (CatalogDescriptionType) catalogEntry
						.getDescription().get(0);

				Iterator referenceItr = catalogEntryReferences.iterator();
				while (referenceItr.hasNext()) {
					CatentryReferenceType catentryreference = (CatentryReferenceType) referenceItr
							.next();
					DescriptionType descType = getCommerceFoundationFactory()
							.createDescriptionType();
					descType.setLanguage(description.getLanguage());
					descType.setValue(description.getName());
					catentryreference.setDisplayName(descType);
				}
			}
		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

	/**
	 * Getter method which returns the <code>ProjectFactory</code>.
	 * 
	 * @return an object of type <code>ProjectFactory</code>
	 */
	protected ProjectFactory getProjectFactory() {
		return ProjectFactory.eINSTANCE;
	}

	/**
	 * This method will return the default instance of the Commerce Foundation
	 * Factory. This factory can be used to create objects defined by the
	 * Commerce Foundation.
	 * 
	 * @return The default Commerce Foundation Factory.
	 */
	protected CommerceFoundationFactory getCommerceFoundationFactory() {
		return CommerceFoundationFactory.eINSTANCE;
	}

}
