package com.mycompany.commerce.project.facade.server.commands;

/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp. 2008
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */

import java.util.List;

import com.ibm.commerce.foundation.common.exception.AbstractApplicationException;
import com.ibm.commerce.foundation.server.command.bod.bom.AbstractChangeNounPartUsingBusinessObjectMediatorCmdImpl;

/**
 * This command is used to modify the Project's basic attribute(s) of 
 * noun Project. A list of nouns and action expressions are passed to this command to act upon. 
 * 
 * This command implementation supports Add, Change, and Delete operations.
 *  
 */
public class ChangeProjectInstructionDescriptionPartCmdImpl extends
	AbstractChangeNounPartUsingBusinessObjectMediatorCmdImpl implements
	ChangeProjectPartActionCmd {



	private static final String CLASSNAME = ChangeProjectInstructionDescriptionPartCmdImpl.class
			.getName();

	private static final java.util.logging.Logger LOGGER = com.ibm.commerce.foundation.common.util.logging.LoggingHelper
			.getLogger(ChangeProjectInstructionDescriptionPartCmdImpl.class);
	
	/**
	 * This method validates whether the add action can be performed on the specified noun part to the noun.
	 * This validation will delegate to the <code>ChangeBusinessObjectPartMediator.validateAdd()</code>.  
	 * @param noun The noun to perform the operation on.
	 * @param nounPart The part of the noun to add.
	 * @param controlParameters The control parameters associated with the operation.
	 * @throws AbstractApplicationException A problem occurred while adding the noun part.
	 */
	protected void validateAdd(Object noun, Object nounPart,
			List controlParameters) throws AbstractApplicationException {
		
		final String METHODNAME = "validateAdd()";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME);
		}
		
		super.validateAdd(noun, nounPart, controlParameters);
		// TODO implement Add specific validation.
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}
	
	
	/**
	 * This method validates whether the delete action can be performed on the specified noun part to the noun.
	 * This validation will delegate to the <code>ChangeBusinessObjectPartMediator.validateDelete()</code>.
	 * @param noun The noun to perform the operation on.
	 * @param nounPart The part of the noun to delete.
	 * @param controlParameters The control parameters associated with the operation.
	 * @throws AbstractApplicationException A problem occurred while adding the noun part.
	 */
	protected void validateDelete(Object noun, Object nounPart,
			List controlParameters) throws AbstractApplicationException {
		
		final String METHODNAME = "validateAdd()";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME);
		}
		
		super.validateDelete(noun, nounPart, controlParameters);
		// TODO implement Delete specific validation.
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}
	
	/**
	 * This method validates whether the change action can be performed on the specified noun part to the noun.
	 * This validation will delegate to the <code>ChangeBusinessObjectPartMediator.validateChange()</code>.
	 * @param noun The noun to perform the operation on.
	 * @param nounPart The part of the noun to change.
	 * @param controlParameters The control parameters associated with the operation.
	 * @throws AbstractApplicationException A problem occurred while adding the noun part.
	 */
	protected void validateChange(Object noun, Object nounPart, List controlParameters) throws AbstractApplicationException {
		final String METHODNAME = "validateChange(Object,Object,List)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[]  { noun, nounPart, controlParameters });
		}
		
		super.validateChange(noun, nounPart, controlParameters);
		// TODO implement Change specific validation.
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}
	
}
