package com.mycompany.commerce.project.facade.server.commands;

import java.util.Map;
import java.util.logging.Logger;

import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.command.bod.bom.AbstractChangeNounUsingBusinessObjectMediatorCmdImpl;
import com.mycompany.commerce.project.facade.datatypes.ChangeProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.ProjectFactory;
import com.mycompany.commerce.project.facade.datatypes.RespondProjectCollectionType;
import com.ibm.commerce.oagis9.datatypes.BusinessObjectDocumentType;

/**
 * This command is the controller that changes ProjectCollection nouns.
 * The parent class will call the <code>ChangeProjectCollectionMediator</code>
 * to persist the changes to the database.  This implementation populates the response of the change request in the
 * <code>buildRespondBusinessObjectDocument</code> method.
 */
public class ChangeProjectCollectionCmdImpl extends AbstractChangeNounUsingBusinessObjectMediatorCmdImpl implements ChangeProjectCollectionCmd {


	/**
	 * The name of the class
	 */
	private static final String CLASSNAME = "com.mycompany.commerce.project.facade.server.commands.ChangeProjectCollectionCmdImpl";
	private static final Logger LOGGER = LoggingHelper.getLogger(ChangeProjectCollectionCmdImpl.class);
	
	/**
	 * This method returns the default instance of the Project Factory.
	 * This factory can be used to create objects defined by the Project component.
	 * @return This method returns the default Project Factory.
	 */
	protected ProjectFactory getProjectFactory() {
		return ProjectFactory.eINSTANCE;
	}

	/**
	 * This method will build and return the business object document that represents the
	 * response of this change request.  
	 * @param nounsAndActions A map containing all the nouns involved with this change
	 * request and the action expressions associated with the noun.
	 * @param persistentObjects The persistent objects that were passed around to the commands
	 * involved with this request.
	 * @return The business object document that represents the response for this request.
	 */
	protected BusinessObjectDocumentType buildRespondBusinessObjectDocument(Map nounsAndActions, Map persistentObjects) {
		final String METHODNAME = "buildRespondBusinessObjectDocument(Map, Map)";
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			Object[] param = { nounsAndActions, persistentObjects };
			LOGGER.entering(CLASSNAME, METHODNAME, param);
		}
		
		RespondProjectCollectionType response = getProjectFactory().createRespondProjectCollectionType();
		response.setDataArea(getProjectFactory().createRespondProjectCollectionDataAreaType());
		response.getDataArea().setRespond(getOagis9Factory().createRespondType());
		
		ChangeProjectCollectionType request = (ChangeProjectCollectionType) getRequestBusinessObjectDocument();
		response.getDataArea().getProjectCollection().addAll(request.getDataArea().getProjectCollection());
		
		if (com.ibm.commerce.foundation.common.util.logging.LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME, response);
		}
		return response;
	}

 }
