/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package com.mycompany.commerce.project.facade.datatypes.impl;

import com.ibm.commerce.foundation.common.datatypes.DescriptionType;
import com.ibm.commerce.foundation.common.datatypes.QuantityType;
import com.ibm.commerce.foundation.common.datatypes.UserDataType;

import com.mycompany.commerce.project.facade.datatypes.CatentryReferenceType;
import com.mycompany.commerce.project.facade.datatypes.ProjectMaterialIdentifierType;
import com.mycompany.commerce.project.facade.datatypes.ProjectMaterialType;
import com.mycompany.commerce.project.facade.datatypes.ProjectPackage;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.sdo.impl.EDataObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Material Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.impl.ProjectMaterialTypeImpl#getProjectMaterialIdentifier <em>Project Material Identifier</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.impl.ProjectMaterialTypeImpl#getAmount <em>Amount</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.impl.ProjectMaterialTypeImpl#getProjectMaterialDescription <em>Project Material Description</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.impl.ProjectMaterialTypeImpl#getCatalogEntry <em>Catalog Entry</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.impl.ProjectMaterialTypeImpl#getUserData <em>User Data</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ProjectMaterialTypeImpl extends EDataObjectImpl implements ProjectMaterialType {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * The cached value of the '{@link #getProjectMaterialIdentifier() <em>Project Material Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProjectMaterialIdentifier()
	 * @generated
	 * @ordered
	 */
	protected ProjectMaterialIdentifierType projectMaterialIdentifier;

	/**
	 * The cached value of the '{@link #getAmount() <em>Amount</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAmount()
	 * @generated
	 * @ordered
	 */
	protected QuantityType amount;

	/**
	 * The cached value of the '{@link #getProjectMaterialDescription() <em>Project Material Description</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProjectMaterialDescription()
	 * @generated
	 * @ordered
	 */
	protected EList projectMaterialDescription;

	/**
	 * The cached value of the '{@link #getCatalogEntry() <em>Catalog Entry</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCatalogEntry()
	 * @generated
	 * @ordered
	 */
	protected CatentryReferenceType catalogEntry;

	/**
	 * The cached value of the '{@link #getUserData() <em>User Data</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUserData()
	 * @generated
	 * @ordered
	 */
	protected UserDataType userData;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProjectMaterialTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ProjectPackage.Literals.PROJECT_MATERIAL_TYPE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProjectMaterialIdentifierType getProjectMaterialIdentifier() {
		return projectMaterialIdentifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetProjectMaterialIdentifier(ProjectMaterialIdentifierType newProjectMaterialIdentifier, NotificationChain msgs) {
		ProjectMaterialIdentifierType oldProjectMaterialIdentifier = projectMaterialIdentifier;
		projectMaterialIdentifier = newProjectMaterialIdentifier;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT_MATERIAL_TYPE__PROJECT_MATERIAL_IDENTIFIER, oldProjectMaterialIdentifier, newProjectMaterialIdentifier);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProjectMaterialIdentifier(ProjectMaterialIdentifierType newProjectMaterialIdentifier) {
		if (newProjectMaterialIdentifier != projectMaterialIdentifier) {
			NotificationChain msgs = null;
			if (projectMaterialIdentifier != null)
				msgs = ((InternalEObject)projectMaterialIdentifier).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ProjectPackage.PROJECT_MATERIAL_TYPE__PROJECT_MATERIAL_IDENTIFIER, null, msgs);
			if (newProjectMaterialIdentifier != null)
				msgs = ((InternalEObject)newProjectMaterialIdentifier).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ProjectPackage.PROJECT_MATERIAL_TYPE__PROJECT_MATERIAL_IDENTIFIER, null, msgs);
			msgs = basicSetProjectMaterialIdentifier(newProjectMaterialIdentifier, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT_MATERIAL_TYPE__PROJECT_MATERIAL_IDENTIFIER, newProjectMaterialIdentifier, newProjectMaterialIdentifier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public QuantityType getAmount() {
		return amount;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAmount(QuantityType newAmount, NotificationChain msgs) {
		QuantityType oldAmount = amount;
		amount = newAmount;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT_MATERIAL_TYPE__AMOUNT, oldAmount, newAmount);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAmount(QuantityType newAmount) {
		if (newAmount != amount) {
			NotificationChain msgs = null;
			if (amount != null)
				msgs = ((InternalEObject)amount).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ProjectPackage.PROJECT_MATERIAL_TYPE__AMOUNT, null, msgs);
			if (newAmount != null)
				msgs = ((InternalEObject)newAmount).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ProjectPackage.PROJECT_MATERIAL_TYPE__AMOUNT, null, msgs);
			msgs = basicSetAmount(newAmount, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT_MATERIAL_TYPE__AMOUNT, newAmount, newAmount));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getProjectMaterialDescription() {
		if (projectMaterialDescription == null) {
			projectMaterialDescription = new EObjectContainmentEList(DescriptionType.class, this, ProjectPackage.PROJECT_MATERIAL_TYPE__PROJECT_MATERIAL_DESCRIPTION);
		}
		return projectMaterialDescription;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CatentryReferenceType getCatalogEntry() {
		return catalogEntry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCatalogEntry(CatentryReferenceType newCatalogEntry, NotificationChain msgs) {
		CatentryReferenceType oldCatalogEntry = catalogEntry;
		catalogEntry = newCatalogEntry;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT_MATERIAL_TYPE__CATALOG_ENTRY, oldCatalogEntry, newCatalogEntry);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCatalogEntry(CatentryReferenceType newCatalogEntry) {
		if (newCatalogEntry != catalogEntry) {
			NotificationChain msgs = null;
			if (catalogEntry != null)
				msgs = ((InternalEObject)catalogEntry).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ProjectPackage.PROJECT_MATERIAL_TYPE__CATALOG_ENTRY, null, msgs);
			if (newCatalogEntry != null)
				msgs = ((InternalEObject)newCatalogEntry).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ProjectPackage.PROJECT_MATERIAL_TYPE__CATALOG_ENTRY, null, msgs);
			msgs = basicSetCatalogEntry(newCatalogEntry, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT_MATERIAL_TYPE__CATALOG_ENTRY, newCatalogEntry, newCatalogEntry));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UserDataType getUserData() {
		return userData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetUserData(UserDataType newUserData, NotificationChain msgs) {
		UserDataType oldUserData = userData;
		userData = newUserData;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT_MATERIAL_TYPE__USER_DATA, oldUserData, newUserData);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUserData(UserDataType newUserData) {
		if (newUserData != userData) {
			NotificationChain msgs = null;
			if (userData != null)
				msgs = ((InternalEObject)userData).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ProjectPackage.PROJECT_MATERIAL_TYPE__USER_DATA, null, msgs);
			if (newUserData != null)
				msgs = ((InternalEObject)newUserData).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ProjectPackage.PROJECT_MATERIAL_TYPE__USER_DATA, null, msgs);
			msgs = basicSetUserData(newUserData, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.PROJECT_MATERIAL_TYPE__USER_DATA, newUserData, newUserData));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ProjectPackage.PROJECT_MATERIAL_TYPE__PROJECT_MATERIAL_IDENTIFIER:
				return basicSetProjectMaterialIdentifier(null, msgs);
			case ProjectPackage.PROJECT_MATERIAL_TYPE__AMOUNT:
				return basicSetAmount(null, msgs);
			case ProjectPackage.PROJECT_MATERIAL_TYPE__PROJECT_MATERIAL_DESCRIPTION:
				return ((InternalEList)getProjectMaterialDescription()).basicRemove(otherEnd, msgs);
			case ProjectPackage.PROJECT_MATERIAL_TYPE__CATALOG_ENTRY:
				return basicSetCatalogEntry(null, msgs);
			case ProjectPackage.PROJECT_MATERIAL_TYPE__USER_DATA:
				return basicSetUserData(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ProjectPackage.PROJECT_MATERIAL_TYPE__PROJECT_MATERIAL_IDENTIFIER:
				return getProjectMaterialIdentifier();
			case ProjectPackage.PROJECT_MATERIAL_TYPE__AMOUNT:
				return getAmount();
			case ProjectPackage.PROJECT_MATERIAL_TYPE__PROJECT_MATERIAL_DESCRIPTION:
				return getProjectMaterialDescription();
			case ProjectPackage.PROJECT_MATERIAL_TYPE__CATALOG_ENTRY:
				return getCatalogEntry();
			case ProjectPackage.PROJECT_MATERIAL_TYPE__USER_DATA:
				return getUserData();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ProjectPackage.PROJECT_MATERIAL_TYPE__PROJECT_MATERIAL_IDENTIFIER:
				setProjectMaterialIdentifier((ProjectMaterialIdentifierType)newValue);
				return;
			case ProjectPackage.PROJECT_MATERIAL_TYPE__AMOUNT:
				setAmount((QuantityType)newValue);
				return;
			case ProjectPackage.PROJECT_MATERIAL_TYPE__PROJECT_MATERIAL_DESCRIPTION:
				getProjectMaterialDescription().clear();
				getProjectMaterialDescription().addAll((Collection)newValue);
				return;
			case ProjectPackage.PROJECT_MATERIAL_TYPE__CATALOG_ENTRY:
				setCatalogEntry((CatentryReferenceType)newValue);
				return;
			case ProjectPackage.PROJECT_MATERIAL_TYPE__USER_DATA:
				setUserData((UserDataType)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
			case ProjectPackage.PROJECT_MATERIAL_TYPE__PROJECT_MATERIAL_IDENTIFIER:
				setProjectMaterialIdentifier((ProjectMaterialIdentifierType)null);
				return;
			case ProjectPackage.PROJECT_MATERIAL_TYPE__AMOUNT:
				setAmount((QuantityType)null);
				return;
			case ProjectPackage.PROJECT_MATERIAL_TYPE__PROJECT_MATERIAL_DESCRIPTION:
				getProjectMaterialDescription().clear();
				return;
			case ProjectPackage.PROJECT_MATERIAL_TYPE__CATALOG_ENTRY:
				setCatalogEntry((CatentryReferenceType)null);
				return;
			case ProjectPackage.PROJECT_MATERIAL_TYPE__USER_DATA:
				setUserData((UserDataType)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ProjectPackage.PROJECT_MATERIAL_TYPE__PROJECT_MATERIAL_IDENTIFIER:
				return projectMaterialIdentifier != null;
			case ProjectPackage.PROJECT_MATERIAL_TYPE__AMOUNT:
				return amount != null;
			case ProjectPackage.PROJECT_MATERIAL_TYPE__PROJECT_MATERIAL_DESCRIPTION:
				return projectMaterialDescription != null && !projectMaterialDescription.isEmpty();
			case ProjectPackage.PROJECT_MATERIAL_TYPE__CATALOG_ENTRY:
				return catalogEntry != null;
			case ProjectPackage.PROJECT_MATERIAL_TYPE__USER_DATA:
				return userData != null;
		}
		return super.eIsSet(featureID);
	}

} //ProjectMaterialTypeImpl
