/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package com.mycompany.commerce.project.facade.datatypes;

import com.ibm.commerce.foundation.common.datatypes.UserDataType;

import java.math.BigInteger;

import java.util.List;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Type definition of a Project.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getProjectIdentifier <em>Project Identifier</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getTool <em>Tool</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getTimeToComplete <em>Time To Complete</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getDifficulty <em>Difficulty</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getMaterial <em>Material</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getInstruction <em>Instruction</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getDescription <em>Description</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getCollection <em>Collection</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getUserData <em>User Data</em>}</li>
 * </ul>
 * </p>
 *
 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectType()
 * @generated
 */
public interface ProjectType {
	/**
	 * Returns the value of the '<em><b>Project Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 						Project identification information
	 * 					
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Project Identifier</em>' containment reference.
	 * @see #setProjectIdentifier(ProjectIdentifierType)
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectType_ProjectIdentifier()
	 * @generated
	 */
	ProjectIdentifierType getProjectIdentifier();

	/**
	 * Sets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getProjectIdentifier <em>Project Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Project Identifier</em>' containment reference.
	 * @see #getProjectIdentifier()
	 * @generated
	 */
	void setProjectIdentifier(ProjectIdentifierType value);

	/**
	 * Returns the value of the '<em><b>Tool</b></em>' containment reference list.
	 * The list contents are of type {@link com.mycompany.commerce.project.facade.datatypes.CatentryReferenceType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 						The tools which will be used in the project. All tools must come from existing catentry.
	 * 					
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Tool</em>' containment reference list.
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectType_Tool()
	 * @generated
	 */
	List getTool();

	/**
	 * Returns the value of the '<em><b>Time To Complete</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 						The time(counted by minutes) required to complete the Project
	 * 					
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Time To Complete</em>' attribute.
	 * @see #setTimeToComplete(BigInteger)
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectType_TimeToComplete()
	 * @generated
	 */
	BigInteger getTimeToComplete();

	/**
	 * Sets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getTimeToComplete <em>Time To Complete</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Time To Complete</em>' attribute.
	 * @see #getTimeToComplete()
	 * @generated
	 */
	void setTimeToComplete(BigInteger value);

	/**
	 * Returns the value of the '<em><b>Difficulty</b></em>' attribute.
	 * The literals are from the enumeration {@link com.mycompany.commerce.project.facade.datatypes.ProjectDifficultyType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The difficult degree to complete the recipe:
	 * 						easy
	 * 						normal
	 * 						difficult
	 * 					
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Difficulty</em>' attribute.
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectDifficultyType
	 * @see #isSetDifficulty()
	 * @see #unsetDifficulty()
	 * @see #setDifficulty(ProjectDifficultyType)
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectType_Difficulty()
	 * @generated
	 */
	ProjectDifficultyType getDifficulty();

	/**
	 * Sets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getDifficulty <em>Difficulty</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Difficulty</em>' attribute.
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectDifficultyType
	 * @see #isSetDifficulty()
	 * @see #unsetDifficulty()
	 * @see #getDifficulty()
	 * @generated
	 */
	void setDifficulty(ProjectDifficultyType value);

	/**
	 * Unsets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getDifficulty <em>Difficulty</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetDifficulty()
	 * @see #getDifficulty()
	 * @see #setDifficulty(ProjectDifficultyType)
	 * @generated
	 */
	void unsetDifficulty();

	/**
	 * Returns whether the value of the '{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getDifficulty <em>Difficulty</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Difficulty</em>' attribute is set.
	 * @see #unsetDifficulty()
	 * @see #getDifficulty()
	 * @see #setDifficulty(ProjectDifficultyType)
	 * @generated
	 */
	boolean isSetDifficulty();

	/**
	 * Returns the value of the '<em><b>Material</b></em>' containment reference list.
	 * The list contents are of type {@link com.mycompany.commerce.project.facade.datatypes.ProjectMaterialType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 						The materials to build up the recipe.
	 * 					
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Material</em>' containment reference list.
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectType_Material()
	 * @generated
	 */
	List getMaterial();

	/**
	 * Returns the value of the '<em><b>Instruction</b></em>' containment reference list.
	 * The list contents are of type {@link com.mycompany.commerce.project.facade.datatypes.ProjectInstructionType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 						The instructions to complete the recipe.
	 * 					
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Instruction</em>' containment reference list.
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectType_Instruction()
	 * @generated
	 */
	List getInstruction();

	/**
	 * Returns the value of the '<em><b>Description</b></em>' containment reference list.
	 * The list contents are of type {@link com.mycompany.commerce.project.facade.datatypes.ProjectDescriptionType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 						The Project description.
	 * 					
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Description</em>' containment reference list.
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectType_Description()
	 * @generated
	 */
	List getDescription();

	/**
	 * Returns the value of the '<em><b>Collection</b></em>' containment reference list.
	 * The list contents are of type {@link com.mycompany.commerce.project.facade.datatypes.ProjectCollectionReferenceType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 						The relationship between the project and the projectcollection.
	 * 					
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Collection</em>' containment reference list.
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectType_Collection()
	 * @generated
	 */
	List getCollection();

	/**
	 * Returns the value of the '<em><b>User Data</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The element definition of a user data area.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>User Data</em>' containment reference.
	 * @see #setUserData(UserDataType)
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectType_UserData()
	 * @generated
	 */
	UserDataType getUserData();

	/**
	 * Sets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.ProjectType#getUserData <em>User Data</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>User Data</em>' containment reference.
	 * @see #getUserData()
	 * @generated
	 */
	void setUserData(UserDataType value);

} // ProjectType
