/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package com.mycompany.commerce.project.facade.datatypes;

import com.ibm.commerce.foundation.common.datatypes.QuantityType;
import com.ibm.commerce.foundation.common.datatypes.UserDataType;

import java.util.List;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Material Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * 
 * 				A material that is part of the project.
 * 			
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectMaterialType#getProjectMaterialIdentifier <em>Project Material Identifier</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectMaterialType#getAmount <em>Amount</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectMaterialType#getProjectMaterialDescription <em>Project Material Description</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectMaterialType#getCatalogEntry <em>Catalog Entry</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectMaterialType#getUserData <em>User Data</em>}</li>
 * </ul>
 * </p>
 *
 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectMaterialType()
 * @generated
 */
public interface ProjectMaterialType {
	/**
	 * Returns the value of the '<em><b>Project Material Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 					Project Material identification information
	 * 				
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Project Material Identifier</em>' containment reference.
	 * @see #setProjectMaterialIdentifier(ProjectMaterialIdentifierType)
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectMaterialType_ProjectMaterialIdentifier()
	 * @generated
	 */
	ProjectMaterialIdentifierType getProjectMaterialIdentifier();

	/**
	 * Sets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.ProjectMaterialType#getProjectMaterialIdentifier <em>Project Material Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Project Material Identifier</em>' containment reference.
	 * @see #getProjectMaterialIdentifier()
	 * @generated
	 */
	void setProjectMaterialIdentifier(ProjectMaterialIdentifierType value);

	/**
	 * Returns the value of the '<em><b>Amount</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Amount</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Amount</em>' containment reference.
	 * @see #setAmount(QuantityType)
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectMaterialType_Amount()
	 * @generated
	 */
	QuantityType getAmount();

	/**
	 * Sets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.ProjectMaterialType#getAmount <em>Amount</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Amount</em>' containment reference.
	 * @see #getAmount()
	 * @generated
	 */
	void setAmount(QuantityType value);

	/**
	 * Returns the value of the '<em><b>Project Material Description</b></em>' containment reference list.
	 * The list contents are of type {@link com.ibm.commerce.foundation.common.datatypes.DescriptionType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Project Material Description</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Project Material Description</em>' containment reference list.
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectMaterialType_ProjectMaterialDescription()
	 * @generated
	 */
	List getProjectMaterialDescription();

	/**
	 * Returns the value of the '<em><b>Catalog Entry</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 					Materials can be a simple item that is not sold in the store, or they can be an item that is in the store.
	 * 					If the material is something that is not sold in the store, ensure that you do not specify a MappedCatalogEntry.
	 * 					If the material is something that you sell in the store, ensure that you specify a MappedCatalogEntry.
	 * 				
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Catalog Entry</em>' containment reference.
	 * @see #setCatalogEntry(CatentryReferenceType)
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectMaterialType_CatalogEntry()
	 * @generated
	 */
	CatentryReferenceType getCatalogEntry();

	/**
	 * Sets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.ProjectMaterialType#getCatalogEntry <em>Catalog Entry</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Catalog Entry</em>' containment reference.
	 * @see #getCatalogEntry()
	 * @generated
	 */
	void setCatalogEntry(CatentryReferenceType value);

	/**
	 * Returns the value of the '<em><b>User Data</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The element definition of a user data area.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>User Data</em>' containment reference.
	 * @see #setUserData(UserDataType)
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectMaterialType_UserData()
	 * @generated
	 */
	UserDataType getUserData();

	/**
	 * Sets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.ProjectMaterialType#getUserData <em>User Data</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>User Data</em>' containment reference.
	 * @see #getUserData()
	 * @generated
	 */
	void setUserData(UserDataType value);

} // ProjectMaterialType
