/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package com.mycompany.commerce.project.facade.datatypes;

import com.ibm.commerce.foundation.common.datatypes.DescriptionType;
import com.ibm.commerce.foundation.common.datatypes.StoreIdentifierType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Collection Reference Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * 
 * 				A type definition of Project Collection association
 * 			
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectCollectionReferenceType#getProjectCollectionIdentifier <em>Project Collection Identifier</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectCollectionReferenceType#getStoreIdentifier <em>Store Identifier</em>}</li>
 *   <li>{@link com.mycompany.commerce.project.facade.datatypes.ProjectCollectionReferenceType#getDisplayName <em>Display Name</em>}</li>
 * </ul>
 * </p>
 *
 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectCollectionReferenceType()
 * @generated
 */
public interface ProjectCollectionReferenceType {
	/**
	 * Returns the value of the '<em><b>Project Collection Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 						The ProjectCollection bound with the association
	 * 					
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Project Collection Identifier</em>' containment reference.
	 * @see #setProjectCollectionIdentifier(ProjectCollectionIdentifierType)
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectCollectionReferenceType_ProjectCollectionIdentifier()
	 * @generated
	 */
	ProjectCollectionIdentifierType getProjectCollectionIdentifier();

	/**
	 * Sets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.ProjectCollectionReferenceType#getProjectCollectionIdentifier <em>Project Collection Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Project Collection Identifier</em>' containment reference.
	 * @see #getProjectCollectionIdentifier()
	 * @generated
	 */
	void setProjectCollectionIdentifier(ProjectCollectionIdentifierType value);

	/**
	 * Returns the value of the '<em><b>Store Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 						The identifier of the store bound with the association.
	 * 					
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Store Identifier</em>' containment reference.
	 * @see #setStoreIdentifier(StoreIdentifierType)
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectCollectionReferenceType_StoreIdentifier()
	 * @generated
	 */
	StoreIdentifierType getStoreIdentifier();

	/**
	 * Sets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.ProjectCollectionReferenceType#getStoreIdentifier <em>Store Identifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Store Identifier</em>' containment reference.
	 * @see #getStoreIdentifier()
	 * @generated
	 */
	void setStoreIdentifier(StoreIdentifierType value);

	/**
	 * Returns the value of the '<em><b>Display Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 						The description of the Collection referenced by this object.
	 * 						This element is not persisted for a Change request.  It is read only.
	 * 					
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Display Name</em>' containment reference.
	 * @see #setDisplayName(DescriptionType)
	 * @see com.mycompany.commerce.project.facade.datatypes.ProjectPackage#getProjectCollectionReferenceType_DisplayName()
	 * @generated
	 */
	DescriptionType getDisplayName();

	/**
	 * Sets the value of the '{@link com.mycompany.commerce.project.facade.datatypes.ProjectCollectionReferenceType#getDisplayName <em>Display Name</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Display Name</em>' containment reference.
	 * @see #getDisplayName()
	 * @generated
	 */
	void setDisplayName(DescriptionType value);

} // ProjectCollectionReferenceType
