package com.mycompany.commerce.project.facade;
/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp.  2008
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */
import java.util.List;

import junit.framework.TestCase;

import com.ibm.commerce.foundation.common.datatypes.CommerceFoundationFactory;
import com.ibm.commerce.foundation.common.datatypes.ContextDataType;
import com.ibm.commerce.foundation.common.datatypes.DescriptionType;
import com.mycompany.commerce.project.facade.ProjectFacadeConstants;
import com.mycompany.commerce.project.facade.datatypes.AcknowledgeProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.AcknowledgeProjectType;
import com.mycompany.commerce.project.facade.datatypes.ProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.ProjectDescriptionType;
import com.mycompany.commerce.project.facade.datatypes.ProjectType;
import com.mycompany.commerce.project.facade.datatypes.RespondProjectType;
import com.mycompany.commerce.project.facade.datatypes.ShowProjectCollectionType;
import com.mycompany.commerce.project.facade.datatypes.ShowProjectType;
import com.mycompany.commerce.project.facade.client.ProjectFacadeClient;
/**
 * This class represents a set of test cases for testing the Project facade
 * client.
 */
public class ProjectFacadeClientTest extends junit.framework.TestCase {

	/**
	 * The user id to associate with these unit tests.
	 */
	// TODO: Change the username and password to match the server. 
	private static final String USER_ID = "wcsadmin";

	/**
	 * The password of the user id for these unit tests.
	 */	
	private static final String PASSWORD = "wcs1admin";

	//	 Define test inputs
	private String test_project_uid = "2001";

	private String test_projectcol_uid = "2001";

	private String test_catentry_uid = "11269";

	private String test_name = "Penne";

	private static String generatedUID = "";

	// TODO: modify the test storeID
	private String storeID = "11301";
	

	private ProjectFacadeClient iClient = null;

	/**
	 * Create an instance of the Project Facade Client test case.
	 * 
	 * @param method
	 *            The test method to execute.
	 */
	public ProjectFacadeClientTest(String method) {
		super(method);
	}

	/**
	 * Set up any additional information required in order to run any test
	 * method. As part of the setup, the client library will be instantiated for
	 * the test case.
	 * 
	 * @exception A
	 *                problem with the setup process.
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();

		// construct the callback handler
		javax.security.auth.callback.CallbackHandler callbackHandler = new com.ibm.commerce.foundation.client.samples.security.auth.callback.SampleCallbackHandlerImpl(
				USER_ID, PASSWORD);

		// construct business context
		com.ibm.commerce.foundation.common.datatypes.BusinessContextType businessContext = com.ibm.commerce.foundation.common.datatypes.CommerceFoundationFactory.eINSTANCE
				.createBusinessContextType();

		ContextDataType storeId = CommerceFoundationFactory.eINSTANCE
				.createContextDataType();
		storeId.setName("storeId");
		storeId.setValue(storeID);
		businessContext.getContextData().add(storeId);
		

		// construct the facade client
		iClient = new ProjectFacadeClient(businessContext, callbackHandler);
	}

	/**
	 * Remove any data or setting related to running any test method.
	 * 
	 * @exception A
	 *                problem with the tear down process.
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * This method tests GetProject BOD 1. Get by unique id 2. MyCompany_All as
	 * access profile.
	 */
	public void testGetProjectByUIDWithAllAccessProfile() {

		System.out.println("========= START OF GET ALL TEST =========");

		// send the request
		ShowProjectType showProject = iClient
				.getProjectByUID(
						test_project_uid,
						ProjectFacadeConstants.ACCESS_PROFILE_ADMIN_DETAILS_INFORMATION);

		// verify response
		List errorList = showProject.getDataArea().getShow()
				.getResponseCriteria();

		if (errorList != null && errorList.size() != 0) {
			fail("Test Case failed because the response has error");
		}

		showProject = iClient
				.getProjectByCatentryUID(
						test_catentry_uid,
						ProjectFacadeConstants.ACCESS_PROFILE_STORE_SUMMARY_INFORMATION);
		//verify response
		errorList = showProject.getDataArea().getShow().getResponseCriteria();

		if (errorList != null && errorList.size() != 0) {
			fail("Test Case failed because the response has error");
		}
		showProject = iClient
				.getProjectByPrjcolUID(
						test_projectcol_uid,
						ProjectFacadeConstants.ACCESS_PROFILE_STORE_SUMMARY_INFORMATION);
		//verify response
		errorList = showProject.getDataArea().getShow().getResponseCriteria();

		if (errorList != null && errorList.size() != 0) {
			fail("Test Case failed because the response has error");
		}
		showProject = iClient
				.getProjectByName(
						test_name,
						ProjectFacadeConstants.ACCESS_PROFILE_STORE_DETAILS_INFORMATION);
		//verify response
		errorList = showProject.getDataArea().getShow().getResponseCriteria();

		if (errorList != null && errorList.size() != 0) {
			fail("Test Case failed because the response has error");
		}
		ShowProjectCollectionType showProjectCollection = iClient
				.getProjectCollectionAll(ProjectFacadeConstants.ACCESS_PROFILE_STORE_DETAILS_INFORMATION);
		//verify response
		errorList = showProjectCollection.getDataArea().getShow()
				.getResponseCriteria();

		if (errorList != null && errorList.size() != 0) {
			fail("Test Case failed because the response has error");
		}

		System.out.println("======================");
		System.out.println("Test Case passed !!!!!");
		System.out.println("======================");
		System.out.println("========= END OF GET ALL TEST =========");

	}

	/**
	 * This method tests create Project by sending the ProcessProject BOD with
	 * action add.
	 */
	public void testProcessProjectCreate() {

		System.out
				.println("========= START OF PROCESS BY NAME CREATE TEST =========");

		// define test inputs
		String projectName = "Test" + generateUniqueIdentifier();

		String description = "Project " + projectName + " Description";

		// =========================
		// Create the BOD request for creating Project
		// =========================
		AcknowledgeProjectType acknowledgeProject = iClient.createProject(
				projectName, description);

		// =========================
		// Verify the BOD response
		// =========================

		// verify name in response
		String resultName = ((ProjectType) acknowledgeProject.getDataArea()
				.getProject().get(0)).getProjectIdentifier()
				.getExternalIdentifier().getName();
		assertEquals("Test case failed because actual result '" + resultName
				+ "' is not equals to the expceted result " + projectName,
				resultName, projectName);

		// verify desription in response
		String resultDescription = ((ProjectDescriptionType) ((ProjectType) acknowledgeProject
				.getDataArea().getProject().get(0)).getDescription().get(0))
				.getShortDescription();

		assertEquals("Test case failed because actual result '"
				+ resultDescription + "' is not equals to the expceted result "
				+ description, resultDescription, description);

		generatedUID = ((ProjectType) acknowledgeProject.getDataArea()
				.getProject().get(0)).getProjectIdentifier().getUniqueID();
		System.out.println("======================");
		System.out.println("Test Case passed !!!!!");
		System.out.println("======================");

		System.out.println("========= END OF PROCESS CREATE TEST  =========");
	}

	/**
	 * This method tests the ChangeProject BOD. It changes the name and
	 * description of the noun
	 */
	public void testZChangeProjectNameAndDescription() {

		System.out.println("========= START OF CHANGE NAME TEST =========");

		// define test inputs

		String name = "Project  - " + generateUniqueIdentifier();

		String description = name + " description "
				+ generateUniqueIdentifier();

		// send out a request
		RespondProjectType respondProject = iClient.changeProjectName(
				generatedUID, name);

		respondProject = iClient.changeProjectDesc(generatedUID, description);

		System.out.println("======================");
		System.out.println("Test Case passed !!!!!");
		System.out.println("======================");

		//deleteProject(uid, description);
		System.out.println("========= END OF CHANGE NAME TEST =========");
	}

	/**
	 * This method tests create ProjectCollection by sending the
	 * ProcessProjectCollection BOD with action add.
	 */
	public void testProcessProjectCollectionCreate() {

		System.out
				.println("========= START OF PROCESS BY NAME CREATE TEST =========");

		// define test inputs
		String projectcollectionName = "Test " + generateUniqueIdentifier();

		String description = "ProjectCollection " + projectcollectionName
				+ " Description";

		// =========================
		// Create the BOD request for creating ProjectCollection
		// =========================
		AcknowledgeProjectCollectionType acknowledgeProjectCollection = iClient
				.createProjectCollection(projectcollectionName, description);

		// =========================
		// Verify the BOD response
		// =========================

		// verify name in response
		String resultName = ((ProjectCollectionType) acknowledgeProjectCollection
				.getDataArea().getProjectCollection().get(0))
				.getProjectCollectionIdentifier().getExternalIdentifier()
				.getName();
		assertEquals("Test case failed because actual result '" + resultName
				+ "' is not equals to the expceted result "
				+ projectcollectionName, resultName, projectcollectionName);

		// verify desription in response
		String resultDescription = ((DescriptionType) ((ProjectCollectionType) acknowledgeProjectCollection
				.getDataArea().getProjectCollection().get(0)).getDescription()
				.get(0)).getValue();
		assertEquals("Test case failed because actual result '"
				+ resultDescription + "' is not equals to the expceted result "
				+ description, resultDescription, description);

		System.out.println("======================");
		System.out.println("Test Case passed !!!!!");
		System.out.println("======================");

		System.out.println("========= END OF PROCESS CREATE TEST  =========");
	}

	/**
	 * Generates and returns a 6 digit unique identifier using current system
	 * time
	 * 
	 * @return a unique identifier
	 */
	private String generateUniqueIdentifier() {
		return generateUniqueIdentifier(6);
	}

	/**
	 * Generates and returns a unique identifier using current system time
	 * 
	 * @param number
	 *            of digit that unique identifier should contain (Less than 10)
	 * @return a unique identifier
	 */
	private String generateUniqueIdentifier(int numberOfDigit) {
		// Generate unique id
		long currentime = System.currentTimeMillis();
		currentime = currentime % (Math.round(Math.pow(10, numberOfDigit)));
		return String.valueOf(currentime);
	}

}
