package com.mycompany.commerce.project.facade.server.services.dataaccess.bom.mediator;
/*
 *-----------------------------------------------------------------
 * IBM Confidential
 *
 * OCO Source Materials
 *
 * WebSphere Commerce
 *
 * (C) Copyright IBM Corp.  2008
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 *-----------------------------------------------------------------
 */
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import com.ibm.commerce.foundation.common.datatypes.CatalogEntryIdentifierType;
import com.ibm.commerce.foundation.common.datatypes.CommerceFoundationFactory;
import com.ibm.commerce.foundation.common.datatypes.DescriptionType;
import com.ibm.commerce.foundation.common.datatypes.QuantityType;
import com.ibm.commerce.foundation.common.datatypes.StoreIdentifierType;
import com.ibm.commerce.foundation.common.util.logging.LoggingHelper;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.exception.BusinessObjectMediatorException;
import com.ibm.commerce.foundation.server.services.dataaccess.bom.mediator.AbstractReadBusinessObjectPartMediatorImpl;
import com.mycompany.commerce.project.facade.datatypes.CatentryReferenceType;
import com.mycompany.commerce.project.facade.datatypes.ProjectFactory;
import com.mycompany.commerce.project.facade.datatypes.ProjectMaterialExternalIdentifierType;
import com.mycompany.commerce.project.facade.datatypes.ProjectMaterialIdentifierType;
import com.mycompany.commerce.project.facade.datatypes.ProjectMaterialType;
import com.mycompany.commerce.project.facade.datatypes.ProjectType;
import com.mycompany.commerce.project.facade.server.entity.datatypes.Xprjmtr;
import com.mycompany.commerce.project.facade.server.entity.datatypes.Xprjmtrcatrel;
import com.mycompany.commerce.project.facade.server.entity.datatypes.Xprjmtrdes;
import com.mycompany.commerce.project.facade.server.entity.datatypes.Xproject;
import com.mycompany.commerce.project.facade.server.helpers.ProjectComponentHelper;

/**
 * Read operation on the logical noun for Project
 */
public class ReadProjectMaterialPartMediator extends
		AbstractReadBusinessObjectPartMediatorImpl {

	private static final String CLASSNAME = ReadProjectMaterialPartMediator.class
			.getName();

	private static final Logger LOGGER = LoggingHelper
			.getLogger(ReadProjectMaterialPartMediator.class);

	/**
	 * This method reads the logical Project description noun part and adds it to the main Project noun.
	 * @param aLogicalEntityType The root noun which will contain the noun part built through this mediator.
	 * @param aPhysicalEntityType The root physical data object.
	 * @throws BusinessObjectMediatorException
	 */
	public void buildNounPart(Object aLogicalEntityType,
			Object aPhysicalEntityType) throws BusinessObjectMediatorException {
		final String METHODNAME = "buildNounPart";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] {
					aLogicalEntityType, aPhysicalEntityType });
		}

		if (aPhysicalEntityType != null) {
			ProjectType aProjectLogicalDO = (ProjectType) aLogicalEntityType;
			Xproject aProjectPhysicalDO = (Xproject) aPhysicalEntityType;

			// build the logical SDO by using the Phyical SDO 

			List aListMtr = aProjectPhysicalDO.getXprjmtrForXproject();
			if (aListMtr != null) {
				Iterator objIter = aListMtr.iterator();

				while (objIter.hasNext()) {

					Xprjmtr aPhysicalMtr = (Xprjmtr) objIter.next();

					ProjectMaterialType materialType = getProjectFactory()
							.createProjectMaterialType();
					QuantityType quantity = getCommerceFoundationFactory()
							.createQuantityType();
					quantity.setUom(aPhysicalMtr.getQtyunit_id());
					quantity.setValue(aPhysicalMtr.getAmount().doubleValue());
					materialType.setAmount(quantity);
					buildMaterialIdentifier(materialType, aPhysicalMtr);
					buildMaterialDescription(materialType, aPhysicalMtr);
					buildMaterialCatentry(materialType, aPhysicalMtr);
					aProjectLogicalDO.getMaterial().add(materialType);

				}
			}

		}

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

	private void buildMaterialCatentry(ProjectMaterialType materialType,
			Xprjmtr aPhysicalMtr) {
		final String METHODNAME = "buildMaterialCatentry";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { materialType,
					aPhysicalMtr });
		}

		List aListCatRel = aPhysicalMtr.getXprjmtrcatrelForXprjmtr();
		if (aListCatRel != null) {
			Iterator objIter = aListCatRel.iterator();
			Integer storeId = ProjectComponentHelper.getStoreId();
			while (objIter.hasNext()) {

				Xprjmtrcatrel aPhysicalCatRel = (Xprjmtrcatrel) objIter.next();

				CatentryReferenceType catentryType = getProjectFactory()
						.createCatentryReferenceType();

				CatalogEntryIdentifierType catentryIdentifier = CommerceFoundationFactory.eINSTANCE
						.createCatalogEntryIdentifierType();

				catentryType.setCatalogEntryIdentifier(catentryIdentifier);
				String catentryID = String.valueOf(aPhysicalCatRel
						.getCatentry_id());
				catentryIdentifier.setUniqueID(catentryID);

				StoreIdentifierType storeIdentifier = getCommerceFoundationFactory()
						.createStoreIdentifierType();
				catentryType.setStoreIdentifier(storeIdentifier);

				storeIdentifier.setUniqueID(String.valueOf(aPhysicalCatRel
						.getStoreent_id()));

				materialType.setCatalogEntry(catentryType);
				//set local store catentrel
				if (storeId.intValue() == aPhysicalCatRel.getStoreent_id()) {
					break;
				}
			}
		}
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

	private void buildMaterialDescription(ProjectMaterialType materialType,
			Xprjmtr aPhysicalMtr) {
		final String METHODNAME = "buildMaterialDescription";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { materialType,
					aPhysicalMtr });
		}

		List aListDescription = aPhysicalMtr.getXprjmtrdesForXprjmtr();
		if (aListDescription != null) {
			Iterator objIter = aListDescription.iterator();

			while (objIter.hasNext()) {

				Xprjmtrdes aDescription = (Xprjmtrdes) objIter.next();

				DescriptionType descriptionType = getCommerceFoundationFactory()
						.createDescriptionType();
				descriptionType.setLanguage(Integer.toString(aDescription
						.getLanguage_id()));
				descriptionType.setValue(aDescription.getShortdesc());

				materialType.getProjectMaterialDescription().add(
						descriptionType);
			}
		}
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}
	}

	private void buildMaterialIdentifier(ProjectMaterialType materialType,
			Xprjmtr aPhysicalMtr) {

		final String METHODNAME = "buildMaterialIdentifier";
		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.entering(CLASSNAME, METHODNAME, new Object[] { materialType,
					aPhysicalMtr });
		}

		// create the ID object and set to the logical data object
		ProjectMaterialIdentifierType aProjectMtrIdentifier = getProjectFactory()
				.createProjectMaterialIdentifierType();
		materialType.setProjectMaterialIdentifier(aProjectMtrIdentifier);

		// set the uid in ID object
		aProjectMtrIdentifier.setUniqueID(Long.toString(aPhysicalMtr
				.getXprjmtr_id()));

		// set the name in ID object
		ProjectMaterialExternalIdentifierType exId = getProjectFactory()
				.createProjectMaterialExternalIdentifierType();
		aProjectMtrIdentifier.setExternalIdentifier(exId);
		exId.setName(aPhysicalMtr.getPrjmtrname());

		if (LoggingHelper.isEntryExitTraceEnabled(LOGGER)) {
			LOGGER.exiting(CLASSNAME, METHODNAME);
		}

	}

	/**
	 * Getter method which returns the <code>ProjectFactory</code>. 
	 * @return an object of type <code>ProjectFactory</code>
	 */
	protected ProjectFactory getProjectFactory() {
		return ProjectFactory.eINSTANCE;
	}

	/**
	 * This method will return the default instance of the Commerce Foundation Factory.
	 * This factory can be used to create objects defined by the Commerce Foundation.
	 * @return The default Commerce Foundation Factory.
	 */
	protected CommerceFoundationFactory getCommerceFoundationFactory() {
		return CommerceFoundationFactory.eINSTANCE;
	}

}
